/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import org.badvision.outlaweditor.TileEditor;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.PropertyHelper;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.TilesetUtils;
import org.badvision.outlaweditor.data.xml.PlatformData;
import org.badvision.outlaweditor.data.xml.Tile;
import org.badvision.outlaweditor.ui.ApplicationUIController;
import org.badvision.outlaweditor.ui.EntitySelectorCell;
import org.badvision.outlaweditor.ui.TileEditorTabController;
import org.badvision.outlaweditor.ui.UIAction;
import org.badvision.outlaweditor.ui.impl.ApplicationUIControllerImpl;

public class TileEditorTabControllerImpl
extends TileEditorTabController {
    ChangeListener rebuildListener = (value, oldValue, newValue) -> this.rebuildTileSelectors();

    @Override
    public void onCurrentTileSelected(ActionEvent event) {
        this.setCurrentTile((Tile)this.tileSelector.getSelectionModel().getSelectedItem());
    }

    @Override
    public void onTileClonePressed(ActionEvent event) {
        ApplicationUIController mainController = ApplicationUIController.getController();
        if (this.getCurrentTile() == null) {
            return;
        }
        Tile t = new Tile();
        TileUtils.getId(t);
        t.setName(this.getCurrentTile().getName() + " (clone)");
        t.setObstruction(this.getCurrentTile().isObstruction());
        t.setSprite(this.getCurrentTile().isSprite());
        t.setBlocker(this.getCurrentTile().isBlocker());
        t.setCategory(this.getCurrentTile().getCategory());
        this.getCurrentTile().getDisplayData().stream().map(d -> {
            PlatformData p = new PlatformData();
            p.setHeight(d.getHeight());
            p.setWidth(d.getWidth());
            p.setPlatform(d.getPlatform());
            p.setValue(Arrays.copyOf(d.getValue(), d.getValue().length));
            return p;
        }).forEach(p -> t.getDisplayData().add((PlatformData)p));
        TilesetUtils.add(t);
        mainController.rebuildTileSelectors();
        this.setCurrentTile(t);
    }

    @Override
    public void onTileCreatePressed(ActionEvent event) {
        ApplicationUIController mainController = ApplicationUIController.getController();
        Tile t = TileUtils.newTile();
        t.setName("Untitled");
        TilesetUtils.add(t);
        mainController.rebuildTileSelectors();
        this.setCurrentTile(t);
    }

    @Override
    public void onTileDeletePressed(ActionEvent event) {
        ApplicationUIController mainController = ApplicationUIController.getController();
        if (this.getCurrentTile() == null) {
            return;
        }
        UIAction.confirm("Delete tile '" + this.getCurrentTile().getName() + "'.  Are you sure?", () -> {
            Tile del = this.getCurrentTile();
            this.setCurrentTile(null);
            ApplicationState.getInstance().getGameData().getTile().remove(del);
            mainController.rebuildTileSelectors();
        }, null);
    }

    @Override
    public void tileBitMode(ActionEvent event) {
        if (this.getCurrentTileEditor() != null) {
            this.getCurrentTileEditor().setDrawMode(TileEditor.DrawMode.Toggle);
        }
    }

    @Override
    public void tileDraw1BitMode(ActionEvent event) {
        if (this.getCurrentTileEditor() != null) {
            this.getCurrentTileEditor().setDrawMode(TileEditor.DrawMode.Pencil1px);
        }
    }

    @Override
    public void tileDraw3BitMode(ActionEvent event) {
        if (this.getCurrentTileEditor() != null) {
            this.getCurrentTileEditor().setDrawMode(TileEditor.DrawMode.Pencil3px);
        }
    }

    @Override
    public void tileShift(ActionEvent event) {
        if (this.getCurrentTileEditor() != null) {
            this.getCurrentTileEditor().showShiftUI();
        }
    }

    @Override
    public void onTileExportPressed(ActionEvent event) {
        this.getCurrentTileEditor().copy();
        UIAction.alert("Tile copied to the clipboard; use Paste Special in your target application to import this tile as an image, data, or a styled table (HTML)");
    }

    public void initialize() {
        assert (this.tileCategoryField != null) : "fx:id=\"tileCategoryField\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileEditorAnchorPane != null) : "fx:id=\"tileEditorAnchorPane\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileIdField != null) : "fx:id=\"tileIdField\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileNameField != null) : "fx:id=\"tileNameField\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileObstructionField != null) : "fx:id=\"tileObstructionField\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileSpriteField != null) : "fx:id=\"tileSpriteField\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileBlockerField != null) : "fx:id=\"tileBlockerField\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tilePatternMenu != null) : "fx:id=\"tilePatternMenu\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        assert (this.tileSelector != null) : "fx:id=\"tileSelector\" was not injected: check your FXML file 'tileEditorTab.fxml'.";
        this.tileSelector.setCellFactory(param -> new EntitySelectorCell<Tile>(this.tileNameField, this.tileCategoryField){

            @Override
            public void finishUpdate(Tile item) {
                this.setGraphic((Node)new ImageView((Image)TileUtils.getImage(item, ApplicationState.getInstance().getCurrentPlatform())));
            }
        });
        this.tileSelector.setConverter((StringConverter)new StringConverter<Tile>(){

            public String toString(Tile object) {
                return String.valueOf(object.getCategory() + "/" + object.getName());
            }

            public Tile fromString(String string) {
                return null;
            }
        });
    }

    @Override
    public void setCurrentTileEditor(TileEditor editor) {
        if (editor != null) {
            editor.buildEditorUI((Pane)this.tileEditorAnchorPane);
            editor.buildPatternSelector(this.tilePatternMenu);
        }
        super.setCurrentTileEditor(editor);
    }

    @Override
    public void setCurrentTile(Tile t) {
        this.tileNameField.textProperty().removeListener(this.rebuildListener);
        this.tileCategoryField.textProperty().removeListener(this.rebuildListener);
        this.tileSelector.getSelectionModel().select((Object)t);
        if (t != null && t.equals(this.getCurrentTile())) {
            return;
        }
        this.tileEditorAnchorPane.getChildren().clear();
        if (t == null) {
            PropertyHelper.bind((Property)this.tileIdField.textProperty(), null);
            PropertyHelper.bind((Property)this.tileCategoryField.textProperty(), null);
            PropertyHelper.bind((Property)this.tileObstructionField.selectedProperty(), null);
            PropertyHelper.bind((Property)this.tileSpriteField.selectedProperty(), null);
            PropertyHelper.bind((Property)this.tileBlockerField.selectedProperty(), null);
            PropertyHelper.bind((Property)this.tileNameField.textProperty(), null);
            this.tileIdField.setDisable(true);
            this.tileCategoryField.setDisable(true);
            this.tileObstructionField.setDisable(true);
            this.tileSpriteField.setDisable(true);
            this.tileBlockerField.setDisable(true);
            this.tileNameField.setDisable(true);
            this.setCurrentTileEditor(null);
        } else {
            if (t.isObstruction() == null) {
                t.setObstruction(false);
            }
            if (t.isSprite() == null) {
                t.setSprite(false);
            }
            if (t.isBlocker() == null) {
                t.setBlocker(false);
            }
            try {
                this.tileIdField.setDisable(false);
                this.tileCategoryField.setDisable(false);
                this.tileObstructionField.setDisable(false);
                this.tileSpriteField.setDisable(false);
                this.tileBlockerField.setDisable(false);
                this.tileNameField.setDisable(false);
                PropertyHelper.bind((Property)this.tileIdField.textProperty(), (Property)PropertyHelper.stringProp(t, "id"));
                PropertyHelper.bind((Property)this.tileCategoryField.textProperty(), (Property)PropertyHelper.stringProp(t, "category"));
                PropertyHelper.bind((Property)this.tileObstructionField.selectedProperty(), (Property)PropertyHelper.boolProp(t, "obstruction"));
                PropertyHelper.bind((Property)this.tileSpriteField.selectedProperty(), (Property)PropertyHelper.boolProp(t, "sprite"));
                PropertyHelper.bind((Property)this.tileBlockerField.selectedProperty(), (Property)PropertyHelper.boolProp(t, "blocker"));
                PropertyHelper.bind((Property)this.tileNameField.textProperty(), (Property)PropertyHelper.stringProp(t, "name"));
                TileEditor editor = ApplicationState.getInstance().getCurrentPlatform().tileEditor.newInstance();
                editor.setEntity(t);
                this.setCurrentTileEditor(editor);
                this.tileNameField.textProperty().addListener(this.rebuildListener);
                this.tileCategoryField.textProperty().addListener(this.rebuildListener);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(ApplicationUIController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(ApplicationUIControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        super.setCurrentTile(t);
    }

    @Override
    public void rebuildTileSelectors() {
        Tile t = this.getCurrentTile();
        this.tileSelector.getItems().clear();
        List<Tile> allTiles = ApplicationState.getInstance().getGameData().getTile();
        allTiles.sort((o1, o2) -> {
            int c1 = String.valueOf(o1.getCategory()).compareTo(String.valueOf(o2.getCategory()));
            if (c1 != 0) {
                return c1;
            }
            return String.valueOf(o1.getName()).compareTo(String.valueOf(o2.getName()));
        });
        this.tileSelector.getItems().addAll(allTiles);
        this.tileSelector.getSelectionModel().select(allTiles.indexOf(this.getCurrentTile()));
        this.setCurrentTile(t);
    }
}

