/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javax.xml.bind.JAXBException;
import org.badvision.outlaweditor.SheetEditor;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.data.xml.Columns;
import org.badvision.outlaweditor.data.xml.Rows;
import org.badvision.outlaweditor.data.xml.UserType;
import org.badvision.outlaweditor.ui.ApplicationUIController;
import org.badvision.outlaweditor.ui.SheetEditorController;
import org.badvision.outlaweditor.ui.UIAction;

public class SheetEditorControllerImpl
extends SheetEditorController {
    private SheetEditor editor;
    private ObservableList<Rows.Row> tableData;
    private final ListChangeListener columnChangeListener = c -> this.syncData();

    public void initialize(URL url, ResourceBundle rb) {
        super.initialize();
        this.tableData = FXCollections.observableArrayList();
        this.table.setItems(this.tableData);
        this.table.setEditable(true);
        this.table.setRowFactory(tableView -> {
            TableRow row = new TableRow();
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{this.createMenuItem("Insert Row", () -> this.tableData.add(row.getIndex(), (Object)new Rows.Row())), this.createMenuItem("Clone Row", () -> this.cloneRow((Rows.Row)row.getItem())), this.createMenuItem("Delete Row", () -> this.deleteRowWithConfirmation((Rows.Row)row.getItem()))});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)contextMenu));
            return row;
        });
    }

    @Override
    public void doImport(ActionEvent event) {
        List<List<String>> data;
        FileChooser openFileDialog = new FileChooser();
        openFileDialog.setTitle("Select either a text or an Excel file");
        File selected = openFileDialog.showOpenDialog(null);
        if (selected != null && selected.exists() && selected.isFile() && (data = DataUtilities.readFromFile(selected)) != null && data.size() > 1) {
            this.tableData.clear();
            this.editor.getSheet().setColumns(new Columns());
            data.get(0).stream().map(s -> s != null && !s.isEmpty() ? s : "---").map(name -> {
                UserType type = new UserType();
                type.setName((String)name);
                return type;
            }).collect(Collectors.toCollection(this.editor.getSheet().getColumns()::getColumn));
            this.editor.getSheet().setRows(new Rows());
            data.stream().skip(1L).map(cols -> {
                Rows.Row r = new Rows.Row();
                for (int i = 0; i < cols.size(); ++i) {
                    if (cols.get(i) == null) continue;
                    DataUtilities.setValue(r.getOtherAttributes(), (String)((List)data.get(0)).get(i), (String)cols.get(i));
                }
                return r;
            }).filter(r -> !r.getOtherAttributes().isEmpty()).collect(Collectors.toCollection(this.editor.getSheet().getRows()::getRow));
            this.buildTableFromSheet();
        }
    }

    public void setEditor(SheetEditor editor) {
        this.tableData.clear();
        this.editor = editor;
        this.buildTableFromSheet();
    }

    @Override
    public void addColumnAction(ActionEvent event) {
        String newColName = UIAction.getText("Enter new column name", "new");
        if (newColName != null && !newColName.isEmpty()) {
            UserType col = new UserType();
            col.setName(newColName);
            if (this.editor.getSheet().getColumns() == null) {
                this.editor.getSheet().setColumns(new Columns());
            }
            this.editor.getSheet().getColumns().getColumn().add(col);
            this.insertViewColumn(col);
        }
    }

    @Override
    public void addRowAction(ActionEvent event) {
        this.insertViewRow(new Rows.Row());
    }

    private void buildTableFromSheet() {
        this.table.getColumns().removeListener(this.columnChangeListener);
        if (this.editor.getSheet().getColumns() != null) {
            this.editor.getSheet().getColumns().getColumn().stream().forEach(this::insertViewColumn);
        }
        if (this.editor.getSheet().getRows() != null) {
            this.tableData.setAll(this.editor.getSheet().getRows().getRow());
        }
        this.sheetNameField.textProperty().set((Object)this.editor.getSheet().getName());
        this.sheetNameField.textProperty().addListener((value, oldValue, newValue) -> {
            this.editor.getSheet().setName((String)newValue);
            ApplicationUIController.getController().updateSelectors();
        });
        this.table.getColumns().addListener(this.columnChangeListener);
    }

    private void insertViewColumn(UserType col) {
        this.insertViewColumn(col, -1);
    }

    private void insertViewColumn(final UserType col, int pos) {
        if (pos < 0) {
            pos = this.table.getColumns().size();
        }
        TableColumn tableCol = new TableColumn(col.getName());
        tableCol.setCellValueFactory(features -> {
            String val = DataUtilities.getValue(((Rows.Row)features.getValue()).getOtherAttributes(), col.getName());
            if (val == null) {
                val = "";
            }
            return new SimpleObjectProperty((Object)val);
        });
        tableCol.setCellFactory(param -> {
            TextFieldTableCell<Rows.Row, String> myCell = new TextFieldTableCell<Rows.Row, String>((StringConverter)new DefaultStringConverter()){

                public void startEdit() {
                    super.startEdit();
                    TextField textField = (TextField)this.getGraphic();
                    textField.textProperty().addListener((p, o, n) -> {
                        this.setItem(n);
                        int index = this.getTableRow().getIndex();
                        Rows.Row row = (Rows.Row)SheetEditorControllerImpl.this.tableData.get(index);
                        DataUtilities.setValue(row.getOtherAttributes(), col.getName(), n);
                    });
                }
            };
            return myCell;
        });
        tableCol.setOnEditCommit(event -> {
            this.table.requestFocus();
            this.table.getSelectionModel().clearSelection();
        });
        tableCol.setEditable(true);
        tableCol.setContextMenu(new ContextMenu(new MenuItem[]{this.createMenuItem("Rename Column", () -> this.renameColumn(col)), this.createMenuItem("Delete Column", () -> this.deleteColumnWithConfirmation(col))}));
        this.table.getColumns().add(pos, (Object)tableCol);
    }

    private void insertViewRow(Rows.Row row) {
        this.tableData.add((Object)row);
        this.syncData();
    }

    private MenuItem createMenuItem(String text, Runnable action) {
        MenuItem menuItem = new MenuItem(text);
        menuItem.setOnAction(evt -> action.run());
        return menuItem;
    }

    private void deleteColumnWithConfirmation(UserType col) {
        UIAction.confirm("Are you sure you want to delete column " + col.getName() + "?", () -> this.deleteColumn(col), null);
    }

    private void renameColumn(UserType col) {
        String newColName = UIAction.getText("Enter new column name", col.getName());
        if (newColName != null && !newColName.isEmpty() && !col.getName().equals(newColName)) {
            UserType newCol = new UserType();
            newCol.setName(newColName);
            this.editor.getSheet().getColumns().getColumn().add(newCol);
            this.tableData.forEach(row -> DataUtilities.setValue(row.getOtherAttributes(), newColName, DataUtilities.getValue(row.getOtherAttributes(), col.getName())));
            int oldPos = this.deleteColumn(col);
            this.insertViewColumn(newCol, oldPos);
        }
    }

    private int deleteColumn(UserType col) {
        this.editor.getSheet().getColumns().getColumn().remove(col);
        this.tableData.stream().map(Rows.Row::getOtherAttributes).forEach(m -> m.keySet().removeIf(n -> n.getLocalPart().equals(col.getName())));
        int colNumber = this.findColumn(col);
        if (colNumber >= 0) {
            this.table.getColumns().remove(colNumber);
        }
        return colNumber;
    }

    private void deleteRowWithConfirmation(Rows.Row row) {
        UIAction.confirm("Delete row, are you sure?", () -> this.tableData.remove((Object)row), () -> {});
    }

    private void cloneRow(Rows.Row row) {
        try {
            Rows.Row newRow = TransferHelper.cloneObject(row, Rows.Row.class, "row");
            this.tableData.add(this.tableData.lastIndexOf((Object)row), (Object)newRow);
        }
        catch (JAXBException ex) {
            Logger.getLogger(SheetEditorControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void syncData() {
        if (this.editor.getSheet().getRows() == null) {
            this.editor.getSheet().setRows(new Rows());
        }
        this.editor.getSheet().getRows().getRow().clear();
        this.editor.getSheet().getRows().getRow().addAll((Collection<Rows.Row>)this.tableData);
        this.editor.getSheet().getColumns().getColumn().sort((t1, t2) -> Integer.compare(this.findColumn((UserType)t1), this.findColumn((UserType)t2)));
    }

    private int findColumn(UserType col) {
        for (int i = 0; i < this.table.getColumns().size(); ++i) {
            if (!((TableColumn)this.table.getColumns().get(i)).getText().equals(col.getName())) continue;
            return i;
        }
        return -1;
    }
}

