/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.Menu;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javax.xml.bind.JAXBException;
import org.badvision.outlaweditor.MapEditor;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.data.PropertyHelper;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Map;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.data.xml.Tile;
import org.badvision.outlaweditor.ui.EntitySelectorCell;
import org.badvision.outlaweditor.ui.MapEditorTabController;
import org.badvision.outlaweditor.ui.ToolType;
import org.badvision.outlaweditor.ui.UIAction;
import org.badvision.outlaweditor.ui.impl.ApplicationUIControllerImpl;

public class MapEditorTabControllerImpl
extends MapEditorTabController {
    final TransferHelper<Script> scriptDragDrop = new TransferHelper<Script>(Script.class);
    final TransferHelper<ToolType> toolDragDrop = new TransferHelper<ToolType>(ToolType.class);
    int errorCount = 0;
    long gagTimeout = 0L;
    public static final Image VISIBLE_IMAGE = new Image("images/visible.png");
    public static final Image INVISIBLE_IMAGE = new Image("images/not_visible.png");

    @Override
    public void mapEraser(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().setDrawMode(MapEditor.DrawMode.Eraser);
        }
    }

    @Override
    public void mapDraw1(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().setDrawMode(MapEditor.DrawMode.Pencil1px);
        }
    }

    @Override
    public void mapDraw3(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().setDrawMode(MapEditor.DrawMode.Pencil3px);
        }
    }

    @Override
    public void mapDraw5(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().setDrawMode(MapEditor.DrawMode.Pencil5px);
        }
    }

    @Override
    public void mapDrawFilledRectMode(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().setDrawMode(MapEditor.DrawMode.FilledRect);
        }
    }

    @Override
    public void mapTogglePanZoom(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().togglePanZoom();
        }
    }

    @Override
    public void mapZoomIn(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().zoomIn();
        }
    }

    @Override
    public void mapZoomOut(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().zoomOut();
        }
    }

    @Override
    public void onMapClonePressed(ActionEvent event) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void onMapCreatePressed(ActionEvent event) {
        Map m = new Map();
        m.setName("Untitled");
        m.setWidth(512);
        m.setHeight(512);
        ApplicationState.getInstance().getGameData().getMap().add(m);
        this.rebuildMapSelectors();
        this.setCurrentMap(m);
    }

    @Override
    public void onMapDeletePressed(ActionEvent event) {
        Map currentMap = this.getCurrentMap();
        if (currentMap == null) {
            return;
        }
        UIAction.confirm("Delete map '" + currentMap.getName() + "'.  Are you sure?", () -> {
            Map del = currentMap;
            this.setCurrentMap(null);
            ApplicationState.getInstance().getGameData().getMap().remove(del);
            this.rebuildMapSelectors();
        }, null);
    }

    @Override
    public void onMapExportPressed(ActionEvent event) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void onMapPreviewPressed(ActionEvent event) {
        if (this.getCurrentEditor() == null) {
            return;
        }
        this.getCurrentEditor().showPreview();
    }

    @Override
    public void onMapScriptAddPressed(ActionEvent event) {
        UIAction.createAndEditScript(this.getCurrentMap());
    }

    @Override
    public void onMapScriptClonePressed(ActionEvent event) {
        Script source = (Script)this.mapScriptsList.getSelectionModel().getSelectedItem();
        if (source == null) {
            String message = "First select a script and then press Clone";
            if (this.gagTimeout == 0L || this.gagTimeout < System.currentTimeMillis()) {
                this.gagTimeout = System.currentTimeMillis() + 15000L;
                this.errorCount = 1;
            } else {
                switch (++this.errorCount) {
                    case 3: {
                        message = "Seriously, select a script first";
                        break;
                    }
                    case 4: {
                        message = "By select, I mean move the mouse and click on something";
                        break;
                    }
                    case 5: {
                        message = "I really can't help you";
                        break;
                    }
                    case 6: {
                        message = "Bored?  Lonely?  Have you trolled any YouTube comments lately?";
                        break;
                    }
                }
            }
            UIAction.alert(message);
        } else {
            try {
                Script script = TransferHelper.cloneObject(source, Script.class, "script");
                script.getLocationTrigger().clear();
                script.getIntervalTrigger().clear();
                script.setName(source.getName() + " CLONE");
                this.getCurrentEditor().addScript(script);
                UIAction.editScript(script, this.getCurrentMap());
            }
            catch (JAXBException ex) {
                Logger.getLogger(MapEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                UIAction.alert("Error occured when attempting clone operation:\n" + ex.getMessage());
            }
        }
    }

    @Override
    public void onMapScriptDeletePressed(ActionEvent event) {
        Script script = (Script)this.mapScriptsList.getSelectionModel().getSelectedItem();
        if (script != null) {
            UIAction.confirm("Are you sure you want to delete the script " + script.getName() + "?  There is no undo for this!", () -> {
                this.getCurrentEditor().removeScript(script);
                this.redrawMapScripts();
            }, null);
        }
    }

    @Override
    public void onMapSelected(ActionEvent event) {
        this.setCurrentMap((Map)this.mapSelect.getSelectionModel().getSelectedItem());
    }

    @Override
    public void scrollMapDown(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().scrollBy(0, 1);
        }
    }

    @Override
    public void scrollMapLeft(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().scrollBy(-1, 0);
        }
    }

    @Override
    public void scrollMapRight(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().scrollBy(1, 0);
        }
    }

    @Override
    public void scrollMapUp(ActionEvent event) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().scrollBy(0, -1);
        }
    }

    @Override
    public Map getCurrentMap() {
        if (this.getCurrentEditor() == null) {
            return null;
        }
        return this.getCurrentEditor().getCurrentMap().getBackingMap();
    }

    @Override
    public void completeInflightOperations() {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().getCurrentMap().updateBackingMap();
        }
    }

    @Override
    public void setCurrentMap(Map m) {
        if (m != null && m.equals(this.getCurrentMap())) {
            return;
        }
        Tile currentTile = null;
        if (this.getCurrentEditor() != null) {
            currentTile = this.getCurrentEditor().getCurrentTile();
            this.getCurrentEditor().unregister();
        }
        if (m == null) {
            PropertyHelper.bind((Property)this.mapHeightField.textProperty(), null);
            PropertyHelper.bind((Property)this.mapNameField.textProperty(), null);
            PropertyHelper.bind((Property)this.mapWidthField.textProperty(), null);
            PropertyHelper.bind((Property)this.mapWrapAround.selectedProperty(), null);
            this.mapHeightField.setDisable(true);
            this.mapNameField.setDisable(true);
            this.mapWidthField.setDisable(true);
            this.mapWrapAround.setDisable(true);
            this.setCurrentEditor(null);
        } else {
            if (m.getScripts() != null) {
                DataUtilities.sortNamedEntities(m.getScripts().getScript());
            }
            if (m.getHeight() == null) {
                m.setHeight(512);
            }
            if (m.getWidth() == null) {
                m.setWidth(512);
            }
            if (m.getName() == null) {
                m.setName("Untitled");
            }
            try {
                this.mapHeightField.setDisable(false);
                this.mapNameField.setDisable(false);
                this.mapWidthField.setDisable(false);
                this.mapWrapAround.setDisable(false);
                PropertyHelper.bind((Property)this.mapNameField.textProperty(), (Property)PropertyHelper.stringProp(m, "name"));
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(ApplicationUIControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            MapEditor e = new MapEditor();
            e.setEntity(m);
            e.buildEditorUI((Pane)this.mapEditorAnchorPane);
            this.setCurrentEditor(e);
            e.setupDragDrop(this.scriptDragDrop, this.toolDragDrop);
            if (currentTile != null) {
                e.setCurrentTile(currentTile);
            }
        }
        if (this.getCurrentEditor() != null) {
            this.cursorInfo.textProperty().bind((ObservableValue)this.getCurrentEditor().cursorInfoProperty());
        } else {
            this.cursorInfo.textProperty().unbind();
            this.cursorInfo.setText("");
        }
        this.redrawMapScripts();
    }

    @Override
    public void rebuildMapSelectors() {
        Map m = (Map)this.mapSelect.getSelectionModel().getSelectedItem();
        this.mapSelect.getItems().clear();
        DataUtilities.sortMaps(ApplicationState.getInstance().getGameData().getMap());
        this.mapSelect.getItems().addAll(ApplicationState.getInstance().getGameData().getMap());
        this.mapSelect.getSelectionModel().select((Object)m);
    }

    @Override
    public void initalize() {
        super.initalize();
        this.mapSelect.setButtonCell((ListCell)new ComboBoxListCell<Map>(){

            public void updateItem(Map item, boolean empty) {
                this.textProperty().unbind();
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.textProperty().bind((ObservableValue)MapEditorTabControllerImpl.this.mapNameField.textProperty());
                } else {
                    this.setText(null);
                }
            }
        });
        this.mapSelect.setCellFactory(param -> new EntitySelectorCell<Map>(this.mapNameField, null){

            @Override
            public void finishUpdate(Map item) {
            }
        });
        this.toolDragDrop.registerDragSupport((Node)this.scriptEraseTool, ToolType.ERASER);
    }

    @Override
    public void rebuildTileSelectors() {
        this.mapSelectTile.getItems().clear();
        ToggleGroup tileGroup = new ToggleGroup();
        HashMap submenus = new HashMap();
        ApplicationState.getInstance().getGameData().getTile().stream().forEach(t -> {
            WritableImage img = TileUtils.getImage(t, ApplicationState.getInstance().getCurrentPlatform());
            ImageView iv = new ImageView((Image)img);
            String category = String.valueOf(t.getCategory());
            Menu categoryMenu = (Menu)submenus.get(category);
            if (categoryMenu == null) {
                categoryMenu = new Menu(category);
                submenus.put(category, categoryMenu);
            }
            Menu theMenu = categoryMenu;
            RadioMenuItem tileSelection = new RadioMenuItem(String.valueOf(t.getName()), (Node)iv);
            tileSelection.setToggleGroup(tileGroup);
            if (this.getCurrentEditor() != null && this.getCurrentEditor().getCurrentTile() == t) {
                tileGroup.selectToggle((Toggle)tileSelection);
                theMenu.setStyle("-fx-font-weight:bold; -fx-text-fill:blue");
            }
            tileSelection.setGraphic((Node)new ImageView((Image)TileUtils.getImage(t, ApplicationState.getInstance().getCurrentPlatform())));
            tileSelection.setOnAction(event -> {
                if (this.getCurrentEditor() != null) {
                    this.getCurrentEditor().setCurrentTile((Tile)t);
                }
                tileGroup.selectToggle((Toggle)tileSelection);
                submenus.values().stream().forEach(menu -> menu.setStyle(null));
                theMenu.setStyle("-fx-font-weight:bold; -fx-text-fill:blue");
            });
            categoryMenu.getItems().add((Object)tileSelection);
        });
        submenus.values().stream().forEach(menu -> this.mapSelectTile.getItems().add(menu));
    }

    @Override
    public void redrawMapScripts() {
        this.mapScriptsList.setOnEditStart(event -> UIAction.editScript((Script)event.getSource().getItems().get(event.getIndex()), this.getCurrentMap()));
        this.mapScriptsList.setCellFactory(param -> new ListCell<Script>(){

            protected void updateItem(Script item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText("");
                } else {
                    ImageView visibleIcon = MapEditorTabControllerImpl.this.getVisibleIcon(item);
                    visibleIcon.setOnMouseClicked(e -> {
                        MapEditorTabControllerImpl.this.toggleVisibility(visibleIcon, item);
                        MapEditorTabControllerImpl.this.mapScriptsList.getSelectionModel().clearSelection();
                    });
                    this.setGraphic((Node)visibleIcon);
                    MapEditorTabControllerImpl.this.getCurrentEditor().getCurrentMap().getScriptColor(item).ifPresent(arg_0 -> (this).setTextFill(arg_0));
                    this.setText(item.getName());
                    this.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
                    MapEditorTabControllerImpl.this.scriptDragDrop.registerDragSupport((Node)this, item);
                    visibleIcon.setMouseTransparent(false);
                }
            }
        });
        if (this.getCurrentMap() == null) {
            this.mapScriptsList.getItems().clear();
        } else if (this.mapScriptsList.getItems() != null && this.getCurrentMap().getScripts() != null) {
            DataUtilities.sortNamedEntities(this.getCurrentMap().getScripts().getScript());
            this.mapScriptsList.getItems().setAll(this.getCurrentMap().getScripts().getScript());
        } else {
            this.mapScriptsList.getItems().clear();
        }
    }

    private ImageView getVisibleIcon(Script script) {
        if (this.getCurrentEditor().isScriptVisible(script)) {
            return new ImageView(VISIBLE_IMAGE);
        }
        return new ImageView(INVISIBLE_IMAGE);
    }

    private void toggleVisibility(ImageView visibilityIcon, Script script) {
        if (script.getName() == null) {
            return;
        }
        if (this.getCurrentEditor().isScriptVisible(script)) {
            this.getCurrentEditor().setScriptVisible(script, false);
            visibilityIcon.setImage(INVISIBLE_IMAGE);
        } else {
            this.getCurrentEditor().setScriptVisible(script, true);
            visibilityIcon.setImage(VISIBLE_IMAGE);
        }
    }
}

