/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import javax.xml.bind.JAXBException;
import org.badvision.outlaweditor.Editor;
import org.badvision.outlaweditor.ImageEditor;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.PropertyHelper;
import org.badvision.outlaweditor.data.xml.Image;
import org.badvision.outlaweditor.ui.EntitySelectorCell;
import org.badvision.outlaweditor.ui.ImageEditorTabController;
import org.badvision.outlaweditor.ui.UIAction;
import org.badvision.outlaweditor.ui.impl.ApplicationUIControllerImpl;

public class ImageEditorTabControllerImpl
extends ImageEditorTabController {
    public Image currentImage = null;
    public ImageEditor currentImageEditor = null;
    ChangeListener rebuildListener = (value, oldValue, newValue) -> this.rebuildImageSelector();

    public void initialize() {
        super.initalize();
        this.imageSelector.setCellFactory(param -> new EntitySelectorCell<Image>(this.imageNameField, this.imageCategoryField){

            @Override
            public void finishUpdate(Image item) {
            }
        });
        this.imageSelector.setConverter((StringConverter)new StringConverter<Image>(){

            public String toString(Image object) {
                return String.valueOf(object.getCategory()) + "/" + String.valueOf(object.getName());
            }

            public Image fromString(String string) {
                return null;
            }
        });
    }

    @Override
    public Editor getCurrentEditor() {
        return this.currentImageEditor;
    }

    @Override
    public void imageBitMode(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.setDrawMode(ImageEditor.DrawMode.Toggle);
        }
    }

    @Override
    public void imageDraw1BitMode(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.setDrawMode(ImageEditor.DrawMode.Pencil1px);
        }
    }

    @Override
    public void imageDraw3BitMode(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.setDrawMode(ImageEditor.DrawMode.Pencil3px);
        }
    }

    @Override
    public void imageDraw5BitMode(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.setDrawMode(ImageEditor.DrawMode.Pencil5px);
        }
    }

    @Override
    public void imageDrawFilledRectMode(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.setDrawMode(ImageEditor.DrawMode.Rectangle);
        }
    }

    @Override
    public void imageShift(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.showShiftUI();
        }
    }

    @Override
    public void imageTogglePanZoom(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.togglePanZoom();
        }
    }

    private void updateZoomLabel() {
        this.zoomLabel.setText(String.format("%1.1fx", this.currentImageEditor.getZoomScale()));
    }

    @Override
    public void imageZoomIn(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.zoomIn();
            this.updateZoomLabel();
            this.updateScrollAreaWithScale(this.currentImageEditor.getZoomScale());
        }
    }

    @Override
    public void imageZoomOut(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.zoomOut();
            this.updateZoomLabel();
            this.updateScrollAreaWithScale(this.currentImageEditor.getZoomScale());
        }
    }

    @Override
    public void onImageClonePressed(ActionEvent event) {
        try {
            if (this.getCurrentImage() == null) {
                return;
            }
            Image clone = TransferHelper.cloneObject(this.getCurrentImage(), Image.class, "image");
            clone.setName(clone.getName() + " clone");
            ApplicationState.getInstance().getGameData().getImage().add(clone);
            this.setCurrentImage(clone);
            this.rebuildImageSelector();
        }
        catch (JAXBException ex) {
            Logger.getLogger(ImageEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void onImageCreatePressed(ActionEvent event) {
        Image i = new Image();
        i.setName("Untitled");
        ApplicationState.getInstance().getGameData().getImage().add(i);
        this.setCurrentImage(i);
        this.rebuildImageSelector();
    }

    @Override
    public void onImageDeletePressed(ActionEvent event) {
        if (this.currentImage == null) {
            return;
        }
        UIAction.confirm("Delete image '" + this.currentImage.getName() + "'.  Are you sure?", () -> {
            Image del = this.currentImage;
            this.setCurrentImage(null);
            ApplicationState.getInstance().getGameData().getImage().remove(del);
            this.rebuildImageSelector();
        }, null);
    }

    @Override
    public void onImageExportPressed(ActionEvent event) {
        if (this.currentImageEditor != null) {
            this.currentImageEditor.exportImage();
        }
    }

    @Override
    public void onImageSelected(ActionEvent event) {
        this.setCurrentImage((Image)this.imageSelector.getSelectionModel().getSelectedItem());
    }

    private void setCurrentImage(Image i) {
        if (this.currentImage != null && this.currentImage.equals(i)) {
            return;
        }
        this.imageNameField.textProperty().removeListener(this.rebuildListener);
        this.imageCategoryField.textProperty().removeListener(this.rebuildListener);
        this.imageSelector.getSelectionModel().select((Object)i);
        this.currentImage = i;
        EnumMap oldEditorState = null;
        if (this.currentImageEditor != null) {
            oldEditorState = this.currentImageEditor.getState();
            this.currentImageEditor.unregister();
            this.cursorInfo.textProperty().unbind();
            this.cursorInfo.setText("");
        }
        if (i == null) {
            PropertyHelper.bind((Property)this.imageCategoryField.textProperty(), null);
            PropertyHelper.bind((Property)this.imageNameField.textProperty(), null);
            this.imageCategoryField.setDisable(true);
            this.imageHeightField.setDisable(true);
            this.imageNameField.setDisable(true);
            this.imageWidthField.setDisable(true);
            this.currentImageEditor = null;
        } else {
            if (i.getName() == null) {
                i.setName("Untitled");
            }
            try {
                this.imageCategoryField.setDisable(false);
                this.imageHeightField.setDisable(false);
                this.imageNameField.setDisable(false);
                this.imageWidthField.setDisable(false);
                PropertyHelper.bind((Property)this.imageNameField.textProperty(), (Property)PropertyHelper.stringProp(i, "name"));
                PropertyHelper.bind((Property)this.imageCategoryField.textProperty(), (Property)PropertyHelper.stringProp(i, "category"));
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(ApplicationUIControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.currentImageEditor = ApplicationState.getInstance().getCurrentPlatform().imageEditor.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(ApplicationUIControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.currentImageEditor.setEntity(i);
            this.currentImageEditor.buildEditorUI((Pane)this.imageEditorScrollAnchorPane);
            this.currentImageEditor.buildPatternSelector(this.imagePatternMenu);
            this.imageNameField.textProperty().addListener(this.rebuildListener);
            this.imageCategoryField.textProperty().addListener(this.rebuildListener);
            if (oldEditorState != null) {
                this.currentImageEditor.setState(oldEditorState);
            }
        }
        if (this.currentImageEditor != null) {
            this.cursorInfo.textProperty().bind((ObservableValue)this.currentImageEditor.cursorInfoProperty());
        } else {
            this.cursorInfo.textProperty().unbind();
            this.cursorInfo.setText("");
        }
    }

    private Image getCurrentImage() {
        return this.currentImage;
    }

    @Override
    public void rebuildImageSelector() {
        Image i = this.getCurrentImage();
        this.imageSelector.getItems().clear();
        List<Image> allImages = ApplicationState.getInstance().getGameData().getImage();
        allImages.sort((o1, o2) -> {
            int c1 = String.valueOf(o1.getCategory()).compareTo(String.valueOf(o2.getCategory()));
            if (c1 != 0) {
                return c1;
            }
            return String.valueOf(o1.getName()).compareTo(String.valueOf(o2.getName()));
        });
        this.imageSelector.getItems().addAll(allImages);
        this.imageSelector.getSelectionModel().select((Object)i);
    }

    private void updateScrollAreaWithScale(double zoomScale) {
        double hval = this.imageEditorScrollPane.getHvalue();
        double vval = this.imageEditorScrollPane.getVvalue();
        this.imageEditorZoomGroup.setScaleX(zoomScale);
        this.imageEditorZoomGroup.setScaleY(zoomScale);
        this.imageEditorScrollPane.setHvalue(hval);
        this.imageEditorScrollPane.setVvalue(vval);
    }
}

