/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.stage.Stage;
import org.badvision.outlaweditor.apple.ImageDitherEngine;
import org.badvision.outlaweditor.ui.ImageConversionPostAction;

public class ImageConversionWizardController
implements Initializable {
    @FXML
    private TextField brightnessValue;
    @FXML
    private Slider brightnessSlider;
    @FXML
    private TextField contrastValue;
    @FXML
    private Slider contrastSlider;
    @FXML
    private TextField hueValue;
    @FXML
    private Slider hueSlider;
    @FXML
    private TextField saturationValue;
    @FXML
    private Slider saturationSlider;
    @FXML
    private TextField outputWidthValue;
    @FXML
    private TextField outputHeightValue;
    @FXML
    private TextField cropTopValue;
    @FXML
    private TextField cropLeftValue;
    @FXML
    private TextField cropBottomValue;
    @FXML
    private TextField cropRightValue;
    @FXML
    private TextField coefficientValue30;
    @FXML
    private TextField coefficientValue40;
    @FXML
    private TextField coefficientValue01;
    @FXML
    private TextField coefficientValue11;
    @FXML
    private TextField coefficientValue21;
    @FXML
    private TextField coefficientValue31;
    @FXML
    private TextField coefficientValue41;
    @FXML
    private TextField coefficientValue02;
    @FXML
    private TextField coefficientValue12;
    @FXML
    private TextField coefficientValue22;
    @FXML
    private TextField coefficientValue32;
    @FXML
    private TextField coefficientValue42;
    private final int[][] diffusionCoeffficients = new int[5][3];
    @FXML
    private TextField divisorValue;
    @FXML
    private ImageView sourceImageView;
    @FXML
    private ImageView convertedImageView;
    private ColorAdjust imageAdjustments = new ColorAdjust();
    private Stage stage;
    private ImageConversionPostAction postAction;
    private Image sourceImage;
    private WritableImage preprocessedImage;
    private WritableImage outputPreviewImage;
    private ImageDitherEngine ditherEngine;
    byte[] lastOutput;
    private final Map<TextField, String> defaultTextFieldValues = new HashMap<TextField, String>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);

    public void initialize(URL url, ResourceBundle rb) {
        for (TextField field : new TextField[]{this.brightnessValue, this.contrastValue, this.hueValue, this.saturationValue, this.cropBottomValue, this.cropLeftValue, this.cropRightValue, this.cropTopValue, this.coefficientValue01, this.coefficientValue02, this.coefficientValue11, this.coefficientValue12, this.coefficientValue21, this.coefficientValue22, this.coefficientValue30, this.coefficientValue31, this.coefficientValue32, this.coefficientValue40, this.coefficientValue41, this.coefficientValue41, this.coefficientValue42, this.divisorValue, this.outputHeightValue, this.outputWidthValue}) {
            this.configureNumberValidation(field, "0");
        }
        this.brightnessValue.textProperty().bindBidirectional((Property)this.brightnessSlider.valueProperty(), (Format)NumberFormat.getNumberInstance());
        this.contrastValue.textProperty().bindBidirectional((Property)this.contrastSlider.valueProperty(), (Format)NumberFormat.getNumberInstance());
        this.hueValue.textProperty().bindBidirectional((Property)this.hueSlider.valueProperty(), (Format)NumberFormat.getNumberInstance());
        this.saturationValue.textProperty().bindBidirectional((Property)this.saturationSlider.valueProperty(), (Format)NumberFormat.getNumberInstance());
        this.brightnessValue.textProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(this::updateImageAdjustments));
        this.contrastValue.textProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(this::updateImageAdjustments));
        this.hueValue.textProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(this::updateImageAdjustments));
        this.saturationValue.textProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(this::updateImageAdjustments));
        this.configureAtkinsonPreset(null);
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setPostAction(ImageConversionPostAction postAction) {
        this.postAction = postAction;
    }

    public void setDitherEngine(ImageDitherEngine engine) {
        this.ditherEngine = engine;
    }

    public void setSourceImage(Image image) {
        this.sourceImage = image;
        this.preprocessImage();
    }

    private void updateImageAdjustments() {
        double hue = Double.parseDouble(this.hueValue.getText());
        double saturation = Double.parseDouble(this.saturationValue.getText());
        double brightness = Double.parseDouble(this.brightnessValue.getText());
        double contrast = Double.parseDouble(this.contrastValue.getText());
        this.imageAdjustments = new ColorAdjust();
        this.imageAdjustments.setContrast(contrast);
        this.imageAdjustments.setBrightness(brightness);
        this.imageAdjustments.setHue(hue);
        this.imageAdjustments.setSaturation(saturation);
        this.sourceImageView.setEffect((Effect)this.imageAdjustments);
    }

    private void preprocessImage() {
        PixelReader pixelReader = this.sourceImage.getPixelReader();
        this.preprocessedImage = new WritableImage(pixelReader, (int)this.sourceImage.getWidth(), (int)this.sourceImage.getHeight());
        this.updateSourceView((Image)this.preprocessedImage);
    }

    public void setOutputDimensions(int targetWidth, int targetHeight) {
        this.ditherEngine.setOutputDimensions(targetWidth, targetHeight);
        this.outputWidthValue.setText(String.valueOf(targetWidth));
        this.outputHeightValue.setText(String.valueOf(targetHeight));
        this.outputPreviewImage = this.ditherEngine.getPreviewImage();
    }

    public int getOutputWidth() {
        return Integer.parseInt(this.outputWidthValue.getText());
    }

    public int getOutputHeight() {
        return Integer.parseInt(this.outputHeightValue.getText());
    }

    private void updateSourceView(Image image) {
        this.sourceImageView.setImage(image);
        this.sourceImageView.setFitWidth(0.0);
        this.sourceImageView.setFitHeight(0.0);
        int width = (int)image.getWidth();
        int height = (int)image.getHeight();
        this.defaultTextFieldValues.put(this.cropRightValue, String.valueOf(width));
        this.defaultTextFieldValues.put(this.cropBottomValue, String.valueOf(height));
        this.cropRightValue.setText(String.valueOf(width));
        this.cropBottomValue.setText(String.valueOf(height));
    }

    @FXML
    private void performQuantizePass(ActionEvent event) {
        this.prepareForConversion();
        byte[] out = this.ditherEngine.dither(false);
        this.updateConvertedImageWithData(out);
    }

    @FXML
    private void performDiffusionPass(ActionEvent event) {
        this.prepareForConversion();
        byte[] out = this.ditherEngine.dither(true);
        this.updateConvertedImageWithData(out);
    }

    private void prepareForConversion() {
        this.ditherEngine.setCoefficients(this.getCoefficients());
        this.ditherEngine.setDivisor(this.getDivisor());
        this.ditherEngine.setSourceImage((Image)this.sourceImageView.snapshot(null, null));
    }

    private void updateConvertedImageWithData(byte[] data) {
        this.lastOutput = data;
        this.convertedImageView.setImage((Image)this.ditherEngine.getPreviewImage());
    }

    @FXML
    private void performOK(ActionEvent event) {
        this.postAction.storeConvertedImage(this.lastOutput);
        this.stage.close();
    }

    @FXML
    private void performCancel(ActionEvent event) {
        this.stage.close();
    }

    private void configureNumberValidation(TextField field, String defaultValue) {
        this.defaultTextFieldValues.put(field, defaultValue);
        field.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null || "".equals(newValue)) {
                this.scheduler.schedule(() -> {
                    if (null == field.textProperty().getValue() || field.textProperty().getValue().isEmpty()) {
                        field.textProperty().setValue(this.defaultTextFieldValues.get(field));
                    }
                }, 250L, TimeUnit.MILLISECONDS);
            } else {
                try {
                    Double.parseDouble(newValue.toString());
                }
                catch (Exception ex) {
                    field.textProperty().setValue(oldValue.toString());
                }
            }
        });
    }

    private void setCoefficients(int ... coeff) {
        this.coefficientValue30.setText(String.valueOf(coeff[3]));
        this.coefficientValue40.setText(String.valueOf(coeff[4]));
        this.coefficientValue01.setText(String.valueOf(coeff[5]));
        this.coefficientValue11.setText(String.valueOf(coeff[6]));
        this.coefficientValue21.setText(String.valueOf(coeff[7]));
        this.coefficientValue31.setText(String.valueOf(coeff[8]));
        this.coefficientValue41.setText(String.valueOf(coeff[9]));
        this.coefficientValue02.setText(String.valueOf(coeff[10]));
        this.coefficientValue12.setText(String.valueOf(coeff[11]));
        this.coefficientValue22.setText(String.valueOf(coeff[12]));
        this.coefficientValue32.setText(String.valueOf(coeff[13]));
        this.coefficientValue42.setText(String.valueOf(coeff[14]));
    }

    private int[][] getCoefficients() {
        this.diffusionCoeffficients[0][0] = 0;
        this.diffusionCoeffficients[1][0] = 0;
        this.diffusionCoeffficients[2][0] = 0;
        this.diffusionCoeffficients[3][0] = Integer.parseInt(this.coefficientValue30.getText());
        this.diffusionCoeffficients[4][0] = Integer.parseInt(this.coefficientValue40.getText());
        this.diffusionCoeffficients[0][1] = Integer.parseInt(this.coefficientValue01.getText());
        this.diffusionCoeffficients[1][1] = Integer.parseInt(this.coefficientValue11.getText());
        this.diffusionCoeffficients[2][1] = Integer.parseInt(this.coefficientValue21.getText());
        this.diffusionCoeffficients[3][1] = Integer.parseInt(this.coefficientValue31.getText());
        this.diffusionCoeffficients[4][1] = Integer.parseInt(this.coefficientValue41.getText());
        this.diffusionCoeffficients[0][2] = Integer.parseInt(this.coefficientValue02.getText());
        this.diffusionCoeffficients[1][2] = Integer.parseInt(this.coefficientValue12.getText());
        this.diffusionCoeffficients[2][2] = Integer.parseInt(this.coefficientValue22.getText());
        this.diffusionCoeffficients[3][2] = Integer.parseInt(this.coefficientValue32.getText());
        this.diffusionCoeffficients[4][2] = Integer.parseInt(this.coefficientValue42.getText());
        return this.diffusionCoeffficients;
    }

    private void setDivisor(int div) {
        this.divisorValue.setText(String.valueOf(div));
    }

    private int getDivisor() {
        return Integer.valueOf(this.divisorValue.getText());
    }

    @FXML
    private void configureFloydSteinbergPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 7, 0, 0, 3, 5, 1, 0, 0, 0, 0, 0, 0);
        this.setDivisor(18);
    }

    @FXML
    private void configureFastFloydSteinbergPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 3, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0, 0);
        this.setDivisor(10);
    }

    @FXML
    private void configureJarvisJudiceNinkePreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 7, 5, 3, 5, 7, 5, 3, 1, 3, 5, 3, 1);
        this.setDivisor(57);
    }

    @FXML
    private void configureStuckiPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 8, 4, 2, 4, 8, 4, 2, 1, 2, 4, 2, 1);
        this.setDivisor(52);
    }

    @FXML
    private void configureAtkinsonPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0);
        this.setDivisor(8);
    }

    @FXML
    private void configureBurkesPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 8, 4, 2, 4, 8, 4, 2, 0, 0, 0, 0, 0);
        this.setDivisor(37);
    }

    @FXML
    private void configureSierraPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 5, 3, 2, 4, 5, 4, 2, 0, 2, 3, 2, 0);
        this.setDivisor(41);
    }

    @FXML
    private void configureTwoRowSierraPreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 4, 3, 1, 2, 3, 2, 1, 0, 0, 0, 0, 0);
        this.setDivisor(18);
    }

    @FXML
    private void configureSierraLitePreset(ActionEvent event) {
        this.setCoefficients(0, 0, 0, 2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0);
        this.setDivisor(5);
    }
}

