/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import java.beans.IntrospectionException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.control.ListCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javax.xml.bind.JAXBException;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.data.xml.Sheet;
import org.badvision.outlaweditor.data.xml.UserType;
import org.badvision.outlaweditor.data.xml.Variable;
import org.badvision.outlaweditor.ui.GlobalEditorTabController;
import org.badvision.outlaweditor.ui.UIAction;
import org.badvision.outlaweditor.ui.impl.MapEditorTabControllerImpl;

public class GlobalEditorTabControllerImpl
extends GlobalEditorTabController {
    @Override
    public void initialize() {
        super.initialize();
        this.variableList.setCellFactory(listView -> new ListCell<Variable>(){

            protected void updateItem(Variable item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText("");
                } else {
                    this.setText(item.getName());
                    if (item.getComment() != null && !item.getComment().isEmpty()) {
                        this.setTooltip(new Tooltip(item.getComment()));
                    }
                    this.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
                }
            }

            public void startEdit() {
                UIAction.editVariable((Variable)this.getItem(), ApplicationState.getInstance().getGameData().getGlobal());
                this.cancelEdit();
                this.updateItem((Variable)this.getItem(), false);
            }
        });
        this.globalScriptList.setCellFactory(listView -> new ListCell<Script>(){

            protected void updateItem(Script item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText("");
                } else {
                    this.setText(item.getName());
                    this.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
                }
            }

            public void startEdit() {
                UIAction.editScript((Script)this.getItem(), ApplicationState.getInstance().getGameData().getGlobal());
                this.cancelEdit();
                this.updateItem((Script)this.getItem(), false);
            }
        });
        this.dataTypeList.setCellFactory(listView -> new ListCell<UserType>(){

            protected void updateItem(UserType item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText("");
                } else {
                    this.setText(item.getName());
                    if (item.getComment() != null && !item.getComment().isEmpty()) {
                        this.setTooltip(new Tooltip(item.getComment()));
                    }
                    this.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
                }
            }

            public void startEdit() {
                UIAction.editUserType((UserType)this.getItem());
                this.cancelEdit();
                this.updateItem((UserType)this.getItem(), false);
            }
        });
        this.sheetList.setCellFactory(listView -> new ListCell<Sheet>(){

            protected void updateItem(Sheet item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText("");
                } else {
                    this.setText(item.getName());
                    if (item.getComment() != null && !item.getComment().isEmpty()) {
                        this.setTooltip(new Tooltip(item.getComment()));
                    }
                    this.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
                }
            }

            public void startEdit() {
                Platform.runLater(() -> ((MultipleSelectionModel)GlobalEditorTabControllerImpl.this.sheetList.getSelectionModel()).clearSelection());
                UIAction.editSheet((Sheet)this.getItem());
                this.cancelEdit();
                this.updateItem((Sheet)this.getItem(), false);
            }
        });
    }

    @Override
    protected void onScriptAddPressed(ActionEvent event) {
        UIAction.createAndEditScript(ApplicationState.getInstance().getGameData().getGlobal());
    }

    @Override
    protected void onScriptDeletePressed(ActionEvent event) {
        Script script = (Script)this.globalScriptList.getSelectionModel().getSelectedItem();
        if (script != null) {
            UIAction.confirm("Are you sure you want to delete the script " + script.getName() + "?  There is no undo for this!", () -> {
                this.getCurrentEditor().removeScript(script);
                this.redrawGlobalScripts();
            }, null);
        }
    }

    @Override
    protected void onScriptClonePressed(ActionEvent event) {
        Script source = (Script)this.globalScriptList.getSelectionModel().getSelectedItem();
        if (source == null) {
            String message = "First select a script and then press Clone";
            UIAction.alert(message);
        } else {
            try {
                Script script = TransferHelper.cloneObject(source, Script.class, "script");
                script.setName(source.getName() + " CLONE");
                this.getCurrentEditor().addScript(script);
                UIAction.editScript(script, ApplicationState.getInstance().getGameData().getGlobal());
            }
            catch (JAXBException ex) {
                Logger.getLogger(MapEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                UIAction.alert("Error occured when attempting clone operation:\n" + ex.getMessage());
            }
        }
    }

    @Override
    protected void onDataTypeAddPressed(ActionEvent event) {
        try {
            UIAction.createAndEditUserType();
            this.redrawGlobalDataTypes();
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(GlobalEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void onDataTypeDeletePressed(ActionEvent event) {
        UserType type = (UserType)this.dataTypeList.getSelectionModel().getSelectedItem();
        if (type != null) {
            UIAction.confirm("Are you sure you want to delete the user-defined type " + type.getName() + "?  There is no undo for this!", () -> {
                ApplicationState.getInstance().getGameData().getGlobal().getUserTypes().getUserType().remove(type);
                this.redrawGlobalDataTypes();
            }, null);
        }
    }

    @Override
    protected void onDataTypeClonePressed(ActionEvent event) {
        UserType source = (UserType)this.dataTypeList.getSelectionModel().getSelectedItem();
        if (source == null) {
            String message = "First select a data type and then press Clone";
            UIAction.alert(message);
        } else {
            try {
                UserType newType = TransferHelper.cloneObject(source, UserType.class, "userType");
                newType.setName(source.getName() + " CLONE");
                if (UIAction.editAndGetUserType(newType) != null) {
                    ApplicationState.getInstance().getGameData().getGlobal().getUserTypes().getUserType().add(newType);
                    this.redrawGlobalDataTypes();
                }
            }
            catch (JAXBException ex) {
                Logger.getLogger(MapEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                UIAction.alert("Error occured when attempting clone operation:\n" + ex.getMessage());
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(GlobalEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected void onSheetAddPressed(ActionEvent event) {
        try {
            UIAction.createAndEditSheet();
            this.redrawGlobalSheets();
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(GlobalEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void onSheetDeletePressed(ActionEvent event) {
        Sheet sheet = (Sheet)this.sheetList.getSelectionModel().getSelectedItem();
        if (sheet != null) {
            UIAction.confirm("Are you sure you want to delete the sheet " + sheet.getName() + "?  There is no undo for this!", () -> {
                ApplicationState.getInstance().getGameData().getGlobal().getSheets().getSheet().remove(sheet);
                this.redrawGlobalSheets();
            }, null);
        }
    }

    @Override
    protected void onSheetClonePressed(ActionEvent event) {
        Sheet source = (Sheet)this.sheetList.getSelectionModel().getSelectedItem();
        if (source == null) {
            String message = "First select a sheet and then press Clone";
            UIAction.alert(message);
        } else {
            try {
                Sheet sheet = TransferHelper.cloneObject(source, Sheet.class, "sheet");
                sheet.setName(source.getName() + " CLONE");
                Sheet newVar = UIAction.editSheet(sheet);
                ApplicationState.getInstance().getGameData().getGlobal().getSheets().getSheet().add(newVar);
                this.redrawGlobalSheets();
            }
            catch (JAXBException ex) {
                Logger.getLogger(GlobalEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                UIAction.alert("Error occured when attempting clone operation:\n" + ex.getMessage());
            }
        }
    }

    @Override
    protected void onVariableAddPressed(ActionEvent event) {
        try {
            UIAction.createAndEditVariable(ApplicationState.getInstance().getGameData().getGlobal());
            this.redrawGlobalVariables();
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(GlobalEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void onVariableDeletePressed(ActionEvent event) {
        Variable var = (Variable)this.variableList.getSelectionModel().getSelectedItem();
        if (var != null) {
            UIAction.confirm("Are you sure you want to delete the variable " + var.getName() + "?  There is no undo for this!", () -> {
                ApplicationState.getInstance().getGameData().getGlobal().getVariables().getVariable().remove(var);
                this.redrawGlobalVariables();
            }, null);
        }
    }

    @Override
    protected void onVariableClonePressed(ActionEvent event) {
        Variable source = (Variable)this.variableList.getSelectionModel().getSelectedItem();
        if (source == null) {
            String message = "First select a variable and then press Clone";
            UIAction.alert(message);
        } else {
            try {
                Variable variable = TransferHelper.cloneObject(source, Variable.class, "variable");
                variable.setName(source.getName() + " CLONE");
                Optional<Variable> newVar = UIAction.editAndGetVariable(variable);
                if (newVar.isPresent()) {
                    ApplicationState.getInstance().getGameData().getGlobal().getVariables().getVariable().add(newVar.get());
                    this.redrawGlobalVariables();
                }
            }
            catch (JAXBException ex) {
                Logger.getLogger(MapEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                UIAction.alert("Error occured when attempting clone operation:\n" + ex.getMessage());
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(GlobalEditorTabControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void redrawGlobalScripts() {
        DataUtilities.ensureGlobalExists();
        if (this.globalScriptList.getItems() != null && ApplicationState.getInstance().getGameData().getGlobal().getScripts() != null) {
            DataUtilities.sortNamedEntities(ApplicationState.getInstance().getGameData().getGlobal().getScripts().getScript());
            this.globalScriptList.getItems().setAll(ApplicationState.getInstance().getGameData().getGlobal().getScripts().getScript());
        } else {
            this.globalScriptList.getItems().clear();
        }
    }

    @Override
    public void redrawGlobalVariables() {
        DataUtilities.ensureGlobalExists();
        if (this.variableList.getItems() != null && ApplicationState.getInstance().getGameData().getGlobal().getVariables() != null) {
            DataUtilities.sortNamedEntities(ApplicationState.getInstance().getGameData().getGlobal().getVariables().getVariable());
            this.variableList.getItems().setAll(ApplicationState.getInstance().getGameData().getGlobal().getVariables().getVariable());
        } else {
            this.variableList.getItems().clear();
        }
    }

    @Override
    public void redrawGlobalDataTypes() {
        DataUtilities.ensureGlobalExists();
        if (this.dataTypeList.getItems() != null && ApplicationState.getInstance().getGameData().getGlobal().getUserTypes() != null) {
            DataUtilities.sortNamedEntities(ApplicationState.getInstance().getGameData().getGlobal().getUserTypes().getUserType());
            this.dataTypeList.getItems().setAll(ApplicationState.getInstance().getGameData().getGlobal().getUserTypes().getUserType());
        } else {
            this.dataTypeList.getItems().clear();
        }
    }

    @Override
    public void redrawGlobalSheets() {
        DataUtilities.ensureGlobalExists();
        if (this.sheetList.getItems() != null && ApplicationState.getInstance().getGameData().getGlobal().getSheets() != null) {
            DataUtilities.sortNamedEntities(ApplicationState.getInstance().getGameData().getGlobal().getSheets().getSheet());
            this.sheetList.getItems().setAll(ApplicationState.getInstance().getGameData().getGlobal().getSheets().getSheet());
        } else {
            this.sheetList.getItems().clear();
        }
    }
}

