/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui.impl;

import javafx.event.Event;
import javafx.scene.input.DataFormat;
import org.badvision.outlaweditor.Editor;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.TilesetUtils;
import org.badvision.outlaweditor.data.xml.Tile;
import org.badvision.outlaweditor.ui.ApplicationUIController;

public class ApplicationUIControllerImpl
extends ApplicationUIController {
    TABS currentTab;
    public static final DataFormat SCRIPT_DATA_FORMAT = new DataFormat(new String[]{"MythosScript"});

    @Override
    public void initialize() {
        super.initialize();
        TilesetUtils.addObserver(object -> this.rebuildTileSelectors());
        this.tileController.initalize();
        this.mapController.initalize();
        this.imageController.initalize();
        this.globalController.initialize();
        this.menuController.initalize();
    }

    @Override
    public void platformChange() {
        ApplicationState.getInstance().getGameData().getTile().stream().forEach(t -> TileUtils.redrawTile(t));
        Tile tile = this.tileController.getCurrentTile();
        this.rebuildTileSelectors();
        this.tileController.setCurrentTile(tile);
        this.rebuildImageSelectors();
        this.redrawAllTabs();
    }

    public void redrawAllTabs() {
        if (this.mapController.getCurrentEditor() != null) {
            this.mapController.getCurrentEditor().redraw();
        }
        if (this.imageController.getCurrentEditor() != null) {
            this.imageController.getCurrentEditor().redraw();
        }
    }

    @Override
    public void updateSelectors() {
        this.rebuildImageSelectors();
        this.rebuildMapSelectors();
        this.rebuildTileSelectors();
        this.redrawScripts();
        this.globalController.redrawGlobalDataTypes();
        this.globalController.redrawGlobalVariables();
        this.globalController.redrawGlobalSheets();
    }

    @Override
    public void rebuildTileSelectors() {
        this.tileController.rebuildTileSelectors();
        this.mapController.rebuildTileSelectors();
    }

    @Override
    public void redrawScripts() {
        this.mapController.redrawMapScripts();
        this.globalController.redrawGlobalScripts();
    }

    @Override
    public void rebuildMapSelectors() {
        this.mapController.rebuildMapSelectors();
    }

    @Override
    public void rebuildImageSelectors() {
        this.imageController.rebuildImageSelector();
    }

    @Override
    public void completeInflightOperations() {
        this.mapController.completeInflightOperations();
    }

    @Override
    public void imageTabActivated(Event event) {
        this.currentTab = TABS.image;
    }

    @Override
    public void mapTabActivated(Event event) {
        this.currentTab = TABS.map;
    }

    @Override
    public void tileTabActivated(Event event) {
        this.currentTab = TABS.tile;
    }

    @Override
    public void globalTabActivated(Event event) {
        this.currentTab = TABS.global;
    }

    @Override
    public Editor getVisibleEditor() {
        switch (this.currentTab) {
            case image: {
                return this.imageController.getCurrentEditor();
            }
            case map: {
                return this.mapController.getCurrentEditor();
            }
            case tile: {
                return this.tileController.getCurrentTileEditor();
            }
            case global: {
                return this.globalController.getCurrentEditor();
            }
        }
        return null;
    }

    @Override
    public void clearData() {
        this.tileController.setCurrentTile(null);
        this.mapController.setCurrentMap(null);
        this.tileController.setCurrentTile(null);
    }

    public static enum TABS {
        image,
        map,
        tile,
        global;

    }
}

