/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javax.xml.bind.JAXB;
import org.badvision.outlaweditor.Application;
import org.badvision.outlaweditor.FileUtils;
import org.badvision.outlaweditor.MythosEditor;
import org.badvision.outlaweditor.SheetEditor;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.apple.ImageDitherEngine;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.data.TilesetUtils;
import org.badvision.outlaweditor.data.xml.GameData;
import org.badvision.outlaweditor.data.xml.Global;
import org.badvision.outlaweditor.data.xml.Scope;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.data.xml.Sheet;
import org.badvision.outlaweditor.data.xml.UserType;
import org.badvision.outlaweditor.data.xml.Variable;
import org.badvision.outlaweditor.data.xml.Variables;
import org.badvision.outlaweditor.ui.ApplicationUIController;
import org.badvision.outlaweditor.ui.ImageConversionPostAction;
import org.badvision.outlaweditor.ui.ModalEditor;
import org.badvision.outlaweditor.ui.impl.ImageConversionWizardController;

public class UIAction {
    private static File currentSaveFile;
    static Image badImage;

    public static void actionPerformed(MAIN_ACTIONS action) throws IOException {
        switch (action) {
            case About_Outlaw_Editor: {
                break;
            }
            case Apple_Mode: {
                break;
            }
            case C64_Mode: {
                break;
            }
            case Delete_tile: {
                break;
            }
            case Export_map_to_image: {
                break;
            }
            case Export_tile_to_image: {
                break;
            }
            case Load: {
                File f = FileUtils.getFile(currentSaveFile, "Load game data", Boolean.FALSE, FileUtils.Extension.XML, FileUtils.Extension.ALL);
                if (f == null) {
                    return;
                }
                currentSaveFile = f;
                GameData newData = (GameData)JAXB.unmarshal((File)currentSaveFile, GameData.class);
                ApplicationUIController.getController().clearData();
                TilesetUtils.clear();
                ApplicationState.getInstance().setGameData(newData);
                DataUtilities.ensureGlobalExists();
                DataUtilities.cleanupAllScriptNames();
                ApplicationUIController.getController().updateSelectors();
                break;
            }
            case Quit: {
                UIAction.quit();
                break;
            }
            case Save_as: {
                File f = FileUtils.getFile(currentSaveFile, "Save game data", Boolean.TRUE, FileUtils.Extension.XML, FileUtils.Extension.ALL);
                if (f == null) {
                    return;
                }
                currentSaveFile = f;
            }
            case Save: {
                if (currentSaveFile == null) {
                    currentSaveFile = FileUtils.getFile(currentSaveFile, "Save game data", Boolean.TRUE, FileUtils.Extension.XML, FileUtils.Extension.ALL);
                }
                if (currentSaveFile == null) break;
                currentSaveFile.delete();
                JAXB.marshal((Object)ApplicationState.getInstance().getGameData(), (File)currentSaveFile);
            }
        }
    }

    public static MenuBar buildMenu() {
        MenuBar menu = new MenuBar();
        Menu currentMenu = null;
        for (MAIN_ACTIONS action : MAIN_ACTIONS.values()) {
            if (action.name().startsWith("_")) {
                if (currentMenu != null) {
                    menu.getMenus().add(currentMenu);
                }
                currentMenu = new Menu(action.name().replace("_", ""));
                continue;
            }
            MenuItem item = new MenuItem(action.name().replaceAll("_", " "));
            item.setOnAction(t -> {
                try {
                    UIAction.actionPerformed(action);
                }
                catch (IOException ex) {
                    Logger.getLogger(Application.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            currentMenu.getItems().add((Object)item);
        }
        menu.getMenus().add(currentMenu);
        menu.setMinWidth(1.0);
        return menu;
    }

    public static void quit() {
        UIAction.confirm("Quit?  Are you sure?", UIAction::quitWithoutConfirming, null);
    }

    public static void quitWithoutConfirming() {
        Application.shutdown();
        Platform.runLater(Platform::exit);
    }

    public static WritableImage getBadImage(int width, int height) {
        if (badImage == null) {
            badImage = new Image("images/icon_brokenLink.png");
        }
        WritableImage img = new WritableImage(width, height);
        img.getPixelWriter().setPixels(0, 0, (int)badImage.getWidth(), (int)badImage.getHeight(), badImage.getPixelReader(), 0, 0);
        return img;
    }

    public static void confirm(String message, Runnable yes, Runnable no) {
        UIAction.choose(message, new Choice("Yes", yes), new Choice("No", no));
    }

    public static void alert(String message) {
        UIAction.choose(message, new Choice("Ok", null));
    }

    public static void choose(String message, Choice ... choices) {
        Stage dialogStage = new Stage();
        HBoxBuilder options = (HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER).spacing(10.0).padding(new Insets(5.0));
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Choice c : choices) {
            Button b = new Button(c.text);
            b.setOnAction(t -> {
                if (c.handler != null) {
                    c.handler.run();
                }
                dialogStage.close();
            });
            buttons.add(b);
        }
        options.children(buttons);
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.setScene(new Scene((Parent)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{new Text(message), options.build()})).alignment(Pos.CENTER).padding(new Insets(5.0))).build()));
        dialogStage.show();
    }

    public static String getText(String message, String defaultValue) {
        TextInputDialog dialog = new TextInputDialog(defaultValue);
        dialog.setTitle("MythosScript Editor");
        dialog.setHeaderText("Respond and press OK, or Cancel to abort");
        ImageView graphic = new ImageView(new Image("images/revolver_icon.png"));
        graphic.setFitHeight(50.0);
        graphic.setFitWidth(50.0);
        graphic.setSmooth(true);
        dialog.setGraphic((Node)graphic);
        dialog.setContentText(message);
        return dialog.showAndWait().orElse("");
    }

    public static Script createAndEditScript(Scope scope) {
        Script script = new Script();
        script.setName("New Script");
        ApplicationUIController.getController().getVisibleEditor().addScript(script);
        return UIAction.editScript(script, scope);
    }

    public static Script editScript(Script script, Scope scope) {
        if (script == null) {
            System.err.println("Requested to edit a null script object, ignoring!");
            return null;
        }
        MythosEditor editor = new MythosEditor(script, scope);
        editor.show();
        return script;
    }

    public static void createAndEditVariable(Scope scope) throws IntrospectionException {
        Variable newVariable = new Variable();
        newVariable.setName("changeme");
        newVariable.setType("String");
        newVariable.setComment("");
        Optional<Variable> var = UIAction.editAndGetVariable(newVariable);
        if (var.isPresent()) {
            if (scope.getVariables() == null) {
                scope.setVariables(new Variables());
            }
            scope.getVariables().getVariable().add(var.get());
        }
    }

    public static void editVariable(Variable var, Global global) {
        try {
            UIAction.editAndGetVariable(var);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(UIAction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Optional<Variable> editAndGetVariable(Variable v) throws IntrospectionException {
        ModalEditor editor = new ModalEditor();
        LinkedHashMap<String, ModalEditor.EditControl> controls = new LinkedHashMap<String, ModalEditor.EditControl>();
        controls.put("name", new ModalEditor.TextControl());
        controls.put("type", new ModalEditor.TextControl());
        controls.put("comment", new ModalEditor.TextControl());
        return editor.editObject(v, controls, Variable.class, "Variable", "Edit and press OK, or Cancel to abort");
    }

    public static void createAndEditUserType() throws IntrospectionException {
        UserType type = new UserType();
        if (UIAction.editAndGetUserType(type).isPresent()) {
            if (ApplicationState.getInstance().getGameData().getGlobal().getUserTypes() == null) {
                ApplicationState.getInstance().getGameData().getGlobal().setUserTypes(new Global.UserTypes());
            }
            ApplicationState.getInstance().getGameData().getGlobal().getUserTypes().getUserType().add(type);
        }
    }

    public static void editUserType(UserType type) {
        try {
            UIAction.editAndGetUserType(type);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(UIAction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Optional<UserType> editAndGetUserType(UserType type) throws IntrospectionException {
        ModalEditor editor = new ModalEditor();
        LinkedHashMap<String, ModalEditor.EditControl> controls = new LinkedHashMap<String, ModalEditor.EditControl>();
        LinkedHashMap attributeControls = new LinkedHashMap();
        attributeControls.put("name", TextFieldTableCell.forTableColumn((StringConverter)new DefaultStringConverter(){

            public String toString(String value) {
                return value == null ? "Change Me" : value;
            }
        }));
        attributeControls.put("type", ComboBoxTableCell.forTableColumn((StringConverter)new DefaultStringConverter(){

            public String toString(String value) {
                return value == null ? "String" : value;
            }
        }, (Object[])new String[]{"String", "Boolean", "Number"}));
        attributeControls.put("comment", TextFieldTableCell.forTableColumn((StringConverter)new DefaultStringConverter()));
        controls.put("name", new ModalEditor.TextControl());
        controls.put("attribute", new ModalEditor.TableControl(attributeControls, Variable.class));
        controls.put("comment", new ModalEditor.TextControl());
        return editor.editObject(type, controls, UserType.class, "User Type", "Edit and press OK, or Cancel to abort");
    }

    public static Sheet createAndEditSheet() throws IntrospectionException {
        Sheet sheet = new Sheet();
        sheet.setName("New Sheet");
        if (ApplicationState.getInstance().getGameData().getGlobal().getSheets() == null) {
            ApplicationState.getInstance().getGameData().getGlobal().setSheets(new Global.Sheets());
        }
        ApplicationState.getInstance().getGameData().getGlobal().getSheets().getSheet().add(sheet);
        return UIAction.editSheet(sheet);
    }

    public static Sheet editSheet(Sheet item) {
        if (item == null) {
            System.err.println("Requested to edit a null sheet object, ignoring!");
            return null;
        }
        SheetEditor editor = new SheetEditor(item);
        editor.show();
        return item;
    }

    public static ImageConversionWizardController openImageConversionModal(Image image, ImageDitherEngine ditherEngine, int targetWidth, int targetHeight, ImageConversionPostAction postAction) {
        FXMLLoader fxmlLoader = new FXMLLoader(UIAction.class.getResource("/imageConversionWizard.fxml"));
        try {
            Stage primaryStage = new Stage();
            AnchorPane node = (AnchorPane)fxmlLoader.load();
            ImageConversionWizardController controller = (ImageConversionWizardController)fxmlLoader.getController();
            controller.setDitherEngine(ditherEngine);
            controller.setOutputDimensions(targetWidth, targetHeight);
            controller.setPostAction(postAction);
            controller.setSourceImage(image);
            Scene s = new Scene((Parent)node);
            primaryStage.setScene(s);
            primaryStage.show();
            controller.setStage(primaryStage);
            return controller;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void fadeOut(Node node, EventHandler<ActionEvent> callback) {
        FadeTransition ft = new FadeTransition(Duration.millis((double)250.0), node);
        ft.setFromValue(1.0);
        ft.setToValue(0.0);
        ft.setCycleCount(1);
        ft.setAutoReverse(false);
        ft.setOnFinished(callback);
        ft.play();
    }

    public static File getCurrentSaveFile() {
        return currentSaveFile;
    }

    private UIAction() {
    }

    public static class Choice {
        String text;
        Runnable handler;

        public Choice(String text, Runnable handler) {
            this.text = text;
            this.handler = handler;
        }
    }

    public static enum MAIN_ACTIONS {
        _General,
        Load,
        Save,
        Save_as,
        Apple_Mode,
        C64_Mode,
        About_Outlaw_Editor,
        Quit,
        _Map,
        Create_new_map,
        Export_map_to_image,
        _Tiles,
        Create_new_tile,
        Export_tile_to_image,
        Delete_tile,
        _Images,
        Create_new_image,
        Import_image,
        Export_image_as_raw,
        Delete_image;

    }
}

