/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui;

import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.ScaleTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.Duration;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Tile;
import org.badvision.outlaweditor.ui.UIAction;

public class TileSelectModal {
    public static final int GRID_SPACING = 7;
    public static final int MAX_TILES_PER_ROW = 16;
    public static AnchorPane currentTileSelector;
    private static final EventHandler<MouseEvent> cancelTileSelectMouseHandler;
    private static final EventHandler<KeyEvent> cancelTileSelectKeyHandler;

    public static void showTileSelectModal(Pane anchorPane, String category, Callback<Tile, ?> callback) {
        if (currentTileSelector != null) {
            return;
        }
        currentTileSelector = new AnchorPane();
        int TILE_WIDTH = ApplicationState.getInstance().getCurrentPlatform().tileRenderer.getWidth();
        int TILE_HEIGHT = ApplicationState.getInstance().getCurrentPlatform().tileRenderer.getHeight();
        List tiles = ApplicationState.getInstance().getGameData().getTile().stream().filter(t -> category == null || t.getCategory().equals(category)).collect(Collectors.toList());
        int tilesPerRow = (int)Math.min((double)tiles.size(), Math.min(16.0, anchorPane.getWidth() / (double)(TILE_WIDTH + 7)));
        int numRows = (tiles.size() + tilesPerRow - 1) / tilesPerRow;
        int prefWidth = tilesPerRow * (TILE_WIDTH + 7) + 7;
        currentTileSelector.setPrefWidth((double)prefWidth);
        currentTileSelector.setPrefHeight((double)Math.min(numRows * (TILE_HEIGHT + 7) + 7, prefWidth));
        for (int i = 0; i < tiles.size(); ++i) {
            Tile tile = (Tile)tiles.get(i);
            ImageView tileIcon = new ImageView((Image)TileUtils.getImage(tile, ApplicationState.getInstance().getCurrentPlatform()));
            currentTileSelector.getChildren().add((Object)tileIcon);
            tileIcon.setOnMouseClicked(e -> {
                e.consume();
                callback.call((Object)tile);
                TileSelectModal.closeCurrentTileSelector();
            });
            tileIcon.setOnMouseEntered(e -> {
                tileIcon.setEffect((Effect)new DropShadow(BlurType.GAUSSIAN, Color.CORNSILK, 5.0, 0.5, 0.0, 0.0));
                ScaleTransition st = new ScaleTransition(Duration.millis((double)150.0), (Node)tileIcon);
                st.setAutoReverse(false);
                st.setToX(1.25);
                st.setToY(1.25);
                st.play();
            });
            tileIcon.setOnMouseExited(e -> {
                tileIcon.setEffect(null);
                ScaleTransition st = new ScaleTransition(Duration.millis((double)150.0), (Node)tileIcon);
                st.setAutoReverse(false);
                st.setToX(1.0);
                st.setToY(1.0);
                st.play();
            });
            tileIcon.setLayoutX((double)(7 + i % tilesPerRow * (TILE_WIDTH + 7)));
            tileIcon.setLayoutY((double)(7 + i / tilesPerRow * (TILE_HEIGHT + 7)));
        }
        currentTileSelector.setLayoutX((anchorPane.getWidth() - currentTileSelector.getPrefWidth()) / 2.0);
        currentTileSelector.setLayoutY((anchorPane.getHeight() - currentTileSelector.getPrefHeight()) / 2.0);
        currentTileSelector.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new Color(0.7, 0.7, 0.9, 0.75), new CornerRadii(10.0), null)}));
        currentTileSelector.setEffect((Effect)new DropShadow(5.0, 1.0, 1.0, Color.BLACK));
        anchorPane.getChildren().add((Object)currentTileSelector);
        ApplicationState.getInstance().getPrimaryStage().getScene().addEventHandler(KeyEvent.KEY_PRESSED, cancelTileSelectKeyHandler);
        ApplicationState.getInstance().getPrimaryStage().getScene().addEventFilter(MouseEvent.MOUSE_PRESSED, cancelTileSelectMouseHandler);
    }

    public static void closeCurrentTileSelector() {
        ApplicationState.getInstance().getPrimaryStage().getScene().removeEventHandler(KeyEvent.KEY_PRESSED, cancelTileSelectKeyHandler);
        ApplicationState.getInstance().getPrimaryStage().getScene().removeEventFilter(MouseEvent.MOUSE_PRESSED, cancelTileSelectMouseHandler);
        UIAction.fadeOut((Node)currentTileSelector, (EventHandler<ActionEvent>)((EventHandler)ev -> {
            if (currentTileSelector != null) {
                Pane parent = (Pane)currentTileSelector.getParent();
                parent.getChildren().remove((Object)currentTileSelector);
                currentTileSelector = null;
            }
        }));
    }

    private TileSelectModal() {
    }

    static {
        cancelTileSelectMouseHandler = e -> {
            if (!(e.getSource() instanceof ImageView)) {
                e.consume();
            }
            TileSelectModal.closeCurrentTileSelector();
        };
        cancelTileSelectKeyHandler = e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                TileSelectModal.closeCurrentTileSelector();
            }
        };
    }
}

