/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui;

import java.net.URL;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.MenuItem;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.badvision.outlaweditor.MythosEditor;
import org.badvision.outlaweditor.ui.UIAction;

public class MythosScriptEditorController
implements Initializable {
    public static final String MYTHOS_EDITOR = "/mythos/mythos-editor/html/editor.html";
    public static final String ONLOAD_SCRIPT = "onloadScript";
    JSObject mythos;
    @FXML
    WebView editorView;
    @FXML
    private MenuItem menuItemAbortChanges;
    @FXML
    private MenuItem menuItemAboutBlockly;
    @FXML
    private MenuItem menuItemApplyChanges;
    @FXML
    private MenuItem menuItemMythosHelp;
    @FXML
    private MenuItem menuItemRedo;
    @FXML
    private MenuItem menuItemUndo;
    MythosEditor editor;

    public void setEditor(MythosEditor editor) {
        this.editor = editor;
    }

    public void onAbortChangesSelected(ActionEvent event) {
        this.editor.close();
    }

    public void onAboutBlocklySelected(ActionEvent event) {
    }

    public void onApplyChangesSelected(ActionEvent event) {
        this.editor.applyChanges();
        this.editor.close();
    }

    public void onMythosHelpSelected(ActionEvent event) {
    }

    public void onRedoSelected(ActionEvent event) {
    }

    public void onUndoSelected(ActionEvent event) {
    }

    public void initialize(URL fxmlFileLocation, ResourceBundle resources) {
        assert (this.editorView != null) : "fx:id=\"editorView\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        assert (this.menuItemAbortChanges != null) : "fx:id=\"menuItemAbortChanges\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        assert (this.menuItemAboutBlockly != null) : "fx:id=\"menuItemAboutBlockly\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        assert (this.menuItemApplyChanges != null) : "fx:id=\"menuItemApplyChanges\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        assert (this.menuItemMythosHelp != null) : "fx:id=\"menuItemMythosHelp\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        assert (this.menuItemRedo != null) : "fx:id=\"menuItemRedo\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        assert (this.menuItemUndo != null) : "fx:id=\"menuItemUndo\" was not injected: check your FXML file 'MythosScriptEditor.fxml'.";
        String loadScript = resources.getString(ONLOAD_SCRIPT);
        if (loadScript != null) {
            this.editorView.getEngine().getLoadWorker().stateProperty().addListener((value, old, newState) -> {
                if (newState == Worker.State.SUCCEEDED) {
                    this.mythos = (JSObject)this.editorView.getEngine().executeScript("Mythos");
                    this.mythos.setMember("editor", this.editor);
                    this.editorView.getEngine().executeScript(loadScript);
                }
            });
            this.editorView.getEngine().setPromptHandler(prompt -> UIAction.getText(prompt.getMessage(), prompt.getDefaultValue()));
        }
        this.editorView.getEngine().load(this.getClass().getResource(MYTHOS_EDITOR).toExternalForm());
    }

    public static ResourceBundle createResourceBundle(final Map<String, String> input) {
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                Object[][] output = new Object[input.size()][2];
                Set keys = input.keySet();
                int i = 0;
                for (String key : keys) {
                    output[i] = new Object[]{key, input.get(key)};
                    ++i;
                }
                return output;
            }
        };
    }

    public String getScriptXml() {
        return String.valueOf(this.editorView.getEngine().executeScript("Mythos.getScriptXml();"));
    }
}

