/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui;

import com.sun.glass.ui.Application;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.badvision.outlaweditor.data.DataUtilities;

public class ModalEditor {
    public PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] descriptors, String propertyName) {
        for (PropertyDescriptor descriptor : descriptors) {
            if (!descriptor.getName().equalsIgnoreCase(propertyName)) continue;
            return descriptor;
        }
        return null;
    }

    public <T> Optional<T> editObject(T sourceObject, Map<String, EditControl> obj, Class<T> clazz, String title, String header) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(clazz);
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.setHeaderText(header);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 50.0, 10.0, 10.0));
        AtomicInteger row = new AtomicInteger(0);
        obj.forEach((property, control) -> {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(info.getPropertyDescriptors(), (String)property);
            if (row.get() == 0) {
                Platform.runLater(() -> control.getControl().requestFocus());
            }
            grid.add((Node)new Label(DataUtilities.uppercaseFirst(descriptor.getDisplayName())), 0, row.get());
            grid.add(control.getControl(), 1, row.getAndAdd(1));
            try {
                control.setValue(descriptor.getReadMethod().invoke(sourceObject, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                Logger.getLogger(ModalEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                obj.forEach((property, control) -> {
                    PropertyDescriptor descriptor = this.getPropertyDescriptor(info.getPropertyDescriptors(), (String)property);
                    try {
                        if (descriptor.getWriteMethod() != null) {
                            descriptor.getWriteMethod().invoke(sourceObject, control.getValue());
                        } else {
                            Object val = descriptor.getReadMethod().invoke(sourceObject, new Object[0]);
                            if (val instanceof List) {
                                List sourceList = (List)val;
                                sourceList.clear();
                                sourceList.addAll((Collection)control.getValue());
                            }
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException ex) {
                        Logger.getLogger(ModalEditor.class.getName()).log(Level.SEVERE, "Error updating property " + property, ex);
                    }
                });
                return sourceObject;
            }
            return null;
        });
        return dialog.showAndWait();
    }

    static class TableControl<T, S>
    implements EditControl<List<T>> {
        Map<String, Callback<TableColumn<T, S>, TableCell<T, S>>> cols;
        Class<T> rowType;
        ObservableList<T> rows;
        TableView<T> table;
        VBox control;

        public TableControl(Map<String, Callback<TableColumn<T, S>, TableCell<T, S>>> cols, Class<T> rowType) {
            this.cols = cols;
            this.rowType = rowType;
            this.rows = FXCollections.observableArrayList();
            this.table = new TableView(this.rows);
            cols.forEach((colName, factory) -> {
                TableColumn col = new TableColumn(DataUtilities.uppercaseFirst(colName));
                col.setCellValueFactory(param -> {
                    try {
                        return new JavaBeanStringPropertyBuilder().bean(param.getValue()).name(colName).build();
                    }
                    catch (NoSuchMethodException ex) {
                        Logger.getLogger(ModalEditor.class.getName()).log(Level.SEVERE, null, ex);
                        throw new RuntimeException(ex);
                    }
                });
                col.setCellFactory(factory);
                col.setPrefWidth(150.0);
                this.table.getColumns().add((Object)col);
            });
            this.table.setPlaceholder((Node)new Label("Click + to add one or more attributes"));
            this.table.setEditable(true);
            this.table.setPrefWidth((double)(cols.size() * 150 + 5));
            Button addButton = new Button("+");
            addButton.setOnAction(event -> {
                try {
                    this.rows.add(rowType.newInstance());
                    Application.invokeLater(() -> {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(ModalEditor.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.table.edit(this.rows.size() - 1, (TableColumn)this.table.getColumns().get(0));
                    });
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    Logger.getLogger(ModalEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            Button removeButton = new Button("-");
            removeButton.setOnAction(event -> this.rows.removeAll((Collection)this.table.getSelectionModel().getSelectedItems()));
            addButton.setPrefWidth(25.0);
            removeButton.setPrefWidth(25.0);
            this.control = new VBox(new Node[]{this.table, new HBox(10.0, new Node[]{addButton, removeButton})});
        }

        @Override
        public Node getControl() {
            return this.control;
        }

        @Override
        public List<T> getValue() {
            return this.rows;
        }

        @Override
        public void setValue(List<T> value) {
            this.rows.setAll(value);
        }
    }

    public static class TextControl
    implements EditControl<String> {
        TextField control = new TextField();

        public Control getControl() {
            return this.control;
        }

        @Override
        public String getValue() {
            return this.control.getText();
        }

        @Override
        public void setValue(String value) {
            this.control.setText(value);
        }
    }

    public static interface EditControl<V> {
        public Node getControl();

        public V getValue();

        public void setValue(V var1);
    }
}

