/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxListCell;
import org.badvision.outlaweditor.data.PropertyHelper;
import org.badvision.outlaweditor.ui.impl.ApplicationUIControllerImpl;

public abstract class EntitySelectorCell<T>
extends ComboBoxListCell<T> {
    static Map<TextField, Object> lastSelected = new HashMap<TextField, Object>();
    TextField nameField;
    TextField categoryField;

    public EntitySelectorCell(TextField tileNameField, TextField categoryNameField) {
        super.setPrefWidth(125.0);
        this.nameField = tileNameField;
        this.categoryField = categoryNameField;
    }

    public void updateSelected(boolean sel) {
        this.updateItem(this.getItem(), false);
    }

    public void updateItem(T item, boolean empty) {
        this.textProperty().unbind();
        super.updateItem(item, empty);
        if (item != null && !(item instanceof String)) {
            try {
                if (this.categoryField != null) {
                    this.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{PropertyHelper.stringProp(item, "category"), "/", PropertyHelper.stringProp(item, "name")}));
                } else {
                    this.textProperty().bind((ObservableValue)PropertyHelper.stringProp(item, "name"));
                }
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(ApplicationUIControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.finishUpdate(item);
        } else {
            this.setText(null);
        }
    }

    public void finishUpdate(T item) {
    }
}

