/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.spelling;

import org.badvision.outlaweditor.data.DataUtilities;

public class Suggestion
implements Comparable<Suggestion> {
    public String original;
    public String word;
    public double similarity;
    private double similarityRank = -1.0;

    public String getWord() {
        return this.word;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    @Override
    public int compareTo(Suggestion o) {
        if (this.similarity == o.similarity) {
            double rank2;
            double rank1 = this.getSimilarityRank();
            if (rank1 == (rank2 = o.getSimilarityRank())) {
                return this.word.compareTo(o.word);
            }
            return (int)Math.signum(rank2 - rank1);
        }
        return (int)Math.signum(this.similarity - o.similarity);
    }

    private double getSimilarityRank() {
        if (this.similarityRank < 0.0) {
            this.similarityRank = DataUtilities.rankMatch(this.word, this.original, 3) + DataUtilities.rankMatch(this.word, this.original, 2);
        }
        return this.similarityRank;
    }
}

