/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.spelling;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.spelling.SpellResponse;
import org.badvision.outlaweditor.spelling.Suggestion;

public class SpellChecker {
    private static HashMap<Character, Set<String>> dictionary;

    public SpellChecker() {
        SpellChecker.loadDictionary();
    }

    public SpellResponse check(String value) {
        SpellResponse response = new SpellResponse();
        String[] words = value.split("[^A-Za-z]");
        int pos = 0;
        for (String word : words) {
            Set<Suggestion> suggestions = this.getSuggestions(word);
            if (suggestions != null && !suggestions.isEmpty()) {
                SpellResponse.Source source = new SpellResponse.Source();
                source.start = pos;
                source.word = word;
                response.corrections.put(source, suggestions);
            }
            pos += word.length() + 1;
        }
        return response;
    }

    private static void loadDictionary() {
        if (dictionary == null) {
            URL dictionaryPath = SpellChecker.class.getResource("/mythos/dictionary.txt");
            try {
                BufferedReader content = new BufferedReader(new InputStreamReader((InputStream)dictionaryPath.getContent()));
                dictionary = new HashMap();
                content.lines().forEach(word -> {
                    String lower = word.toLowerCase();
                    Set<String> words = dictionary.get(Character.valueOf(lower.charAt(0)));
                    if (words == null) {
                        words = new LinkedHashSet<String>();
                        dictionary.put(Character.valueOf(lower.charAt(0)), words);
                    }
                    words.add((String)word);
                });
            }
            catch (IOException ex) {
                Logger.getLogger(SpellChecker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Set<Suggestion> getSuggestions(String word) {
        double threshold;
        TreeSet<Suggestion> suggestions = new TreeSet<Suggestion>();
        if (word == null || word.isEmpty()) {
            return suggestions;
        }
        String lower = word.toLowerCase();
        Character first = Character.valueOf(lower.charAt(0));
        Set<String> words = dictionary.get(first);
        int length = lower.length();
        double d = threshold = length <= 2 ? 0.0 : Math.log(length - 1) * 1.75;
        if (words != null) {
            if (lower.length() <= 2 || words.contains(lower)) {
                return null;
            }
            words.parallelStream().forEach(dictWord -> {
                int distance = DataUtilities.levenshteinDistance(lower, dictWord, (int)threshold);
                if ((double)distance <= threshold) {
                    Suggestion suggestion = new Suggestion();
                    suggestion.original = lower;
                    suggestion.similarity = distance;
                    suggestion.word = dictWord;
                    suggestions.add(suggestion);
                }
            });
            if (suggestions.isEmpty()) {
                Suggestion suggestion = new Suggestion();
                suggestion.original = lower;
                suggestion.similarity = 100.0;
                suggestion.word = "????";
                suggestions.add(suggestion);
            }
        }
        return suggestions;
    }
}

