/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.DataObserver;
import org.badvision.outlaweditor.data.DataProducer;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Tile;

public class TilesetUtils
implements Serializable {
    static Map<String, Tile> lookup;

    public static void addObserver(DataObserver o) {
        DataProducer.addObserver(TilesetUtils.class, o);
    }

    public static boolean add(Tile e) {
        boolean output = ApplicationState.getInstance().getGameData().getTile().add(e);
        DataProducer.notifyObservers(TilesetUtils.class);
        return output;
    }

    public static void clear() {
        ApplicationState.getInstance().getGameData().getTile().clear();
        DataProducer.notifyObservers(TilesetUtils.class);
    }

    public static void remove(Tile t) {
        ApplicationState.getInstance().getGameData().getTile().remove(t);
        DataProducer.notifyObservers(TilesetUtils.class);
    }

    public static Tile getTileById(String tileId) {
        if (lookup == null || lookup.get(tileId) == null && !lookup.containsKey(tileId)) {
            lookup = new HashMap<String, Tile>();
            for (Tile t : ApplicationState.getInstance().getGameData().getTile()) {
                lookup.put(TileUtils.getId(t), t);
            }
            if (lookup.get(tileId) == null) {
                lookup.put(tileId, null);
            }
        }
        return lookup.get(tileId);
    }

    private TilesetUtils() {
    }
}

