/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javax.xml.bind.JAXBElement;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.TilesetUtils;
import org.badvision.outlaweditor.data.xml.Map;
import org.badvision.outlaweditor.data.xml.ObjectFactory;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.data.xml.Scripts;
import org.badvision.outlaweditor.data.xml.Tile;
import org.badvision.outlaweditor.ui.UIAction;

public class TileMap
extends ArrayList<ArrayList<Tile>>
implements Serializable {
    public static final long serialVersionUID = 6486309334559843742L;
    Map backingMap;
    boolean backingMapStale = false;
    int width = 0;
    int height = 0;
    public static final double SATURATION = 0.7;
    public static final double VALUE = 1.0;
    public static double HUE = 180.0;
    private final java.util.Map<Integer, List<Script>> locationScripts = new HashMap<Integer, List<Script>>();
    private final java.util.Map<Script, Color> scriptColors = new HashMap<Script, Color>();
    public static String NULL_TILE_ID = "_";

    public TileMap(Map m) {
        this.loadFromMap(m);
    }

    public Optional<Color> getScriptColor(Script s) {
        return Optional.ofNullable(this.scriptColors.get(s));
    }

    public List<Script> getLocationScripts(int x, int y) {
        List<Script> list = this.locationScripts.get(this.getMortonNumber(x, y));
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public void putLocationScript(int x, int y, Script s) {
        Script.LocationTrigger trigger = new Script.LocationTrigger();
        trigger.setX(x);
        trigger.setY(y);
        s.getLocationTrigger().add(trigger);
        this.registerLocationScript(x, y, s);
    }

    public void removeLocationScripts(int x, int y) {
        int loc = this.getMortonNumber(x, y);
        List<Script> scripts = this.locationScripts.get(loc);
        if (scripts != null) {
            scripts.forEach((? super T s) -> s.getLocationTrigger().removeIf(t -> t.getX() == x && t.getY() == y));
        }
        this.locationScripts.remove(loc);
        ApplicationState.getInstance().getController().redrawScripts();
    }

    private void registerLocationScript(int x, int y, Script s) {
        int loc;
        List<Script> list;
        if (!this.scriptColors.containsKey(s)) {
            this.scriptColors.put(s, Color.hsb((double)HUE, (double)0.7, (double)(0.75 + Math.cos(HUE / Math.PI / 2.0) / 8.0)));
            HUE = (HUE + 27.0) % 360.0;
        }
        if ((list = this.locationScripts.get(loc = this.getMortonNumber(x, y))) == null) {
            list = new ArrayList<Script>();
            this.locationScripts.put(loc, list);
        }
        list.add(s);
        ApplicationState.getInstance().getController().redrawScripts();
    }

    private int getMortonNumber(int x, int y) {
        int morton = 0;
        for (int i = 0; i < 16; ++i) {
            int mask = 1 << i;
            morton += (x & mask) << i + 1;
            morton += (y & mask) << i;
        }
        return morton;
    }

    public Tile get(int x, int y) {
        if (this.size() <= y || this.get(y) == null) {
            return null;
        }
        if (((ArrayList)this.get(y)).size() <= x) {
            return null;
        }
        return (Tile)((ArrayList)this.get(y)).get(x);
    }

    public void put(int x, int y, Tile t) {
        this.width = Math.max(x + 1, this.width);
        this.height = Math.max(y + 1, this.height);
        for (int i = this.size(); i <= y; ++i) {
            this.add(null);
        }
        if (this.get(y) == null) {
            this.set(y, new ArrayList());
        }
        List row = (List)this.get(y);
        for (int i = row.size(); i <= x; ++i) {
            row.add(null);
        }
        row.set(x, t);
        this.backingMapStale = true;
    }

    public Map getBackingMap() {
        return this.backingMap;
    }

    public void updateBackingMap() {
        ObjectFactory f = new ObjectFactory();
        this.backingMap.getChunk().clear();
        Map.Chunk c = new Map.Chunk();
        c.setX(0);
        c.setY(0);
        for (int y = 0; y < this.height; ++y) {
            ArrayList<String> row = new ArrayList<String>();
            for (int x = 0; x < this.width; ++x) {
                Tile t = this.get(x, y);
                if (t == null) {
                    row.add(NULL_TILE_ID);
                    continue;
                }
                row.add(TileUtils.getId(t));
            }
            c.getRow().add(f.createMapChunkRow(row));
        }
        this.backingMap.getChunk().add(c);
        this.backingMapStale = false;
    }

    private void loadFromMap(Map m) {
        this.clear();
        this.width = 0;
        this.height = 0;
        HashSet unknownTiles = new HashSet();
        Scripts scripts = m.getScripts();
        if (scripts != null) {
            ArrayList<Script> allScripts = new ArrayList<Script>(scripts.getScript());
            allScripts.forEach((? super T s) -> s.getLocationTrigger().forEach((? super T l) -> this.registerLocationScript(l.getX(), l.getY(), (Script)s)));
        }
        m.getChunk().forEach((? super T c) -> {
            int y = c.getY();
            for (JAXBElement<List<String>> row : c.getRow()) {
                int x = c.getX();
                for (String tileId : (List)row.getValue()) {
                    Tile t = null;
                    if (!TileMap.isNullTile(tileId) && (t = TilesetUtils.getTileById(tileId)) == null) {
                        t = new Tile();
                        unknownTiles.add(t);
                        Platform p = ApplicationState.getInstance().getCurrentPlatform();
                        WritableImage img = UIAction.getBadImage(p.tileRenderer.getWidth(), p.tileRenderer.getHeight());
                        TileUtils.setImage(t, p, img);
                    }
                    this.put(x, y, t);
                    ++x;
                }
                ++y;
            }
        });
        if (!unknownTiles.isEmpty()) {
            int numMissing = unknownTiles.size();
            Alert missingTileAlert = new Alert(Alert.AlertType.WARNING);
            missingTileAlert.setContentText((numMissing > 1 ? "There were " + numMissing + " missing tiles." : "There was a missing tile.  ") + "Blank placeholders have been added.");
            missingTileAlert.showAndWait();
        }
        this.backingMap = m;
        this.backingMapStale = false;
    }

    public static boolean isNullTile(String tileId) {
        return tileId.equalsIgnoreCase(NULL_TILE_ID);
    }

    public void removeScriptFromMap(Script script) {
        script.getLocationTrigger().clear();
        this.locationScripts.values().stream().filter(scripts -> scripts != null).forEach((? super T scripts) -> scripts.remove(script));
        this.backingMap.getScripts().getScript().remove(script);
    }
}

