/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.xml.Block;
import org.badvision.outlaweditor.data.xml.Field;
import org.badvision.outlaweditor.data.xml.Global;
import org.badvision.outlaweditor.data.xml.Map;
import org.badvision.outlaweditor.data.xml.NamedEntity;
import org.badvision.outlaweditor.data.xml.Scope;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.ui.UIAction;

public class DataUtilities {
    private DataUtilities() {
    }

    public static void ensureGlobalExists() {
        if (ApplicationState.getInstance().getGameData().getGlobal() == null) {
            ApplicationState.getInstance().getGameData().setGlobal(new Global());
        }
    }

    public static void sortMaps(List<? extends Map> entities) {
        if (entities == null) {
            return;
        }
        entities.sort((a, b) -> {
            String nameB;
            String nameA = a == null ? "" : DataUtilities.nullSafe(a.getName());
            String string = nameB = b == null ? "" : DataUtilities.nullSafe(b.getName());
            if (nameA.equalsIgnoreCase("init")) {
                return -1;
            }
            if (nameB.equalsIgnoreCase("init")) {
                return 1;
            }
            return nameA.compareTo(nameB);
        });
    }

    public static void sortNamedEntities(List<? extends NamedEntity> entities) {
        if (entities == null) {
            return;
        }
        entities.sort((a, b) -> {
            String nameB;
            String nameA = a == null ? "" : DataUtilities.nullSafe(a.getName());
            String string = nameB = b == null ? "" : DataUtilities.nullSafe(b.getName());
            if (nameA.equalsIgnoreCase("init")) {
                return -1;
            }
            if (nameB.equalsIgnoreCase("init")) {
                return 1;
            }
            return nameA.compareTo(nameB);
        });
    }

    public static String nullSafe(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String uppercaseFirst(String str) {
        StringBuilder b = new StringBuilder(str);
        int i = 0;
        do {
            b.replace(i, i + 1, b.substring(i, i + 1).toUpperCase());
        } while ((i = b.indexOf(" ", i) + 1) > 0 && i < b.length());
        return b.toString();
    }

    public static void cleanupScriptName(Script script) {
        if (script.getName() != null) {
            return;
        }
        DataUtilities.extract(script.getBlock(), Field.class).filter(f -> f.getName().equalsIgnoreCase("NAME")).findFirst().ifPresent(f -> script.setName(f.getValue()));
    }

    public static void cleanupScriptNames(Scope s) {
        if (s.getScripts() == null || s.getScripts().getScript() == null) {
            return;
        }
        s.getScripts().getScript().forEach(DataUtilities::cleanupScriptName);
    }

    public static void cleanupAllScriptNames() {
        DataUtilities.cleanupScriptNames(ApplicationState.getInstance().getGameData().getGlobal());
        ApplicationState.getInstance().getGameData().getMap().forEach(DataUtilities::cleanupScriptNames);
    }

    public static <T> Optional<T> extractFirst(Block block, Class<T> desiredType) {
        return DataUtilities.extract(block, desiredType).findFirst();
    }

    public static <T> Stream<T> extract(Block block, Class<T> desiredType) {
        if (block != null && block.getMutationOrFieldOrValue() != null) {
            return block.getMutationOrFieldOrValue().stream().filter(o -> o.getClass().equals(desiredType));
        }
        return Stream.empty();
    }

    public static String getValue(java.util.Map<QName, String> map, String name) {
        return map.entrySet().stream().filter(e -> ((QName)e.getKey()).getLocalPart().equals(name)).map(e -> (String)e.getValue()).findFirst().orElse(null);
    }

    public static void setValue(java.util.Map<QName, String> map, String name, String newValue) {
        Optional<Map.Entry> attr = map.entrySet().stream().filter(e -> ((QName)e.getKey()).getLocalPart().equals(name)).findFirst();
        if (attr.isPresent()) {
            attr.get().setValue(newValue);
        } else {
            map.put(new QName(name), newValue);
        }
    }

    public static List<List<String>> readFromFile(File file) {
        try {
            if (file.getName().toLowerCase().endsWith("txt") || file.getName().toLowerCase().endsWith("tsv")) {
                return DataUtilities.readTextFile(file);
            }
            if (file.getName().toLowerCase().endsWith("xls")) {
                return DataUtilities.readLegacyExcel(file);
            }
            if (file.getName().toLowerCase().endsWith("xlsx")) {
                return DataUtilities.readExcel(file);
            }
        }
        catch (IOException | InvalidFormatException ex) {
            Logger.getLogger(DataUtilities.class.getName()).log(Level.SEVERE, null, ex);
        }
        UIAction.alert("Couldn't figure out how to import file " + file.getName());
        return Collections.EMPTY_LIST;
    }

    public static List<List<String>> readTextFile(File file) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        return reader.lines().map(line -> Arrays.asList(line.split("\\t"))).collect(Collectors.toList());
    }

    public static List<List<String>> readLegacyExcel(File file) throws FileNotFoundException, IOException {
        return DataUtilities.readSheet(new HSSFWorkbook(new FileInputStream(file)));
    }

    public static List<List<String>> readExcel(File file) throws FileNotFoundException, IOException, InvalidFormatException {
        return DataUtilities.readSheet(new XSSFWorkbook(file));
    }

    public static List<List<String>> readSheet(Workbook workbook) {
        Sheet sheet = workbook.getSheetAt(0);
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        sheet.forEach(row -> {
            ArrayList rowData = new ArrayList();
            row.forEach(cell -> {
                String col = DataUtilities.getStringValueFromCell(cell);
                rowData.add(col);
            });
            data.add(rowData);
        });
        return data;
    }

    public static String getStringValueFromCell(Cell cell) {
        switch (cell.getCellType()) {
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case 3: {
                return null;
            }
            case 0: {
                return Double.toString(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
        }
        return "???";
    }

    public static String hexDump(byte[] data) {
        StringBuilder dump = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                dump.append(",");
            }
            dump.append(DataUtilities.getHexValueFromByte(data[i]));
        }
        return dump.toString();
    }

    public static String getHexValueFromByte(byte val) {
        return DataUtilities.getHexValue(val & 0xFF);
    }

    public static String getHexValue(int val) {
        if (val < 16) {
            return "0" + Integer.toHexString(val);
        }
        return Integer.toHexString(val);
    }

    public static int levenshteinDistance(String s, String t, int limit) {
        int i;
        int sizeDiff = Math.abs(s.length() - t.length());
        if (sizeDiff > limit) {
            return sizeDiff;
        }
        s = s.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", "");
        t = t.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", "");
        int m = s.length();
        int n = t.length();
        int[][] dist = new int[m + 1][n + 1];
        for (i = 1; i <= m; ++i) {
            dist[i][0] = i;
        }
        for (i = 1; i <= n; ++i) {
            dist[0][i] = i;
        }
        for (int j = 1; j <= n; ++j) {
            int min = 100;
            for (int i2 = 1; i2 <= m; ++i2) {
                if (s.charAt(i2 - 1) == t.charAt(j - 1)) {
                    dist[i2][j] = dist[i2 - 1][j - 1];
                } else {
                    int del = dist[i2 - 1][j] + 1;
                    int insert = dist[i2][j - 1] + 1;
                    int sub = dist[i2 - 1][j - 1] + 1;
                    dist[i2][j] = Math.min(Math.min(del, insert), sub);
                }
                min = Math.min(min, dist[i2][j]);
            }
            if (min <= limit) continue;
            return min;
        }
        return dist[m][n];
    }

    public static double rankMatch(String c1, String c2, int width) {
        double score = 0.0;
        String s1 = c1.toLowerCase();
        String s2 = c2.toLowerCase();
        for (int i = 0; i < s1.length() + 1 - width; ++i) {
            String m = s1.substring(i, i + width);
            int j = 0;
            while ((j = s2.indexOf(m, j)) > -1) {
                score += (double)width;
                ++j;
            }
        }
        double l1 = s1.length();
        double l2 = s2.length();
        double adjustment = Math.min(l1, l2) / Math.max(l1, l2) + 0.1;
        return score * adjustment * adjustment;
    }

    public static String findBestMatch(String match, Collection<String> search) {
        if (search == null || search.isEmpty()) {
            return null;
        }
        RankingComparator r = new RankingComparator(match);
        ArrayList<String> candidates = new ArrayList<String>(search);
        Collections.sort(candidates, r);
        double score = DataUtilities.levenshteinDistance(match, (String)candidates.get(0), 20);
        if (score > 1.0) {
            return (String)candidates.get(0);
        }
        return null;
    }

    public static class RankingComparator
    implements Comparator<String> {
        String match;

        public RankingComparator(String match) {
            this.match = match + " ";
        }

        @Override
        public int compare(String o1, String o2) {
            double s1 = DataUtilities.levenshteinDistance(this.match, o1, 20);
            double s2 = DataUtilities.levenshteinDistance(this.match, o2, 20);
            if (s2 == s1) {
                s1 = DataUtilities.rankMatch(o1, this.match, 3) + DataUtilities.rankMatch(o1, this.match, 2);
                s2 = DataUtilities.rankMatch(o2, this.match, 3) + DataUtilities.rankMatch(o2, this.match, 2);
                if (s2 == s1) {
                    return o1.compareTo(o2);
                }
                return (int)Math.signum(s2 - s1);
            }
            return (int)(s2 - s1);
        }
    }
}

