/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.data;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.badvision.outlaweditor.data.DataObserver;

public class DataProducer {
    static Map<Object, List<WeakReference<DataObserver>>> observers;

    public static void clear() {
        observers = new ConcurrentHashMap<Object, List<WeakReference<DataObserver>>>();
    }

    public static List<WeakReference<DataObserver>> getObservers(Object o) {
        if (observers.get(o) == null) {
            observers.put(o, new ArrayList());
        }
        return observers.get(o);
    }

    public static void addObserver(Object o, DataObserver observer) {
        DataProducer.getObservers(o).add(new WeakReference<DataObserver>(observer));
    }

    public static void notifyObservers(Object o) {
        for (WeakReference<DataObserver> ref : DataProducer.getObservers(o)) {
            DataObserver observer = (DataObserver)ref.get();
            if (observer == null) continue;
            observer.observedObjectChanged(o);
        }
    }

    static {
        DataProducer.clear();
    }
}

