/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple.dhgr;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.data.DataObserver;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Tile;

public enum FillPattern {
    Magenta(true, 4, false, "+---+---+---+---+---+---+---"),
    Pink(true, 4, false, "++-+++-+++-+++-+++-+++-+++-+"),
    Purple(true, 4, false, "++--++--++--++--++--++--++--"),
    LtBlue(true, 4, false, "+++-+++-+++-+++-+++-+++-+++-"),
    MedBlue(true, 4, false, "-++--++--++--++--++--++--++-"),
    Blue(true, 4, false, "-+---+---+---+---+---+---+--"),
    Green(true, 4, false, "--+---+---+---+---+---+---+-"),
    LtGreen(true, 4, false, "--++--++--++--++--++--++--++"),
    Aqua(true, 4, false, "-+++-+++-+++-+++-+++-+++-+++"),
    Yellow(true, 4, false, "+-+++-+++-+++-+++-+++-+++-++"),
    Orange(true, 4, false, "+--++--++--++--++--++--++--+"),
    Brown(true, 4, false, "---+---+---+---+---+---+---+"),
    Black(false, 1, false, "-------"),
    White(false, 1, false, "+++++++"),
    Grey1(false, 2, false, "+-+-+-+-+-+-+-"),
    Grey2(false, 2, false, "-+-+-+-+-+-+-+");

    Integer[] pattern;
    int[] bytePattern;
    int width;
    boolean hiBitMatters;
    WritableImage preview;

    public static int[] bitmask(boolean hiBit, String pattern) {
        int[] out = new int[pattern.length() / 7];
        int place = 1;
        int pos = 0;
        int value = hiBit ? 128 : 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '1' || c == '+') {
                value |= place;
            }
            out[pos] = value;
            if ((place <<= 1) < 128) continue;
            place = 1;
            value = hiBit ? 128 : 0;
            ++pos;
        }
        return out;
    }

    public static Integer[] buildPattern(boolean hiBit, String ... pattern) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String s : pattern) {
            for (int i : FillPattern.bitmask(hiBit, s)) {
                out.add(i);
            }
        }
        return out.toArray(new Integer[0]);
    }

    public static void buildMenu(Menu target, final DataObserver<FillPattern> dataObserver) {
        target.getItems().clear();
        for (final FillPattern fill : FillPattern.values()) {
            MenuItem i = new MenuItem(fill.name(), (Node)new ImageView((Image)fill.getPreview()));
            i.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    dataObserver.observedObjectChanged(fill);
                }
            });
            target.getItems().add((Object)i);
        }
    }

    private FillPattern(boolean hiBitMatters, int width, boolean hiBit, String ... pattern) {
        this.pattern = FillPattern.buildPattern(hiBit, pattern);
        this.width = width;
        this.hiBitMatters = hiBitMatters;
        this.bytePattern = this.getBytePattern();
    }

    public WritableImage getPreview() {
        if (this.preview == null) {
            this.preview = FillPattern.renderPreview(null, this.bytePattern);
        }
        return this.preview;
    }

    public int[] getBytePattern() {
        int[] out = new int[64];
        int pos = 0;
        int patternHeight = this.pattern.length / this.width;
        for (int y = 0; y < 16; ++y) {
            int yOffset = y % patternHeight * this.width;
            for (int x = 0; x < 4; ++x) {
                out[pos++] = this.pattern[yOffset + x % this.width];
            }
        }
        return out;
    }

    public static int[] interleave(int[] pat1, int[] pat2) {
        int[] out = Arrays.copyOf(pat1, pat1.length);
        for (int y = 1; y < 16; y += 2) {
            int offset = y * 4;
            for (int x = 0; x < 4; ++x) {
                out[offset + x] = pat2[offset + x];
            }
        }
        return out;
    }

    public static int[] fromTile(Tile t) {
        byte[] raw = TileUtils.getPlatformData(t, Platform.AppleII_DHGR);
        int[] out = new int[64];
        int pos = 0;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 4; ++x) {
                out[pos++] = raw[y * 4 + x] & 0xFF;
            }
        }
        return out;
    }

    public static WritableImage renderPreview(WritableImage img, int[] pattern) {
        byte[] b = new byte[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            b[i] = (byte)pattern[i];
        }
        return Platform.AppleII_DHGR.tileRenderer.redrawSprite(b, null, true);
    }
}

