/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple.dhgr;

import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import org.badvision.outlaweditor.apple.AppleNTSCGraphics;
import org.badvision.outlaweditor.apple.AppleTileRenderer;

public class AppleDHGRTileRenderer
extends AppleTileRenderer {
    @Override
    public WritableImage redrawSprite(byte[] spriteData, WritableImage img, boolean useBleedOver) {
        if (img == null) {
            img = new WritableImage(28, 32);
        }
        if (spriteData == null) {
            return img;
        }
        int[][] palette = useSolidPalette ? AppleNTSCGraphics.solidPalette : AppleNTSCGraphics.textPalette;
        for (int y = 0; y < 16; ++y) {
            int scan = spriteData[y * 4 + 3] & 0xFF;
            scan <<= 7;
            scan |= spriteData[y * 4 + 2] & 0xFF;
            scan <<= 7;
            scan |= spriteData[y * 4 + 1] & 0xFF;
            scan <<= 7;
            int last = (scan |= spriteData[y * 4] & 0xFF) >> 26 & 3;
            int keep = scan & 0xFF;
            scan <<= 2;
            if (useBleedOver) {
                scan |= last;
            }
            for (int x = 0; x < 14; ++x) {
                boolean isHiBit = (spriteData[y * 2 + x / 7] & 0x80) != 0;
                int col1 = palette[(x & 1) << 1][scan & 0x7F];
                Color color1 = Color.rgb((int)AppleNTSCGraphics.getRed(col1), (int)AppleNTSCGraphics.getGreen(col1), (int)AppleNTSCGraphics.getBlue(col1));
                scan >>= 1;
                if (x == 12) {
                    scan = scan & (isHiBit ? 127 : 31) | keep << 5;
                }
                int col2 = palette[((x & 1) << 1) + 1][scan & 0x7F];
                Color color2 = Color.rgb((int)AppleNTSCGraphics.getRed(col2), (int)AppleNTSCGraphics.getGreen(col2), (int)AppleNTSCGraphics.getBlue(col2));
                scan >>= 1;
                img.getPixelWriter().setColor(x * 2, y * 2, color1);
                img.getPixelWriter().setColor(x * 2, y * 2 + 1, color1);
                img.getPixelWriter().setColor(x * 2 + 1, y * 2, color2);
                img.getPixelWriter().setColor(x * 2 + 1, y * 2 + 1, color2);
            }
        }
        return img;
    }

    @Override
    public int getWidth() {
        return 28;
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

