/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple.dhgr;

import javafx.scene.Group;
import javafx.scene.control.Menu;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.badvision.outlaweditor.TileEditor;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.apple.dhgr.FillPattern;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Tile;

public class AppleDHGRTileEditor
extends TileEditor {
    FillPattern currentPattern = FillPattern.Magenta;
    TileEditor.DrawMode drawMode = TileEditor.DrawMode.Toggle;
    int lastActionX = -1;
    int lastActionY = -1;
    int zoom = 25;
    Group gridGroup;
    Rectangle[][] grid;

    @Override
    public void setEntity(Tile t) {
        super.setEntity(t);
        if (TileUtils.getPlatformData(t, Platform.AppleII_DHGR) == null) {
            TileUtils.setPlatformData(t, Platform.AppleII_DHGR, new byte[64]);
        }
    }

    @Override
    public void buildEditorUI(Pane tileEditorAnchorPane) {
        this.grid = new Rectangle[28][16];
        this.gridGroup = new Group();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 28; ++x) {
                int xx = x;
                int yy = y;
                Rectangle rect = new Rectangle((double)(this.zoom / 2 * x + 5), (double)(this.zoom * y + 5), (double)(this.zoom / 2 - 2), (double)(this.zoom - 2));
                rect.setOnMouseDragged(t -> this.performDragAction((int)(t.getX() / (double)(this.zoom / 2)), (int)(t.getY() / (double)this.zoom)));
                rect.setOnMousePressed(t -> {
                    this.handleMouse((MouseEvent)t, xx, yy);
                    this.lastActionX = -1;
                    this.lastActionY = -1;
                });
                this.grid[x][y] = rect;
                this.gridGroup.getChildren().add((Object)rect);
                rect.setStrokeWidth(2.0);
            }
        }
        Group mainGroup = new Group();
        Rectangle background = new Rectangle(0.0, 0.0, (double)(this.zoom * 14 + 10), (double)(this.zoom * 16 + 10));
        background.setFill((Paint)Color.BLACK);
        mainGroup.getChildren().add((Object)background);
        mainGroup.getChildren().add((Object)this.gridGroup);
        tileEditorAnchorPane.getChildren().add((Object)mainGroup);
        TileUtils.redrawTile((Tile)this.getEntity());
        this.observedObjectChanged((Tile)this.getEntity());
    }

    private void handleMouse(MouseEvent t, int x, int y) {
        t.consume();
        if (t.getButton() == null || t.getButton() == MouseButton.NONE) {
            return;
        }
        this.performAction(t.isShiftDown() || t.isSecondaryButtonDown(), x, y);
    }

    public void performDragAction(int x, int y) {
        this.performAction(false, x, y);
    }

    private void performAction(boolean alt, int x, int y) {
        y = Math.min(Math.max(y, 0), 15);
        if (this.lastActionX == (x = Math.min(Math.max(x, 0), 27)) && this.lastActionY == y) {
            return;
        }
        this.lastActionX = x;
        this.lastActionY = y;
        switch (this.drawMode) {
            case Toggle: {
                if (alt) {
                    this.toggleHiBit(x, y);
                    break;
                }
                this.toggle(x, y);
                break;
            }
            case Pencil1px: {
                int pat = this.currentPattern.getBytePattern()[y * 4 + x / 7];
                this.set((pat & 1 << x % 7) != 0, x, y);
                if (!this.currentPattern.hiBitMatters) break;
                this.setHiBit(pat >= 128, x, y);
                break;
            }
            case Pencil3px: {
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (xx < 0 || xx >= 28) continue;
                    int pat = this.currentPattern.getBytePattern()[y * 4 + xx / 7];
                    this.set((pat & 1 << xx % 7) != 0, xx, y);
                    if (!this.currentPattern.hiBitMatters) continue;
                    this.setHiBit(pat >= 128, xx, y);
                }
                break;
            }
        }
        this.observedObjectChanged((Tile)this.getEntity());
    }

    @Override
    public void observedObjectChanged(Tile tile) {
        this.recolorGrid(TileUtils.getPlatformData(tile, Platform.AppleII_DHGR), (Shape[][])this.grid, TileUtils.getImage(tile, Platform.AppleII_DHGR));
    }

    @Override
    public void showShiftUI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDrawMode(TileEditor.DrawMode drawMode) {
        this.drawMode = drawMode;
        this.lastActionX = -1;
        this.lastActionY = -1;
    }

    @Override
    public void buildPatternSelector(Menu tilePatternMenu) {
        FillPattern.buildMenu(tilePatternMenu, object -> this.changeCurrentPattern((FillPattern)((Object)object)));
    }

    public void changeCurrentPattern(FillPattern pat) {
        this.currentPattern = pat;
        this.lastActionX = -1;
        this.lastActionY = -1;
    }

    @Override
    public void unregister() {
    }

    public void toggleHiBit(int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR);
        int n = y * 4 + x / 7;
        data[n] = (byte)(data[n] ^ 0x80);
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR, data);
        this.redraw();
    }

    public void setHiBit(boolean on, int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR);
        if (on) {
            int n = y * 4 + x / 7;
            data[n] = (byte)(data[n] | 0x80);
        } else {
            int n = y * 4 + x / 7;
            data[n] = (byte)(data[n] & 0x7F);
        }
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR, data);
        this.redraw();
    }

    public void toggle(int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR);
        int n = y * 4 + x / 7;
        data[n] = (byte)(data[n] ^ 1 << x % 7);
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR, data);
        this.redraw();
    }

    public void set(boolean on, int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR);
        int n = y * 4 + x / 7;
        data[n] = (byte)(data[n] | 1 << x % 7);
        if (!on) {
            int n2 = y * 4 + x / 7;
            data[n2] = (byte)(data[n2] ^ 1 << x % 7);
        }
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII_DHGR, data);
        this.redraw();
    }

    public void recolorGrid(byte[] spriteData, Shape[][] grid, WritableImage img) {
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 28; ++x) {
                grid[x][y].setFill((Paint)img.getPixelReader().getColor(x, y * 2));
                if ((spriteData[y * 4 + x / 7] & 1 << x % 7) != 0) {
                    grid[x][y].setStroke((Paint)Color.ANTIQUEWHITE);
                    continue;
                }
                Color stroke = Color.ANTIQUEWHITE;
                switch (x % 4) {
                    case 0: {
                        stroke = Color.BROWN;
                        break;
                    }
                    case 1: {
                        stroke = Color.BLUE;
                        break;
                    }
                    case 2: {
                        stroke = Color.GREEN;
                        break;
                    }
                    case 3: {
                        stroke = Color.CHOCOLATE;
                    }
                }
                grid[x][y].setStroke((Paint)stroke);
            }
        }
    }

    @Override
    public void copy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paste() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void selectNone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void redraw() {
        if (this.getEntity() != null) {
            TileUtils.redrawTile((Tile)this.getEntity());
        }
    }
}

