/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple.dhgr;

import javafx.scene.image.WritableImage;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.apple.AppleImageRenderer;
import org.badvision.outlaweditor.data.TileMap;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Tile;

public class AppleDHGRImageRenderer
extends AppleImageRenderer {
    public static int BLACK = -16777216;
    public static int WHITE = -1;

    @Override
    public byte[] renderPreview(TileMap map, int startX, int startY, int width, int height) {
        byte[] buffer = this.createImageBuffer(width, height);
        int pos = 0;
        int numRows = height / 16;
        int numCols = width / 4;
        for (int y = 0; y < numRows; ++y) {
            for (int yy = 0; yy < 16; ++yy) {
                for (int x = 0; x < numCols; ++x) {
                    Tile t = map.get(x + startX, y + startY);
                    if (t == null) {
                        buffer[pos++] = 0;
                        buffer[pos++] = 0;
                        buffer[pos++] = 0;
                        buffer[pos++] = 0;
                        continue;
                    }
                    byte[] tileData = TileUtils.getPlatformData(t, Platform.AppleII_DHGR);
                    buffer[pos++] = tileData[yy * 2];
                    buffer[pos++] = tileData[yy * 2 + 1];
                    buffer[pos++] = tileData[yy * 2 + 2];
                    buffer[pos++] = tileData[yy * 2 + 3];
                }
            }
        }
        return buffer;
    }

    @Override
    public WritableImage renderImage(WritableImage img, byte[] rawImage, int width, int height) {
        if (img == null) {
            img = new WritableImage(width * 7, height * 2);
        }
        for (int y = 0; y < height; ++y) {
            this.renderScanline(img, y, width, rawImage);
        }
        return img;
    }

    @Override
    public WritableImage renderScanline(WritableImage img, int y, int width, byte[] rawImage) {
        if (y < 0) {
            return img;
        }
        int[] scanline = new int[width / 4];
        for (int x = 0; x < width; x += 4) {
            int scan = rawImage[y * width + x + 3] & 0xFF;
            scan <<= 7;
            scan |= rawImage[y * width + x + 2] & 0xFF;
            scan <<= 7;
            scan |= rawImage[y * width + x + 1] & 0xFF;
            scan <<= 7;
            scanline[x / 4] = scan |= rawImage[y * width + x] & 0xFF;
        }
        AppleDHGRImageRenderer.renderScanline(img.getPixelWriter(), y * 2, scanline, true, false, width, new boolean[0]);
        AppleDHGRImageRenderer.renderScanline(img.getPixelWriter(), y * 2 + 1, scanline, true, false, width, new boolean[0]);
        return img;
    }
}

