/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple.dhgr;

import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.input.MouseEvent;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.apple.AppleImageEditor;
import org.badvision.outlaweditor.apple.dhgr.FillPattern;
import org.badvision.outlaweditor.data.DataObserver;

public class AppleDHGRImageEditor
extends AppleImageEditor
implements EventHandler<MouseEvent> {
    public AppleDHGRImageEditor() {
        this.xScale = 1;
        this.yScale = 2;
        this.changeCurrentPattern(FillPattern.Magenta);
    }

    @Override
    public Platform getPlatform() {
        return Platform.AppleII_DHGR;
    }

    @Override
    public void buildPatternSelector(Menu tilePatternMenu) {
        FillPattern.buildMenu(tilePatternMenu, new DataObserver<FillPattern>(){

            @Override
            public void observedObjectChanged(FillPattern object) {
                AppleDHGRImageEditor.this.changeCurrentPattern(object);
            }
        });
    }

    public void changeCurrentPattern(FillPattern pattern) {
        this.currentFillPattern = pattern.getBytePattern();
        this.hiBitMatters = pattern.hiBitMatters;
        this.lastActionX = -1;
        this.lastActionY = -1;
    }

    @Override
    public void redrawScanline(int y) {
        this.currentImage = Platform.AppleII_DHGR.imageRenderer.renderScanline(this.currentImage, y, this.getWidth(), this.getImageData());
    }

    @Override
    public void rescale(int newWidth, int newHeight) {
    }

    @Override
    public void crop(int newWidth, int newHeight) {
    }
}

