/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple;

import java.util.ArrayList;
import java.util.List;

public abstract class Palette {
    public int MATCH_TOLERANCE = 64;
    List colors = new ArrayList();
    public static int COLOR_DISTANCE_MAX = 49744125;

    public Palette() {
        this.initPalette();
    }

    protected abstract void initPalette();

    public int[] getColor(int col) {
        return (int[])this.colors.get(col);
    }

    public int getColorInt(int c) {
        int[] col = this.getColor(c);
        return Palette.toRGBInt(col);
    }

    public void addColor(int[] col) {
        this.colors.add(col);
    }

    public void addColor(int r, int g, int b) {
        int[] col = new int[]{r, g, b};
        this.addColor(col);
    }

    public int findColor(int color) {
        int[] col = Palette.parseIntColor(color);
        return this.findColor(col);
    }

    public static int[] parseIntColor(int color) {
        return new int[]{Palette.getR(color), Palette.getG(color), Palette.getB(color)};
    }

    public static int toRGBInt(int[] col) {
        return 65536 * col[0] + 256 * col[1] + col[2];
    }

    public int findColor(int[] color) {
        double lastDiff = COLOR_DISTANCE_MAX;
        int bestFit = 0;
        for (int i = 0; i < this.colors.size(); ++i) {
            int[] test = (int[])this.colors.get(i);
            double diff = Palette.distance(color, test);
            if (!(diff < lastDiff)) continue;
            lastDiff = diff;
            bestFit = i;
        }
        return bestFit;
    }

    public static double distance(int[] c1, int[] c2) {
        double rmean = (double)(c1[0] + c2[1]) / 2.0;
        double r = c1[0] - c2[0];
        double g = c1[1] - c2[1];
        double b = c1[2] - c2[2];
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return Math.sqrt(weightR * (r * r) + weightG * (g * g) + weightB * (b * b)) / 1.73167;
    }

    public static double distance_linear(int[] color, int[] test) {
        return Math.sqrt(Math.pow(color[0] - test[0], 2.0) + Math.pow(color[1] - test[1], 2.0) + Math.pow(color[2] - test[2], 2.0));
    }

    public static int getR(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getB(int color) {
        return color & 0xFF;
    }

    public static int getComponent(int color, int component) {
        switch (component) {
            case 0: {
                return Palette.getR(color);
            }
            case 1: {
                return Palette.getG(color);
            }
            case 2: {
                return Palette.getB(color);
            }
        }
        return 0;
    }
}

