/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.apple.AppleImageRenderer;
import org.badvision.outlaweditor.apple.AppleNTSCGraphics;
import org.badvision.outlaweditor.apple.Palette;

public class ImageDitherEngine {
    int byteRenderWidth;
    int pixelRenderWidth;
    final int errorWindow = 6;
    final int overlap = 3;
    final int pixelShiftHgr = -1;
    final int pixelShiftDhgr = -2;
    WritableImage source;
    byte[] screen;
    Platform platform;
    int bufferWidth;
    int height;
    int divisor;
    public int[][] coefficients;
    int startX;
    int startY;
    int[][][] primaryScratchBuffer;
    int[][][] secondaryScratchBuffer;
    int[][][] tertriaryScratchBuffer;
    int[] scanline;
    List<Integer> pixels;
    public static int ALPHA_SOLID = -16777216;
    PixelWriter fakeWriter = new PixelWriter(){

        public PixelFormat getPixelFormat() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setArgb(int x, int y, int c) {
            ImageDitherEngine.this.pixels.add(c);
        }

        public void setColor(int i, int i1, Color color) {
        }

        public <T extends Buffer> void setPixels(int i, int i1, int i2, int i3, PixelFormat<T> pf, T t, int i4) {
        }

        public void setPixels(int i, int i1, int i2, int i3, PixelFormat<ByteBuffer> pf, byte[] bytes, int i4, int i5) {
        }

        public void setPixels(int i, int i1, int i2, int i3, PixelFormat<IntBuffer> pf, int[] ints, int i4, int i5) {
        }

        public void setPixels(int i, int i1, int i2, int i3, PixelReader reader, int i4, int i5) {
        }
    };

    public ImageDitherEngine(Platform platform) {
        this.platform = platform;
        this.byteRenderWidth = platform == Platform.AppleII_DHGR ? 7 : 14;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setSourceImage(Image img) {
        this.source = ImageDitherEngine.getScaledImage(img, this.pixelRenderWidth, this.height);
    }

    private static WritableImage getScaledImage(Image img, int width, int height) {
        Canvas c = new Canvas((double)width, (double)height);
        c.getGraphicsContext2D().drawImage(img, 0.0, 0.0, (double)width, (double)height);
        WritableImage newImg = new WritableImage(width, height);
        SnapshotParameters sp = new SnapshotParameters();
        c.snapshot(sp, newImg);
        return newImg;
    }

    public WritableImage getPreviewImage() {
        return this.platform.imageRenderer.renderImage(null, this.screen, this.bufferWidth, this.height);
    }

    public void setOutputDimensions(int width, int height) {
        this.bufferWidth = width;
        this.pixelRenderWidth = width * this.byteRenderWidth;
        this.height = height;
        this.screen = this.platform.imageRenderer.createImageBuffer(width, height);
    }

    public void setDivisor(int divisor) {
        this.divisor = divisor;
    }

    public void setCoefficients(int[][] coefficients) {
        this.coefficients = coefficients;
    }

    public void setTargetCoordinates(int x, int y) {
        this.startX = x;
        this.startY = y;
    }

    public byte[] dither(boolean propagateError) {
        this.primaryScratchBuffer = this.generateScratchBuffer(this.source.getPixelReader(), this.pixelRenderWidth, this.height);
        this.secondaryScratchBuffer = this.generateScratchBuffer(this.source.getPixelReader(), this.pixelRenderWidth, this.height);
        this.tertriaryScratchBuffer = this.generateScratchBuffer(this.source.getPixelReader(), this.pixelRenderWidth, this.height);
        for (int i = 0; i < this.screen.length; ++i) {
            this.screen[i] = 0;
        }
        this.scanline = new int[3];
        this.pixels = new ArrayList<Integer>();
        for (int y = 0; y < this.height; ++y) {
            block6: for (int x = 0; x < this.bufferWidth; x += 2) {
                switch (this.platform) {
                    case AppleII: {
                        this.hiresDither(y, x, propagateError);
                        continue block6;
                    }
                    case AppleII_DHGR: {
                        this.doubleHiresDither(y, x, propagateError);
                    }
                }
            }
        }
        return this.screen;
    }

    void hiresDither(int y, int x, boolean propagateError) {
        int[] col2;
        int[] col1;
        int on2;
        int on1;
        double errorOn;
        int off2;
        int off1;
        double errorOff;
        int i;
        int off;
        int on;
        int xx;
        int c;
        long totalError;
        int hi;
        int bb1 = this.screen[(y + this.startY) * this.bufferWidth + this.startX + x] & 0xFF;
        int bb2 = this.screen[(y + this.startY) * this.bufferWidth + this.startX + x + 1] & 0xFF;
        int next = bb2 & 0x7F;
        int prev = 0;
        if (x + this.startX > 0) {
            prev = this.screen[(y + this.startY) * this.bufferWidth + this.startX + x - 1] & 0xFF;
        }
        if (x + this.startX < this.bufferWidth - 2) {
            next = this.screen[(y + this.startY) * this.bufferWidth + this.startX + x + 2] & 0xFF;
        }
        long leastError = Long.MAX_VALUE;
        for (hi = 0; hi < 2; ++hi) {
            this.copyBuffer(this.primaryScratchBuffer, this.tertriaryScratchBuffer, y, y + 3);
            int b1 = hi << 7;
            totalError = 0L;
            for (c = 0; c < 7; ++c) {
                xx = x * 14 + c * 2;
                on = b1 | 1 << c;
                off = on ^ 1 << c;
                this.scanline[0] = i = AppleNTSCGraphics.hgrToDhgr[0][prev];
                this.scanline[1] = i = AppleNTSCGraphics.hgrToDhgr[(i & 0x10000000) >> 20 | off][bb2];
                errorOff = this.getError(xx - 3, y, 28 + c * 2 - 3 + -1, 6, this.tertriaryScratchBuffer, this.scanline);
                off1 = this.pixels.get(c * 2 + 28 + -1);
                off2 = this.pixels.get(c * 2 + 29 + -1);
                this.scanline[0] = i = AppleNTSCGraphics.hgrToDhgr[0][prev];
                this.scanline[1] = i = AppleNTSCGraphics.hgrToDhgr[(i & 0x10000000) >> 20 | on][bb2];
                errorOn = this.getError(xx - 3, y, 28 + c * 2 - 3 + -1, 6, this.tertriaryScratchBuffer, this.scanline);
                on1 = this.pixels.get(c * 2 + 28 + -1);
                on2 = this.pixels.get(c * 2 + 29 + -1);
                if (errorOff < errorOn) {
                    totalError = (long)((double)totalError + errorOff);
                    b1 = off;
                    col1 = Palette.parseIntColor(off1);
                    col2 = Palette.parseIntColor(off2);
                } else {
                    totalError = (long)((double)totalError + errorOn);
                    b1 = on;
                    col1 = Palette.parseIntColor(on1);
                    col2 = Palette.parseIntColor(on2);
                }
                if (!propagateError) continue;
                this.propagateError(xx + -1, y, this.tertriaryScratchBuffer, col1);
                this.propagateError(xx + 1 + -1, y, this.tertriaryScratchBuffer, col2);
            }
            if (totalError >= leastError) continue;
            this.copyBuffer(this.tertriaryScratchBuffer, this.secondaryScratchBuffer, y, y + 3);
            leastError = totalError;
            bb1 = b1;
        }
        this.copyBuffer(this.secondaryScratchBuffer, this.primaryScratchBuffer, y, y + 3);
        leastError = Long.MAX_VALUE;
        for (hi = 0; hi < 2; ++hi) {
            this.copyBuffer(this.primaryScratchBuffer, this.tertriaryScratchBuffer, y, y + 3);
            int b2 = hi << 7;
            totalError = 0L;
            for (c = 0; c < 7; ++c) {
                xx = x * 14 + c * 2 + 14;
                on = b2 | 1 << c;
                off = on ^ 1 << c;
                this.scanline[0] = i = AppleNTSCGraphics.hgrToDhgr[bb1][off];
                this.scanline[1] = AppleNTSCGraphics.hgrToDhgr[(i & 0x10000000) >> 20 | next][0];
                errorOff = this.getError(xx - 3, y, 14 + c * 2 - 3 + -1, 6, this.tertriaryScratchBuffer, this.scanline);
                off1 = this.pixels.get(c * 2 + 14 + -1);
                off2 = this.pixels.get(c * 2 + 15 + -1);
                this.scanline[0] = i = AppleNTSCGraphics.hgrToDhgr[bb1][on];
                this.scanline[1] = AppleNTSCGraphics.hgrToDhgr[(i & 0x10000000) >> 20 | next][0];
                errorOn = this.getError(xx - 3, y, 14 + c * 2 - 3 + -1, 6, this.tertriaryScratchBuffer, this.scanline);
                on1 = this.pixels.get(c * 2 + 14 + -1);
                on2 = this.pixels.get(c * 2 + 15 + -1);
                if (errorOff < errorOn) {
                    totalError = (long)((double)totalError + errorOff);
                    b2 = off;
                    col1 = Palette.parseIntColor(off1);
                    col2 = Palette.parseIntColor(off2);
                } else {
                    totalError = (long)((double)totalError + errorOn);
                    b2 = on;
                    col1 = Palette.parseIntColor(on1);
                    col2 = Palette.parseIntColor(on2);
                }
                if (!propagateError) continue;
                this.propagateError(xx + -1, y, this.tertriaryScratchBuffer, col1);
                this.propagateError(xx + 1 + -1, y, this.tertriaryScratchBuffer, col2);
            }
            if (totalError >= leastError) continue;
            this.copyBuffer(this.tertriaryScratchBuffer, this.secondaryScratchBuffer, y, y + 3);
            leastError = totalError;
            bb2 = b2;
        }
        this.copyBuffer(this.secondaryScratchBuffer, this.primaryScratchBuffer, y, y + 3);
        this.screen[(y + this.startY) * this.bufferWidth + this.startX + x] = (byte)bb1;
        this.screen[(y + this.startY) * this.bufferWidth + this.startX + x + 1] = (byte)bb2;
    }

    void doubleHiresDither(int y, int x, boolean propagateError) {
        if (x % 4 != 0) {
            return;
        }
        this.scanline[0] = 0;
        if (x >= 4) {
            this.scanline[0] = this.screen[y * this.bufferWidth + x - 1] << 21;
        }
        this.scanline[1] = 0;
        this.scanline[2] = 0;
        if (x + 4 < this.bufferWidth) {
            this.scanline[2] = this.screen[y * this.bufferWidth + x + 4];
        }
        int[] bytes = new int[]{this.screen[y * this.bufferWidth + x] & 0xFF, this.screen[y * this.bufferWidth + x + 1] & 0xFF, this.screen[y * this.bufferWidth + x + 2] & 0xFF, this.screen[y * this.bufferWidth + x + 3] & 0xFF};
        for (int byteOffset = 0; byteOffset < 4; ++byteOffset) {
            int b1 = bytes[byteOffset] & 0x7F;
            for (int bit = 0; bit < 7; ++bit) {
                int[] col1;
                int on = b1 | 1 << bit;
                int off = on ^ 1 << bit;
                int i = byteOffset == 3 ? off : bytes[3] & 0xFF;
                i <<= 7;
                i |= byteOffset == 2 ? off : bytes[2] & 0xFF;
                i <<= 7;
                i |= byteOffset == 1 ? off : bytes[1] & 0xFF;
                i <<= 7;
                this.scanline[1] = i |= byteOffset == 0 ? off : bytes[0] & 0xFF;
                double errorOff = this.getError((x + byteOffset) * 7 - 3 + bit, y, 28 + byteOffset * 7 + bit - 3 + -2, 6, this.primaryScratchBuffer, this.scanline);
                int offColor = this.pixels.get(byteOffset * 7 + bit + 28 + -2);
                i = byteOffset == 3 ? on : bytes[3] & 0xFF;
                i <<= 7;
                i |= byteOffset == 2 ? on : bytes[2] & 0xFF;
                i <<= 7;
                i |= byteOffset == 1 ? on : bytes[1] & 0xFF;
                i <<= 7;
                this.scanline[1] = i |= byteOffset == 0 ? on : bytes[0] & 0xFF;
                double errorOn = this.getError((x + byteOffset) * 7 - 3 + bit, y, 28 + byteOffset * 7 + bit - 3 + -2, 6, this.primaryScratchBuffer, this.scanline);
                int onColor = this.pixels.get(byteOffset * 7 + bit + 28 + -2);
                if (errorOff < errorOn) {
                    b1 = off;
                    col1 = Palette.parseIntColor(offColor);
                } else {
                    b1 = on;
                    col1 = Palette.parseIntColor(onColor);
                }
                if (!propagateError) continue;
                this.propagateError((x + byteOffset) * 7 + bit, y, this.primaryScratchBuffer, col1);
            }
            bytes[byteOffset] = b1;
            this.screen[(y + this.startY) * this.bufferWidth + this.startX + x] = (byte)bytes[0];
            this.screen[(y + this.startY) * this.bufferWidth + this.startX + x + 1] = (byte)bytes[1];
            this.screen[(y + this.startY) * this.bufferWidth + this.startX + x + 2] = (byte)bytes[2];
            this.screen[(y + this.startY) * this.bufferWidth + this.startX + x + 3] = (byte)bytes[3];
        }
    }

    private void propagateError(int x, int y, int[][][] scratchBuffer, int[] newColor) {
        if (x < 0 || y < 0) {
            return;
        }
        int[] pixel = scratchBuffer[y][x];
        for (int i = 0; i < 3; ++i) {
            double error = pixel[i] - newColor[i];
            for (int yy = 0; yy < 3 && y + yy < scratchBuffer.length; ++yy) {
                for (int xx = -2; xx < 3 && x + xx < scratchBuffer[y].length; ++xx) {
                    if (x + xx < 0 || this.coefficients[xx + 2][yy] == 0) continue;
                    int errorAmount = (int)(error * (double)this.coefficients[xx + 2][yy] / (double)this.divisor);
                    int[] nArray = scratchBuffer[y + yy][x + xx];
                    int n = i;
                    nArray[n] = nArray[n] + errorAmount;
                }
            }
        }
    }

    private double getError(int imageXStart, int y, int scanlineXStart, int window, int[][][] source, int[] scanline) {
        this.pixels.clear();
        AppleImageRenderer.renderScanline(this.fakeWriter, 0, scanline, true, false, 20, new boolean[0]);
        double total = 0.0;
        for (int p = 0; p < window; ++p) {
            if (imageXStart + p < 0 || imageXStart + p >= this.pixelRenderWidth || scanlineXStart + p < 0) continue;
            int[] c1 = Palette.parseIntColor(this.pixels.get(scanlineXStart + p));
            int[] c2 = source[y][imageXStart + p];
            double dist = Palette.distance(c1, c2);
            total += dist;
        }
        return (int)total;
    }

    private int[][][] generateScratchBuffer(PixelReader pixelReader, int pixelRenderWidth, int height) {
        int[][][] out = new int[height][pixelRenderWidth][3];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < pixelRenderWidth; ++x) {
                int pixel = pixelReader.getArgb(x, y);
                out[y][x] = Palette.parseIntColor(pixel);
            }
        }
        return out;
    }

    private void copyBuffer(int[][][] source, int[][][] target, int start, int end) {
        for (int y = start; y < end && y < source.length; ++y) {
            int width = source[y].length;
            for (int x = 0; x < width; ++x) {
                System.arraycopy(source[y][x], 0, target[y][x], 0, 3);
            }
        }
    }
}

