/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple;

import java.util.HashMap;
import javafx.scene.Group;
import javafx.scene.control.Menu;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.badvision.outlaweditor.TileEditor;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.apple.FillPattern;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Tile;

public class AppleTileEditor
extends TileEditor {
    FillPattern currentPattern = FillPattern.DarkViolet1;
    TileEditor.DrawMode drawMode = TileEditor.DrawMode.Toggle;
    public static final long SAFE_WAIT_TIME = 100L;
    int lastActionX = -1;
    int lastActionY = -1;
    long debounceTime = 0L;
    int zoom = 25;
    Group gridGroup;
    Rectangle[][] grid;

    @Override
    public void setEntity(Tile t) {
        super.setEntity(t);
        if (TileUtils.getPlatformData(t, Platform.AppleII) == null) {
            TileUtils.setPlatformData(t, Platform.AppleII, new byte[32]);
        }
    }

    @Override
    public void buildEditorUI(Pane tileEditorAnchorPane) {
        this.grid = new Rectangle[14][16];
        this.gridGroup = new Group();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 14; ++x) {
                int xx = x;
                int yy = y;
                Rectangle rect = new Rectangle((double)(this.zoom * x + 5), (double)(this.zoom * y + 5), (double)(this.zoom - 2), (double)(this.zoom - 2));
                rect.setOnMouseDragged(t -> this.performDragAction((int)(t.getX() / (double)this.zoom), (int)(t.getY() / (double)this.zoom)));
                rect.setOnMousePressed(t -> this.handleMouse((MouseEvent)t, xx, yy));
                this.grid[x][y] = rect;
                this.gridGroup.getChildren().add((Object)rect);
                rect.setStrokeWidth(2.0);
            }
        }
        Group mainGroup = new Group();
        Rectangle background = new Rectangle(0.0, 0.0, (double)(this.zoom * 14 + 10), (double)(this.zoom * 16 + 10));
        background.setFill((Paint)Color.BLACK);
        mainGroup.getChildren().add((Object)background);
        mainGroup.getChildren().add((Object)this.gridGroup);
        tileEditorAnchorPane.getChildren().add((Object)mainGroup);
        TileUtils.redrawTile((Tile)this.getEntity());
        this.observedObjectChanged((Tile)this.getEntity());
    }

    private void handleMouse(MouseEvent t, int x, int y) {
        t.consume();
        if (t.getButton() == null || t.getButton() == MouseButton.NONE) {
            return;
        }
        this.performAction(t.isShiftDown() || t.isSecondaryButtonDown(), x, y);
    }

    public void performDragAction(int x, int y) {
        this.performAction(false, x, y);
    }

    private void performAction(boolean alt, int x, int y) {
        y = Math.min(Math.max(y, 0), 15);
        if (this.lastActionX == (x = Math.min(Math.max(x, 0), 13)) && this.lastActionY == y && this.debounceTime > System.currentTimeMillis()) {
            return;
        }
        this.debounceTime = System.currentTimeMillis() + 100L;
        this.lastActionX = x;
        this.lastActionY = y;
        this.trackState();
        switch (this.drawMode) {
            case Toggle: {
                if (alt) {
                    this.toggleHiBit(x, y);
                    break;
                }
                this.toggle(x, y);
                break;
            }
            case Pencil1px: {
                int pat = this.currentPattern.getBytePattern()[y * 4 + x / 7];
                this.set((pat & 1 << x % 7) != 0, x, y);
                if (!this.currentPattern.hiBitMatters) break;
                this.setHiBit(pat >= 128, x, y);
                break;
            }
            case Pencil3px: {
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (xx < 0 || xx >= 14) continue;
                    int pat = this.currentPattern.getBytePattern()[y * 4 + xx / 7];
                    this.set((pat & 1 << xx % 7) != 0, xx, y);
                    if (!this.currentPattern.hiBitMatters) continue;
                    this.setHiBit(pat >= 128, xx, y);
                }
                break;
            }
        }
        this.observedObjectChanged((Tile)this.getEntity());
    }

    @Override
    public void observedObjectChanged(Tile tile) {
        this.recolorGrid(TileUtils.getPlatformData(tile, Platform.AppleII), (Shape[][])this.grid, TileUtils.getImage(tile, Platform.AppleII));
    }

    @Override
    public void showShiftUI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDrawMode(TileEditor.DrawMode drawMode) {
        this.drawMode = drawMode;
        this.lastActionX = -1;
        this.lastActionY = -1;
    }

    @Override
    public void buildPatternSelector(Menu tilePatternMenu) {
        FillPattern.buildMenu(tilePatternMenu, object -> this.changeCurrentPattern((FillPattern)((Object)object)));
    }

    public void changeCurrentPattern(FillPattern pat) {
        this.currentPattern = pat;
        this.lastActionX = -1;
        this.lastActionY = -1;
    }

    @Override
    public void unregister() {
    }

    public void toggleHiBit(int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII);
        int n = y * 2 + x / 7;
        data[n] = (byte)(data[n] ^ 0x80);
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII, data);
        this.redraw();
    }

    public void setHiBit(boolean on, int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII);
        if (on) {
            int n = y * 2 + x / 7;
            data[n] = (byte)(data[n] | 0x80);
        } else {
            int n = y * 2 + x / 7;
            data[n] = (byte)(data[n] & 0x7F);
        }
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII, data);
        this.redraw();
    }

    public void toggle(int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII);
        int n = y * 2 + x / 7;
        data[n] = (byte)(data[n] ^ 1 << x % 7);
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII, data);
        this.redraw();
    }

    public void set(boolean on, int x, int y) {
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII);
        int n = y * 2 + x / 7;
        data[n] = (byte)(data[n] | 1 << x % 7);
        if (!on) {
            int n2 = y * 2 + x / 7;
            data[n2] = (byte)(data[n2] ^ 1 << x % 7);
        }
        TileUtils.setPlatformData((Tile)this.getEntity(), Platform.AppleII, data);
        this.redraw();
    }

    public void recolorGrid(byte[] spriteData, Shape[][] grid, WritableImage img) {
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 14; ++x) {
                boolean isHiBit = (spriteData[y * 2 + x / 7] & 0x80) != 0;
                grid[x][y].setFill((Paint)img.getPixelReader().getColor(x * 2 + (isHiBit ? 1 : 0), y * 2));
                if ((spriteData[y * 2 + x / 7] & 1 << x % 7) != 0) {
                    grid[x][y].setStroke((Paint)Color.ANTIQUEWHITE);
                    continue;
                }
                grid[x][y].setStroke((Paint)(isHiBit ? (x % 2 == 1 ? Color.CHOCOLATE : Color.CORNFLOWERBLUE) : (x % 2 == 1 ? Color.GREEN : Color.VIOLET)));
            }
        }
    }

    @Override
    public void copy() {
        HashMap<DataFormat, Object> clip = new HashMap<DataFormat, Object>();
        clip.put(DataFormat.IMAGE, TileUtils.getImage((Tile)this.getEntity(), Platform.AppleII));
        clip.put(DataFormat.PLAIN_TEXT, DataUtilities.hexDump(TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII)));
        clip.put(DataFormat.HTML, this.buildHtmlExport());
        Clipboard.getSystemClipboard().setContent(clip);
    }

    @Override
    public void paste() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void selectNone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void redraw() {
        if (this.getEntity() != null) {
            TileUtils.redrawTile((Tile)this.getEntity());
        }
    }

    private String buildHtmlExport() {
        StringBuilder export = new StringBuilder("<table>");
        export.append("<tr><th>H</th><th>0</th><th>1</th><th>2</th><th>3</th><th>4</th><th>5</th><th>6</th>").append("<th>H</th><th>0</th><th>1</th><th>2</th><th>3</th><th>4</th><th>5</th><th>6</th>").append("<th>B1</th><th>B2</th></tr>");
        byte[] data = TileUtils.getPlatformData((Tile)this.getEntity(), Platform.AppleII);
        for (int row = 0; row < 16; ++row) {
            export.append("<tr>");
            for (int col = 0; col < 2; ++col) {
                int b = data[row * 2 + col] & 0xFF;
                export.append("<td>").append(b >> 7).append("</td>");
                for (int bit = 0; bit < 7; ++bit) {
                    export.append("<td style='background:#").append(this.getHexColor((Color)this.grid[bit + col * 7][row].getFill())).append("'>").append(b & 1).append("</td>");
                    b >>= 1;
                }
            }
            export.append("<td>").append(DataUtilities.getHexValueFromByte(data[row * 2])).append("</td><td>").append(DataUtilities.getHexValueFromByte(data[row * 2 + 1])).append("</td>");
            export.append("</tr>");
        }
        export.append("</table>");
        return export.toString();
    }

    private String getHexColor(Color color) {
        return DataUtilities.getHexValue((int)(color.getRed() * 255.0)) + DataUtilities.getHexValue((int)(color.getGreen() * 255.0)) + DataUtilities.getHexValue((int)(color.getBlue() * 255.0));
    }
}

