/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple;

public class AppleNTSCGraphics {
    public static final double MAX_I = 0.5957;
    public static final double MAX_Q = 0.5226;
    public static final double MAX_Y = 1.0;
    public static final double MIN_Y = 0.0;
    public static int[][] hgrToDhgr;
    public static int[][] textPalette;
    public static int[][] hgrToDhgrBW;
    public static int[][] solidPalette;

    public static int byteDoubler(byte b) {
        int num = (b & 0x40) << 6 | (b & 0x20) << 5 | (b & 0x10) << 4 | (b & 8) << 3 | (b & 4) << 2 | (b & 2) << 1 | b & 1;
        return num | num << 1;
    }

    public static double normalize(double x, double minX, double maxX) {
        if (x < minX) {
            return minX;
        }
        if (x > maxX) {
            return maxX;
        }
        return x;
    }

    public static int yiqToRgb(double y, double i, double q) {
        int r = (int)(AppleNTSCGraphics.normalize(y + 0.956 * i + 0.621 * q, 0.0, 1.0) * 255.0);
        int g = (int)(AppleNTSCGraphics.normalize(y - 0.272 * i - 0.647 * q, 0.0, 1.0) * 255.0);
        int b = (int)(AppleNTSCGraphics.normalize(y - 1.105 * i + 1.702 * q, 0.0, 1.0) * 255.0);
        return r << 16 | g << 8 | b;
    }

    public static int getRed(int col) {
        return col >> 16 & 0xFF;
    }

    public static int getGreen(int col) {
        return col >> 8 & 0xFF;
    }

    public static int getBlue(int col) {
        return col & 0xFF;
    }

    public static void initPalettes() {
        double[][] yiq = new double[][]{{0.0, 0.0, 0.0}, {0.25, 0.5, 0.5}, {0.25, -0.5, 0.5}, {0.5, 0.0, 1.0}, {0.25, -0.5, -0.5}, {0.5, 0.0, 0.0}, {0.5, -1.0, 0.0}, {0.75, -0.5, 0.5}, {0.25, 0.5, -0.5}, {0.5, 1.0, 0.0}, {0.5, 0.0, 0.0}, {0.75, 0.5, 0.5}, {0.5, 0.0, -1.0}, {0.75, 0.5, -0.5}, {0.75, -0.5, -0.5}, {1.0, 0.0, 0.0}};
        int maxLevel = 10;
        for (int offset = 0; offset < 4; ++offset) {
            for (int pattern = 0; pattern < 128; ++pattern) {
                int level = (pattern & 1) + (pattern >> 1 & 1) * 1 + (pattern >> 2 & 1) * 2 + (pattern >> 3 & 1) * 4 + (pattern >> 4 & 1) * 2 + (pattern >> 5 & 1) * 1;
                int col = pattern >> 2 & 0xF;
                for (int rot = 0; rot < offset; ++rot) {
                    col = (col & 8) >> 3 | col << 1 & 0xF;
                }
                double y1 = yiq[col][0];
                double y2 = (double)level / (double)maxLevel;
                AppleNTSCGraphics.solidPalette[offset][pattern] = 0xFF000000 | AppleNTSCGraphics.yiqToRgb(y1, yiq[col][1] * 0.5957, yiq[col][2] * 0.5226);
                AppleNTSCGraphics.textPalette[offset][pattern] = 0xFF000000 | AppleNTSCGraphics.yiqToRgb(y2, yiq[col][1] * 0.5957, yiq[col][2] * 0.5226);
            }
        }
        hgrToDhgr = new int[512][256];
        hgrToDhgrBW = new int[256][256];
        for (int bb1 = 0; bb1 < 512; ++bb1) {
            for (int bb2 = 0; bb2 < 256; ++bb2) {
                int value = (bb1 & 0x181) >= 257 ? 1 : 0;
                int b1 = AppleNTSCGraphics.byteDoubler((byte)(bb1 & 0x7F));
                if ((bb1 & 0x80) != 0) {
                    b1 <<= 1;
                }
                int b2 = AppleNTSCGraphics.byteDoubler((byte)(bb2 & 0x7F));
                if ((bb2 & 0x80) != 0) {
                    b2 <<= 1;
                }
                if ((bb1 & 0x40) == 64 && (bb2 & 1) != 0) {
                    b2 |= 1;
                }
                value |= b1 | b2 << 14;
                if ((bb2 & 0x40) != 0) {
                    value |= 0x10000000;
                }
                AppleNTSCGraphics.hgrToDhgr[bb1][bb2] = value;
                AppleNTSCGraphics.hgrToDhgrBW[bb1 & 0xFF][bb2] = AppleNTSCGraphics.byteDoubler((byte)bb1) | AppleNTSCGraphics.byteDoubler((byte)bb2) << 14;
            }
        }
    }

    static {
        textPalette = new int[4][128];
        solidPalette = new int[4][128];
        AppleNTSCGraphics.initPalettes();
    }
}

