/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor.apple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.badvision.outlaweditor.FileUtils;
import org.badvision.outlaweditor.ImageEditor;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.apple.FillPattern;
import org.badvision.outlaweditor.apple.ImageDitherEngine;
import org.badvision.outlaweditor.data.TileMap;
import org.badvision.outlaweditor.data.xml.PlatformData;
import org.badvision.outlaweditor.ui.UIAction;

public class AppleImageEditor
extends ImageEditor
implements EventHandler<MouseEvent> {
    public int[] currentFillPattern;
    public boolean hiBitMatters;
    protected ImageEditor.DrawMode currentDrawMode;
    protected WritableImage currentImage;
    protected Pane anchorPane;
    protected ImageView screen;
    protected int posX;
    protected int posY;
    protected double zoom;
    protected int xScale;
    protected int yScale;
    EnumMap<StateVars, Object> state;
    PlatformData data;
    protected int lastActionX;
    protected int lastActionY;
    protected long debounce;
    public static long DEBOUNCE_THRESHOLD = 50L;
    public boolean selectionFinished;
    public static Rectangle selectRect = null;
    public int selectStartX;
    public int selectStartY;
    public int selectEndX;
    public int selectEndY;
    byte[] copyData;

    public AppleImageEditor() {
        this.currentFillPattern = FillPattern.White_PC.bytePattern;
        this.hiBitMatters = true;
        this.currentDrawMode = ImageEditor.DrawMode.Pencil1px;
        this.posX = 0;
        this.posY = 0;
        this.zoom = 1.0;
        this.xScale = 2;
        this.yScale = 2;
        this.state = new EnumMap(StateVars.class);
        this.data = null;
        this.lastActionX = -1;
        this.lastActionY = -1;
        this.debounce = -1L;
        this.selectionFinished = false;
        this.selectStartX = -1;
        this.selectStartY = -1;
        this.selectEndX = -1;
        this.selectEndY = -1;
        this.copyData = null;
    }

    public Platform getPlatform() {
        return Platform.AppleII;
    }

    @Override
    protected void onEntityUpdated() {
        super.onEntityUpdated();
        this.data = null;
    }

    @Override
    public void buildEditorUI(Pane editorAnchorPane) {
        this.anchorPane = editorAnchorPane;
        this.redraw();
        this.screen = new ImageView((Image)this.currentImage);
        this.anchorPane.getChildren().add(0, (Object)this.screen);
        this.screen.setOnMouseMoved((EventHandler)this);
        this.screen.setOnMousePressed((EventHandler)this);
        this.screen.setOnMouseClicked((EventHandler)this);
        this.screen.setOnMouseReleased((EventHandler)this);
        this.screen.setOnMouseDragged((EventHandler)this);
        this.screen.setOnMouseDragReleased((EventHandler)this);
    }

    @Override
    public void buildPatternSelector(Menu tilePatternMenu) {
        FillPattern.buildMenu(tilePatternMenu, object -> {
            this.changeCurrentPattern((FillPattern)((Object)object));
            this.state.put(StateVars.PATTERN, object);
        });
    }

    public void changeCurrentPattern(FillPattern pattern) {
        if (pattern == null) {
            return;
        }
        this.currentFillPattern = pattern.getBytePattern();
        this.hiBitMatters = pattern.hiBitMatters;
        this.lastActionX = -1;
        this.lastActionY = -1;
    }

    @Override
    public EnumMap getState() {
        return this.state;
    }

    @Override
    public void setState(EnumMap oldState) {
        this.state.putAll(oldState);
        this.changeCurrentPattern((FillPattern)((Object)this.state.get((Object)StateVars.PATTERN)));
        ImageEditor.DrawMode oldDrawMode = (ImageEditor.DrawMode)((Object)this.state.get((Object)StateVars.DRAW_MODE));
        if (oldDrawMode != null) {
            this._setDrawMode(oldDrawMode);
        } else {
            this.state.put(StateVars.DRAW_MODE, (Object)this.currentDrawMode);
        }
    }

    @Override
    public void setDrawMode(ImageEditor.DrawMode drawMode) {
        this._setDrawMode(drawMode);
        this.state.put(StateVars.DRAW_MODE, (Object)drawMode);
    }

    private void _setDrawMode(ImageEditor.DrawMode drawMode) {
        this.currentDrawMode = drawMode;
        this.lastActionX = -1;
        this.lastActionY = -1;
        this.selectionFinished = false;
        if (drawMode != ImageEditor.DrawMode.Stamp) {
            this.selectNone();
        }
    }

    @Override
    public void showShiftUI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void unregister() {
        this.anchorPane.getChildren().remove((Object)this.screen);
    }

    @Override
    public void observedObjectChanged(org.badvision.outlaweditor.data.xml.Image object) {
        this.redraw();
    }

    public void redrawScanline(int y) {
        this.currentImage = this.getPlatform().imageRenderer.renderScanline(this.currentImage, y, this.getWidth(), this.getImageData());
    }

    @Override
    public void redraw() {
        System.out.println("Redraw " + this.getPlatform().name());
        this.currentImage = this.getPlatform().imageRenderer.renderImage(this.currentImage, this.getImageData(), this.getWidth(), this.getHeight());
    }

    public PlatformData getPlatformData() {
        if (this.data == null) {
            this.data = this.getPlatformData(this.getPlatform());
            if (this.data == null) {
                this.createNewPlatformData(this.getPlatform().maxImageWidth, this.getPlatform().maxImageHeight);
                this.data = this.getPlatformData(this.getPlatform());
            }
        }
        return this.data;
    }

    public byte[] getImageData() {
        return this.getPlatformData().getValue();
    }

    public void setData(byte[] data) {
        this.getPlatformData().setValue(data);
    }

    public void setDataAndRedraw(byte[] data) {
        this.setData(data);
        this.redraw();
    }

    @Override
    public void togglePanZoom() {
        this.anchorPane.getChildren().stream().filter(n -> n != this.screen).forEach(n -> n.setVisible(!n.isVisible()));
    }

    @Override
    public void zoomOut() {
        if (this.zoom <= 1.0) {
            this.zoom(-0.1);
        } else {
            this.zoom(-0.25);
        }
    }

    @Override
    public void zoomIn() {
        if (this.zoom >= 1.0) {
            this.zoom(0.25);
        } else {
            this.zoom(0.1);
        }
    }

    @Override
    public double getZoomScale() {
        return this.zoom;
    }

    private void zoom(double delta) {
        this.zoom += delta;
        this.zoom = Math.min(Math.max(0.15, this.zoom), 4.0);
    }

    public void handle(MouseEvent t) {
        int x = (int)t.getX() / this.xScale;
        int y = (int)t.getY() / this.yScale;
        this.cursorInfoProperty().set((Object)("X=" + x + "(" + x / 7 + "," + x % 7 + ") Y=" + y));
        if (t.getEventType().equals(MouseEvent.MOUSE_MOVED)) {
            return;
        }
        if (this.performAction(t.isShiftDown() || t.isSecondaryButtonDown(), t.getEventType().equals(MouseEvent.MOUSE_RELEASED), x, y)) {
            t.consume();
        }
    }

    public boolean performAction(boolean alt, boolean released, int x, int y) {
        if (this.debounce != -1L) {
            long ellapsed = System.currentTimeMillis() - this.debounce;
            if (ellapsed <= DEBOUNCE_THRESHOLD) {
                return false;
            }
            this.debounce = -1L;
        }
        y = Math.min(Math.max(y, 0), this.getHeight() - 1);
        x = Math.min(Math.max(x, 0), this.getWidth() * 7 - 1);
        boolean canSkip = false;
        if (this.lastActionX == x && this.lastActionY == y) {
            canSkip = true;
        }
        this.lastActionX = x;
        this.lastActionY = y;
        switch (this.currentDrawMode) {
            case Toggle: {
                if (canSkip) {
                    return false;
                }
                this.trackState();
                if (alt) {
                    this.toggleHiBit(x, y);
                } else {
                    this.toggle(x, y);
                }
                this.redrawScanline(y);
                break;
            }
            case Pencil1px: {
                if (canSkip) {
                    return false;
                }
                this.trackState();
                this.plot(x, y, this.currentFillPattern, this.hiBitMatters);
                this.redrawScanline(y);
                break;
            }
            case Pencil3px: {
                if (canSkip) {
                    return false;
                }
                this.trackState();
                this.drawBrush(x, y, 3, this.currentFillPattern, this.hiBitMatters);
                break;
            }
            case Pencil5px: {
                if (canSkip) {
                    return false;
                }
                this.trackState();
                this.drawBrush(x, y, 5, this.currentFillPattern, this.hiBitMatters);
                break;
            }
            case Rectangle: {
                this.debounce = System.currentTimeMillis() - 10L;
                if (released) {
                    this.trackState();
                    this.fillSelection(x, y);
                    this.redraw();
                    this.debounce = System.currentTimeMillis();
                    return true;
                }
                this.updateSelection(x, y);
                return false;
            }
            case Select: {
                this.debounce = System.currentTimeMillis();
                if (this.selectionFinished && !released) {
                    this.startSelection(x, y);
                } else {
                    this.updateSelection(x, y);
                }
                this.selectionFinished = released;
                return false;
            }
        }
        return true;
    }

    private void startSelection(int x, int y) {
        this.selectNone();
        selectRect = new Rectangle(1.0, 1.0, (Paint)Color.NAVY);
        selectRect.setTranslateX((double)(x * this.xScale));
        selectRect.setTranslateY((double)(y * this.yScale));
        selectRect.setOpacity(0.5);
        this.selectStartX = x;
        this.selectStartY = y;
        this.anchorPane.getChildren().add((Object)selectRect);
    }

    private void updateSelection(int x, int y) {
        if (selectRect == null) {
            this.startSelection(x, y);
        }
        int startX = Math.min(this.selectStartX, x);
        int endX = Math.max(this.selectStartX, x);
        int startY = Math.min(this.selectStartY, y);
        int endY = Math.max(this.selectStartY, y);
        selectRect.setTranslateX((double)(startX * this.xScale));
        selectRect.setTranslateY((double)(startY * this.yScale));
        selectRect.setWidth((double)((endX - startX) * this.xScale));
        selectRect.setHeight((double)((endY - startY) * this.yScale));
        this.setSelectionArea(startX, startY, endX, endY);
    }

    private void fillSelection(int x, int y) {
        if (selectRect == null) {
            return;
        }
        this.anchorPane.getChildren().remove((Object)selectRect);
        selectRect = null;
        for (int yy = Math.min(this.selectStartY, y); yy <= Math.max(this.selectStartY, y); ++yy) {
            for (int xx = Math.min(this.selectStartX, x); xx <= Math.max(this.selectStartX, x); ++xx) {
                this.plot(xx, yy, this.currentFillPattern, this.hiBitMatters);
            }
        }
    }

    public void drawBrush(int x, int y, int size, int[] pattern, boolean hiBitMatters) {
        for (int yy = y - size; yy <= y + size; ++yy) {
            for (int xx = x - size; xx <= x + size; ++xx) {
                if (Math.sqrt((xx - x) * (xx - x) + (yy - y) * (yy - y)) > (double)size) continue;
                this.plot(xx, yy, pattern, hiBitMatters);
            }
            this.redrawScanline(yy);
        }
    }

    public void plot(int x, int y, int[] pattern, boolean hiBitMatters) {
        if (x < 0 || y < 0 || x >= this.getWidth() * 7 || y >= this.getHeight()) {
            return;
        }
        int pat = pattern[y % 16 * 4 + x / 7 % 4];
        this.set((pat & 1 << x % 7) != 0, x, y);
        if (hiBitMatters) {
            this.setHiBit(pat >= 128, x, y);
        }
    }

    public void toggleHiBit(int x, int y) {
        byte[] data = this.getImageData();
        int n = y * this.getWidth() + x / 7;
        data[n] = (byte)(data[n] ^ 0x80);
        this.setData(data);
    }

    public void setHiBit(boolean on, int x, int y) {
        byte[] data = this.getImageData();
        if (on) {
            int n = y * this.getWidth() + x / 7;
            data[n] = (byte)(data[n] | 0x80);
        } else {
            int n = y * this.getWidth() + x / 7;
            data[n] = (byte)(data[n] & 0x7F);
        }
        this.setData(data);
    }

    public void toggle(int x, int y) {
        byte[] data = this.getImageData();
        int n = y * this.getWidth() + x / 7;
        data[n] = (byte)(data[n] ^ 1 << x % 7);
        this.setData(data);
    }

    public void set(boolean on, int x, int y) {
        byte[] data = this.getImageData();
        int n = y * this.getWidth() + x / 7;
        data[n] = (byte)(data[n] | 1 << x % 7);
        if (!on) {
            int n2 = y * this.getWidth() + x / 7;
            data[n2] = (byte)(data[n2] ^ 1 << x % 7);
        }
        this.setData(data);
    }

    public int getWidth() {
        return this.getPlatformData(this.getPlatform()).getWidth();
    }

    public int getHeight() {
        return this.getPlatformData(this.getPlatform()).getHeight();
    }

    @Override
    public void copy() {
        HashMap<DataFormat, Object> clip = new HashMap<DataFormat, Object>();
        clip.put(DataFormat.IMAGE, this.currentImage);
        clip.put(DataFormat.PLAIN_TEXT, "selection/image/" + ApplicationState.getInstance().getGameData().getImage().indexOf(this.getEntity()) + "/" + this.getSelectionInfo());
        Clipboard.getSystemClipboard().setContent(clip);
        this.copyData = Arrays.copyOf(this.getImageData(), this.getImageData().length);
    }

    @Override
    public void paste() {
        if (Clipboard.getSystemClipboard().hasContent(DataFormat.PLAIN_TEXT) && this.pasteAppContent((String)Clipboard.getSystemClipboard().getContent(DataFormat.PLAIN_TEXT))) {
            return;
        }
        if (Clipboard.getSystemClipboard().hasContent(DataFormat.IMAGE)) {
            Image image = Clipboard.getSystemClipboard().getImage();
            this.importImage(image);
        }
    }

    public boolean pasteAppContent(String contentPath) {
        this.trackState();
        System.out.println("Clipboard >> " + contentPath);
        Map<String, Integer> selection = TransferHelper.getSelectionDetails(contentPath);
        if (selection.containsKey("map")) {
            TileMap map = new TileMap(ApplicationState.getInstance().getGameData().getMap().get(selection.get("map")));
            byte[] buf = this.getPlatform().imageRenderer.renderPreview(map, selection.get("x1"), selection.get("y1"), this.getWidth(), this.getHeight());
            this.setData(buf);
            this.redraw();
            return true;
        }
        if (selection.containsKey("image")) {
            byte[] sourceData;
            org.badvision.outlaweditor.data.xml.Image sourceImage = ApplicationState.getInstance().getGameData().getImage().get(selection.get("image"));
            if (sourceImage.equals(this.getEntity())) {
                sourceData = this.copyData;
            } else {
                PlatformData platformData = sourceImage.getDisplayData().stream().filter(d -> d.getPlatform().equals(this.getPlatform().name())).findFirst().orElse(null);
                if (platformData == null) {
                    throw new NullPointerException("Unable to paste from source image, no matching platform data.");
                }
                sourceData = platformData.getValue();
            }
            if (selection.containsKey("all")) {
                this.setData(Arrays.copyOf(sourceData, sourceData.length));
                this.redraw();
                return true;
            }
            int xStart = selection.get("x1");
            int yStart = selection.get("y1");
            int xEnd = selection.get("x2");
            int yEnd = selection.get("y2");
            byte[] targetData = this.getImageData();
            int pasteX = this.lastActionX;
            int pasteY = this.lastActionY;
            if (xStart % 2 != pasteX % 2) {
                pasteX = pasteX == 0 || pasteX % 7 > 3 || pasteX + (xEnd - xStart) / 7 < this.getWidth() ? ++pasteX : --pasteX;
            }
            System.out.println("Paste to " + pasteX + "," + pasteY);
            int sourceY = yStart;
            int targetY = pasteY;
            while (sourceY <= yEnd) {
                if (targetY >= 0 && targetY < this.getHeight()) {
                    int sourceRow = sourceY * this.getWidth();
                    int targetRow = targetY * this.getWidth();
                    int sourceX = xStart;
                    int targetX = pasteX;
                    while (sourceX <= xEnd) {
                        if (targetX >= 0 && targetX / 7 < this.getWidth()) {
                            int targetLoc = targetRow + targetX / 7;
                            byte sourceByte = sourceData[sourceRow + sourceX / 7];
                            byte targetByte = targetData[targetLoc];
                            int targetBit = targetX % 7;
                            int sourceBit = sourceX % 7;
                            targetByte = (byte)(targetByte & (0x7F ^ 1 << targetBit));
                            targetByte = (byte)(targetByte | sourceByte & 0x80);
                            targetData[targetLoc] = targetByte = (byte)(targetByte | (sourceByte >> sourceBit & 1) << targetBit);
                        }
                        ++sourceX;
                        ++targetX;
                    }
                }
                ++sourceY;
                ++targetY;
            }
            this.setDataAndRedraw(targetData);
            return true;
        }
        return false;
    }

    @Override
    public void select() {
        this._setDrawMode(ImageEditor.DrawMode.Select);
    }

    @Override
    public void selectNone() {
        this.selectEndY = -1;
        this.selectEndX = -1;
        this.selectStartY = -1;
        this.selectStartX = -1;
        this.setSelectionArea(this.selectStartX, this.selectStartY, this.selectEndX, this.selectEndY);
        if (selectRect != null) {
            this.anchorPane.getChildren().remove((Object)selectRect);
        }
    }

    private void importImage(Image image) {
        ImageDitherEngine ditherEngine = new ImageDitherEngine(this.getPlatform());
        ditherEngine.setTargetCoordinates(0, 0);
        UIAction.openImageConversionModal(image, ditherEngine, this.getWidth(), this.getHeight(), this::setDataAndRedraw);
    }

    private int calculateHiresOffset(int y) {
        return this.calculateTextOffset(y >> 3) + ((y & 7) << 10);
    }

    private int calculateTextOffset(int y) {
        return ((y & 7) << 7) + 40 * (y >> 3);
    }

    @Override
    public void exportImage() {
        byte[] output = new byte[8192];
        int counter = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            int offset = this.calculateHiresOffset(y);
            for (int x = 0; x < this.getWidth(); ++x) {
                output[offset + x] = this.getImageData()[counter++];
            }
        }
        File out = FileUtils.getFile(null, "Export image", true, FileUtils.Extension.BINARY, FileUtils.Extension.ALL);
        if (out == null) {
            return;
        }
        try (FileOutputStream outStream = new FileOutputStream(out);){
            outStream.write(output);
            outStream.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(AppleImageEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void resize(int newWidth, int newHeight) {
        UIAction.confirm("Do you want to scale the image?  If you select no, the image will be cropped as needed.", () -> this.rescale(newWidth, newHeight), () -> this.crop(newWidth, newHeight));
    }

    public void rescale(int newWidth, int newHeight) {
        this.createNewPlatformData(newWidth, newHeight);
        this.importImage((Image)this.currentImage);
    }

    public void crop(int newWidth, int newHeight) {
    }

    private void createNewPlatformData(int width, int height) {
        PlatformData platformData = new PlatformData();
        platformData.setWidth(width);
        platformData.setHeight(height);
        platformData.setPlatform(this.getPlatform().name());
        platformData.setValue(this.getPlatform().imageRenderer.createImageBuffer(width, height));
        ((org.badvision.outlaweditor.data.xml.Image)this.getEntity()).getDisplayData().add(platformData);
    }

    public static enum StateVars {
        PATTERN,
        DRAW_MODE;

    }
}

