/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javafx.scene.Node;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.badvision.outlaweditor.ui.ToolType;

public class TransferHelper<T> {
    Class type;
    DataFormat format;
    static Random random = new Random();
    static Map<String, Object> registry = new HashMap<String, Object>();
    static Map<String, DataFormat> dataFormats = new HashMap<String, DataFormat>();
    Runnable dropSupportRegisterHandler;
    Runnable dropSupportUnregisterHandler;

    private TransferHelper() {
    }

    public TransferHelper(Class<T> clazz) {
        this.type = clazz;
        this.format = TransferHelper.getDataFormat(clazz);
    }

    public static DataFormat getDataFormat(Class clazz) {
        if (!dataFormats.containsKey(clazz.getName())) {
            dataFormats.put(clazz.getName(), new DataFormat(new String[]{clazz.getName()}));
        }
        return dataFormats.get(clazz.getName());
    }

    public void registerDragSupport(Node source, T object) {
        String id = this.type.getName() + "_" + random.nextInt(999999999);
        source.setOnDragDetected(event -> {
            registry.put(id, object);
            Dragboard db = source.startDragAndDrop(new TransferMode[]{TransferMode.LINK});
            if (this.type.isAssignableFrom(ToolType.class)) {
                ToolType tool = (ToolType)((Object)((Object)object));
                tool.getIcon().ifPresent(arg_0 -> ((Dragboard)db).setDragView(arg_0));
            }
            ClipboardContent content = new ClipboardContent();
            content.put((Object)this.format, (Object)id);
            db.setContent((Map)content);
            event.consume();
            this.dropSupportRegisterHandler.run();
        });
        source.setOnDragDone(event -> {
            registry.remove(id);
            this.dropSupportRegisterHandler.run();
        });
    }

    public void registerDropSupport(Node target, DropEventHandler<T> handler) {
        this.dropSupportUnregisterHandler = () -> {
            target.setOnDragOver(null);
            target.setOnDragDropped(null);
        };
        this.dropSupportRegisterHandler = () -> {
            target.setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.getContentTypes().contains(this.format)) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                }
                event.consume();
            });
            target.setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                if (db.getContentTypes().contains(this.format)) {
                    event.setDropCompleted(true);
                    String id = (String)db.getContent(this.format);
                    Object object = registry.get(id);
                    handler.handle(object, event.getX(), event.getY());
                } else {
                    event.setDropCompleted(false);
                }
                event.consume();
            });
        };
    }

    public static <U> U cloneObject(U source, Class<U> type, String nodeType) throws JAXBException {
        JAXBContext sourceJAXBContext = JAXBContext.newInstance((Class[])new Class[]{source.getClass()});
        Marshaller jaxbMarshaller = sourceJAXBContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        JAXBContext targetJAXBContext = JAXBContext.newInstance((Class[])new Class[]{source.getClass()});
        QName qName = new QName("info.source4code.jaxb.model", nodeType);
        JAXBElement root = new JAXBElement(qName, type, source);
        JAXBElement cloneRoot = targetJAXBContext.createUnmarshaller().unmarshal((Source)new JAXBSource(sourceJAXBContext, (Object)root), type);
        return (U)cloneRoot.getValue();
    }

    public static Map<String, Integer> getSelectionDetails(String contentPath) {
        String[] bufferDetails = contentPath.split("/");
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        for (int i = 1; i < bufferDetails.length; i += 2) {
            details.put(bufferDetails[i], i + 1 < bufferDetails.length ? Integer.parseInt(bufferDetails[i + 1]) : -1);
        }
        return details;
    }

    public static interface DropEventHandler<T> {
        public void handle(T var1, double var2, double var4);
    }
}

