/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.data.DataUtilities;
import org.badvision.outlaweditor.data.xml.Arg;
import org.badvision.outlaweditor.data.xml.Block;
import org.badvision.outlaweditor.data.xml.Global;
import org.badvision.outlaweditor.data.xml.Mutation;
import org.badvision.outlaweditor.data.xml.Scope;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.data.xml.Statement;
import org.badvision.outlaweditor.data.xml.UserType;
import org.badvision.outlaweditor.data.xml.Variable;
import org.badvision.outlaweditor.spelling.SpellChecker;
import org.badvision.outlaweditor.spelling.SpellResponse;
import org.badvision.outlaweditor.spelling.Suggestion;
import org.badvision.outlaweditor.ui.ApplicationUIController;
import org.badvision.outlaweditor.ui.MythosScriptEditorController;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MythosEditor {
    Scope scope;
    Script script;
    Stage primaryStage;
    MythosScriptEditorController controller;
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n";
    SpellChecker spellChecker;

    public MythosEditor(Script theScript, Scope theScope) {
        this.script = theScript;
        this.scope = theScope;
        this.spellChecker = new SpellChecker();
        this.fixMutators(this.script.getBlock());
    }

    public void show() {
        this.primaryStage = new Stage();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/MythosScriptEditor.fxml"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("onloadScript", this.generateLoadScript());
        fxmlLoader.setResources(MythosScriptEditorController.createResourceBundle(properties));
        try {
            AnchorPane node = (AnchorPane)fxmlLoader.load();
            this.controller = (MythosScriptEditorController)fxmlLoader.getController();
            this.controller.setEditor(this);
            Scene s = new Scene((Parent)node);
            this.primaryStage.setScene(s);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.primaryStage.setOnCloseRequest(t -> t.consume());
        this.primaryStage.show();
    }

    public void close() {
        Platform.runLater(() -> {
            this.primaryStage.getScene().getRoot().setDisable(true);
            this.primaryStage.close();
        });
    }

    public void applyChanges() {
        try {
            String xml = this.controller.getScriptXml();
            JAXBContext context = JAXBContext.newInstance((String)"org.badvision.outlaweditor.data.xml");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            JAXBElement b = unmarshaller.unmarshal((Node)doc, Block.class);
            this.script.setBlock((Block)b.getValue());
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(MythosEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String generateLoadScript() {
        if (this.script == null || this.script.getBlock() == null) {
            return this.generateLoadScript(this.getDefaultBlockMarkup());
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Block.class});
            StringWriter buffer = new StringWriter();
            QName qName = new QName("outlaw", "block");
            JAXBElement root = new JAXBElement(qName, Block.class, (Object)this.script.getBlock());
            context.createMarshaller().marshal((Object)root, (Writer)buffer);
            String xml = buffer.toString();
            xml = xml.replaceAll("'", "&apos;");
            xml = xml.replace("?>", "?><xml>");
            xml = xml + "</xml>";
            return this.generateLoadScript(xml);
        }
        catch (JAXBException ex) {
            Logger.getLogger(MythosEditor.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String generateLoadScript(String xml) {
        xml = xml.replaceAll("'", "\\'");
        xml = xml.replaceAll("\n", "");
        String loadScript = "Mythos.initCustomDefinitions();";
        loadScript = loadScript + "Mythos.setScriptXml('" + xml + "');";
        return loadScript;
    }

    private String getDefaultBlockMarkup() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<xml><block type=\"procedures_defreturn\" id=\"1\" inline=\"false\" x=\"5\" y=\"5\"><mutation></mutation><field name=\"NAME\">NewScript</field></block></xml>";
    }

    public void setFunctionName(String name) {
        if (this.script == null) {
            return;
        }
        this.script.setName(name);
        ApplicationUIController.getController().redrawScripts();
    }

    public List<UserType> getUserTypes() {
        Global global = (Global)MythosEditor.getGlobalScope();
        if (global.getUserTypes() == null) {
            return new ArrayList<UserType>();
        }
        return global.getUserTypes().getUserType();
    }

    public List<Script> getGlobalFunctions() {
        return this.getFunctions(MythosEditor.getGlobalScope());
    }

    public List<Script> getLocalFunctions() {
        return this.getFunctions(this.scope);
    }

    private List<Script> getFunctions(Scope scriptScope) {
        if (scriptScope.getScripts() == null) {
            return new ArrayList<Script>();
        }
        List<Script> scripts = scriptScope.getScripts().getScript();
        List<Script> filteredList = scripts.stream().filter(s -> s.getName() != null).collect(Collectors.toList());
        return filteredList;
    }

    public List<Variable> getGlobalVariables() {
        return this.getVariables(MythosEditor.getGlobalScope());
    }

    public static Scope getGlobalScope() {
        return ApplicationState.getInstance().getGameData().getGlobal();
    }

    private boolean isGlobalScope() {
        return this.scope.equals(MythosEditor.getGlobalScope());
    }

    public List<Variable> getLocalVariables() {
        return this.getVariables(this.scope);
    }

    private List<Variable> getVariables(Scope scriptScope) {
        if (scriptScope.getVariables() == null) {
            return new ArrayList<Variable>();
        }
        return scriptScope.getVariables().getVariable();
    }

    public List<Variable> getVariablesByType(String type) {
        Stream<Object> allGlobals = Stream.empty();
        if (!this.isGlobalScope()) {
            allGlobals = this.getGlobalVariables().stream();
        }
        Stream allLocals = this.getLocalVariables().stream();
        return Stream.concat(allGlobals, allLocals).filter(v -> v.getType().equals(type)).collect(Collectors.toList());
    }

    public List<String> getParametersForScript(Script script) {
        ArrayList<String> allArgs = new ArrayList<String>();
        if (script.getBlock() != null) {
            DataUtilities.extractFirst(script.getBlock(), Mutation.class).ifPresent(m -> m.getArg().stream().map(Arg::getName).forEach(allArgs::add));
        }
        return allArgs;
    }

    public String checkSpelling(String value) {
        SpellResponse result = this.spellChecker.check(value);
        if (result.getErrors() == 0) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        result.getCorrections().forEach((source, suggestions) -> message.append(source.word).append(": ").append(suggestions.stream().map(Suggestion::getWord).limit(5L).collect(Collectors.joining(","))).append("\n"));
        return message.toString();
    }

    public void log(String message) {
        Logger.getLogger(this.getClass().getName()).warning(message);
        System.out.println(message);
    }

    private void fixMutators(Block block) {
        DataUtilities.extractFirst(block, Mutation.class).ifPresent(mutation -> {
            if (mutation.getOtherAttributes().isEmpty()) {
                try {
                    MutationType type = MutationType.valueOf(block.getType());
                    type.rebuildMutation.accept(block);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        DataUtilities.extract(block, Statement.class).map(Statement::getBlock).flatMap(Collection::stream).forEach(this::fixMutators);
        if (block != null && block.getNext() != null && block.getNext().getBlock() != null) {
            this.fixMutators(block.getNext().getBlock());
        }
    }

    private static void fixIfStatement(Block block) {
        Mutation mutation = DataUtilities.extractFirst(block, Mutation.class).get();
        long doCount = DataUtilities.extract(block, Statement.class).filter(s -> s.getName().startsWith("DO")).collect(Collectors.counting());
        long elseCount = DataUtilities.extract(block, Statement.class).filter(s -> s.getName().startsWith("ELSE")).collect(Collectors.counting());
        if (doCount > 1L) {
            mutation.getOtherAttributes().put(new QName("elseif"), String.valueOf(doCount - 1L));
        }
        if (elseCount > 0L) {
            mutation.getOtherAttributes().put(new QName("else"), String.valueOf(elseCount));
        }
    }

    public static enum MutationType {
        controls_if(x$0 -> MythosEditor.access$000(x$0));

        Consumer<Block> rebuildMutation;

        private MutationType(Consumer<Block> rebuilder) {
            this.rebuildMutation = rebuilder;
        }
    }
}

