/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import org.badvision.outlaweditor.Editor;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.data.TileMap;
import org.badvision.outlaweditor.data.TileUtils;
import org.badvision.outlaweditor.data.xml.Map;
import org.badvision.outlaweditor.data.xml.Script;
import org.badvision.outlaweditor.data.xml.Scripts;
import org.badvision.outlaweditor.data.xml.Tile;
import org.badvision.outlaweditor.ui.TileSelectModal;
import org.badvision.outlaweditor.ui.ToolType;

public class MapEditor
extends Editor<Map, DrawMode>
implements EventHandler<MouseEvent> {
    Pane anchorPane;
    Canvas drawCanvas;
    private Tile currentTile;
    int posX = 0;
    int posY = 0;
    double zoom = 1.0;
    DrawMode drawMode = DrawMode.Pencil1px;
    TileMap currentMap;
    double tileWidth;
    double tileHeight;
    EventHandler<ScrollEvent> scrollHandler;
    private long redrawRequested;
    private Thread redrawThread;
    private static final int DASH_LENGTH = 3;
    private final Set<Script> invisibleScripts;
    Rectangle cursorAssistant;
    StringProperty cursorInfo;
    public static Rectangle selectRect = null;
    public double selectScreenStartX;
    public double selectScreenStartY;
    public static int lastX = -1;
    public static int lastY = -1;
    DrawMode lastDrawMode;
    Tile lastTile;

    public MapEditor() {
        this.tileWidth = (double)this.getCurrentPlatform().tileRenderer.getWidth() * this.zoom;
        this.tileHeight = (double)this.getCurrentPlatform().tileRenderer.getHeight() * this.zoom;
        this.scrollHandler = t -> {
            if (t.isShiftDown()) {
                t.consume();
                if (t.getDeltaY() > 0.0) {
                    this.zoomIn();
                } else {
                    this.zoomOut();
                }
            }
        };
        this.invisibleScripts = new HashSet<Script>();
        this.cursorInfo = new SimpleStringProperty();
        this.selectScreenStartX = 0.0;
        this.selectScreenStartY = 0.0;
        this.lastDrawMode = null;
        this.lastTile = null;
    }

    @Override
    protected void onEntityUpdated() {
        this.currentMap = new TileMap((Map)this.getEntity());
    }

    public TileMap getCurrentMap() {
        return this.currentMap;
    }

    @Override
    public void setDrawMode(DrawMode drawMode) {
        this.drawMode = drawMode;
        switch (drawMode) {
            case Eraser: {
                ImageCursor cursor = new ImageCursor(new Image("images/eraser.png"));
                this.drawCanvas.setCursor((Cursor)cursor);
                break;
            }
            case Select: {
                this.drawCanvas.setCursor(Cursor.CROSSHAIR);
                break;
            }
            default: {
                this.setCurrentTile(this.getCurrentTile());
            }
        }
    }

    @Override
    public void showShiftUI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void buildEditorUI(Pane tileEditorAnchorPane) {
        this.anchorPane = tileEditorAnchorPane;
        ApplicationState.getInstance().getPrimaryStage().getScene().addEventHandler(KeyEvent.KEY_PRESSED, this::keyPressed);
        this.initCanvas();
        this.redraw();
    }

    private void keyPressed(KeyEvent e) {
        if (e.isControlDown() && e.getCode() == KeyCode.SPACE) {
            e.consume();
            String category = null;
            if (this.currentTile != null) {
                category = this.currentTile.getCategory();
            }
            if (this.equals(ApplicationState.getInstance().getController().getVisibleEditor())) {
                TileSelectModal.showTileSelectModal(this.anchorPane, category, this::setCurrentTile);
            }
        }
    }

    public void initCanvas() {
        if (this.drawCanvas != null) {
            this.anchorPane.getChildren().remove((Object)this.drawCanvas);
        }
        this.drawCanvas = new Canvas();
        this.drawCanvas.heightProperty().bind((ObservableValue)ApplicationState.getInstance().getPrimaryStage().heightProperty().subtract(120));
        this.drawCanvas.widthProperty().bind((ObservableValue)ApplicationState.getInstance().getPrimaryStage().widthProperty().subtract(200));
        this.drawCanvas.widthProperty().addListener((ov, t, t1) -> this.redraw());
        this.drawCanvas.heightProperty().addListener((ov, t, t1) -> this.redraw());
        this.drawCanvas.addEventFilter(ScrollEvent.ANY, this.scrollHandler);
        this.drawCanvas.setOnMousePressed((EventHandler)this);
        this.drawCanvas.setOnMouseMoved((EventHandler)this);
        this.drawCanvas.setOnMouseDragged((EventHandler)this);
        this.drawCanvas.setOnMouseDragReleased((EventHandler)this);
        this.drawCanvas.setOnMouseReleased((EventHandler)this);
        this.anchorPane.getChildren().add(0, (Object)this.drawCanvas);
        this.cursorAssistant = new Rectangle(this.tileWidth, this.tileHeight, (Paint)new Color(0.2, 0.2, 1.0, 0.4));
        this.cursorAssistant.setMouseTransparent(true);
        this.cursorAssistant.setEffect((Effect)new Glow(1.0));
        this.anchorPane.getChildren().add((Object)this.cursorAssistant);
    }

    @Override
    public void addScript(Script script) {
        if (this.getCurrentMap().getBackingMap().getScripts() == null) {
            this.getCurrentMap().getBackingMap().setScripts(new Scripts());
        }
        this.getCurrentMap().getBackingMap().getScripts().getScript().add(script);
    }

    public void assignScript(Script script, double x, double y) {
        int xx = (int)(x / this.tileWidth) + this.posX;
        int yy = (int)(y / this.tileHeight) + this.posY;
        this.getCurrentMap().putLocationScript(xx, yy, script);
        this.redraw();
    }

    public void unassignScripts(double x, double y) {
        int xx = (int)(x / this.tileWidth) + this.posX;
        int yy = (int)(y / this.tileHeight) + this.posY;
        this.getCurrentMap().removeLocationScripts(xx, yy);
        this.redraw();
    }

    public void togglePanZoom() {
        this.anchorPane.getChildren().stream().filter(n -> n != this.drawCanvas).forEach(n -> n.setVisible(!n.isVisible()));
    }

    public void scrollBy(int deltaX, int deltaY) {
        this.posX = (int)((double)this.posX + (double)deltaX * (this.drawCanvas.getWidth() / this.tileWidth / 2.0));
        this.posY = (int)((double)this.posY + (double)deltaY * (this.drawCanvas.getHeight() / this.tileWidth / 2.0));
        this.posX = Math.max(0, this.posX);
        this.posY = Math.max(0, this.posY);
        this.redraw();
    }

    public void zoomOut() {
        if (this.zoom <= 1.0) {
            this.zoom(-0.1);
        } else {
            this.zoom(-0.25);
        }
    }

    public void zoomIn() {
        if (this.zoom >= 1.0) {
            this.zoom(0.25);
        } else {
            this.zoom(0.1);
        }
    }

    private void zoom(double delta) {
        this.zoom += delta;
        this.zoom = Math.min(Math.max(0.15, this.zoom), 4.0);
        this.tileWidth = (double)this.getCurrentPlatform().tileRenderer.getWidth() * this.zoom;
        this.tileHeight = (double)this.getCurrentPlatform().tileRenderer.getHeight() * this.zoom;
        this.redraw();
    }

    @Override
    public void observedObjectChanged(Map object) {
        this.redraw();
    }

    @Override
    public void redraw() {
        this.redrawRequested = System.nanoTime();
        if (this.redrawThread == null || !this.redrawThread.isAlive()) {
            this.redrawThread = new Thread(() -> {
                long test = 0L;
                while (test != this.redrawRequested) {
                    test = this.redrawRequested;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(MapEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                javafx.application.Platform.runLater(() -> this.doRedraw());
                this.redrawThread = null;
            });
            this.redrawThread.start();
        }
    }

    private synchronized void doRedraw() {
        int y;
        int x;
        this.clearCanvas();
        int cols = (int)(this.drawCanvas.getWidth() / this.tileWidth);
        int rows = (int)(this.drawCanvas.getHeight() / this.tileHeight);
        for (x = 0; x <= cols; ++x) {
            for (y = 0; y <= rows; ++y) {
                Tile tile = this.currentMap.get(this.posX + x, this.posY + y);
                this.doDraw(x, y, tile);
            }
        }
        for (x = 0; x <= cols; ++x) {
            for (y = 0; y <= rows; ++y) {
                this.highlightScripts(x, y, this.currentMap.getLocationScripts(this.posX + x, this.posY + y));
            }
        }
        ((Node)this.anchorPane.getChildren().get(1)).setLayoutX((this.drawCanvas.getWidth() - 30.0) / 2.0);
        ((Node)this.anchorPane.getChildren().get(2)).setLayoutY((this.drawCanvas.getHeight() - 30.0) / 2.0);
        ((Node)this.anchorPane.getChildren().get(3)).setLayoutX((this.drawCanvas.getWidth() - 30.0) / 2.0);
        ((Node)this.anchorPane.getChildren().get(4)).setLayoutY((this.drawCanvas.getHeight() - 30.0) / 2.0);
    }

    public void clearCanvas() {
        boolean oddEvenColumn = false;
        int x = 0;
        while ((double)x < this.drawCanvas.getWidth()) {
            boolean oddEven = oddEvenColumn;
            int y = 0;
            while ((double)y < this.drawCanvas.getHeight()) {
                this.drawCanvas.getGraphicsContext2D().setFill((Paint)(oddEven ? Color.BLACK : Color.NAVY));
                this.drawCanvas.getGraphicsContext2D().fillRect((double)x, (double)y, 10.0, 10.0);
                oddEven = !oddEven;
                y += 10;
            }
            oddEvenColumn = !oddEvenColumn;
            x += 10;
        }
    }

    private void doDraw(int x, int y, Tile tile) {
        double xx = (double)x * this.tileWidth;
        double yy = (double)y * this.tileHeight;
        if (tile != null) {
            this.drawCanvas.getGraphicsContext2D().drawImage((Image)TileUtils.getImage(tile, this.getCurrentPlatform()), xx, yy, this.tileWidth, this.tileHeight);
        }
    }

    public boolean isScriptVisible(Script script) {
        return !this.invisibleScripts.contains(script);
    }

    public void setScriptVisible(Script script, boolean visible) {
        this.setScriptVisible(script, visible, true);
    }

    public void setScriptVisible(Script script, boolean visible, boolean redraw) {
        if (visible) {
            this.invisibleScripts.remove(script);
        } else {
            this.invisibleScripts.add(script);
        }
        if (redraw) {
            this.redraw();
        }
    }

    private void highlightScripts(int x, int y, List<Script> scripts) {
        if (scripts == null || scripts.isEmpty()) {
            return;
        }
        List visibleScripts = scripts.stream().filter(this::isScriptVisible).collect(Collectors.toList());
        if (visibleScripts.isEmpty()) {
            return;
        }
        GraphicsContext gc = this.drawCanvas.getGraphicsContext2D();
        int idx = 0;
        double xx = (double)x * this.tileWidth;
        double yy = (double)y * this.tileHeight;
        gc.setLineWidth(4.0);
        int i = 0;
        while ((double)i < this.tileWidth - 2.0) {
            idx = (idx + 1) % visibleScripts.size();
            gc.beginPath();
            gc.moveTo(xx, yy);
            this.currentMap.getScriptColor((Script)visibleScripts.get(idx)).ifPresent(arg_0 -> ((GraphicsContext)gc).setStroke(arg_0));
            gc.lineTo(xx += 3.0, yy);
            gc.setEffect((Effect)new DropShadow(2.0, Color.BLACK));
            gc.stroke();
            i += 3;
        }
        i = 0;
        while ((double)i < this.tileHeight - 2.0) {
            idx = (idx + 1) % visibleScripts.size();
            gc.beginPath();
            gc.moveTo(xx, yy);
            this.currentMap.getScriptColor((Script)visibleScripts.get(idx)).ifPresent(arg_0 -> ((GraphicsContext)gc).setStroke(arg_0));
            gc.lineTo(xx, yy += 3.0);
            gc.setEffect((Effect)new DropShadow(2.0, Color.BLACK));
            gc.stroke();
            i += 3;
        }
        i = 0;
        while ((double)i < this.tileWidth - 2.0) {
            idx = (idx + 1) % visibleScripts.size();
            gc.beginPath();
            gc.moveTo(xx, yy);
            this.currentMap.getScriptColor((Script)visibleScripts.get(idx)).ifPresent(arg_0 -> ((GraphicsContext)gc).setStroke(arg_0));
            gc.lineTo(xx -= 3.0, yy);
            gc.setEffect((Effect)new DropShadow(2.0, Color.BLACK));
            gc.stroke();
            i += 3;
        }
        i = 0;
        while ((double)i < this.tileHeight - 2.0) {
            idx = (idx + 1) % visibleScripts.size();
            gc.beginPath();
            gc.moveTo(xx, yy);
            this.currentMap.getScriptColor((Script)visibleScripts.get(idx)).ifPresent(arg_0 -> ((GraphicsContext)gc).setStroke(arg_0));
            gc.lineTo(xx, yy -= 3.0);
            gc.setEffect((Effect)new DropShadow(2.0, Color.BLACK));
            gc.stroke();
            i += 3;
        }
    }

    public void setupDragDrop(TransferHelper<Script> scriptHelper, TransferHelper<ToolType> toolHelper) {
        scriptHelper.registerDropSupport((Node)this.drawCanvas, (script, x, y) -> this.assignScript((Script)script, x, y));
        toolHelper.registerDropSupport((Node)this.drawCanvas, (tool, x, y) -> this.unassignScripts(x, y));
    }

    @Override
    public void unregister() {
        this.drawCanvas.widthProperty().unbind();
        this.drawCanvas.heightProperty().unbind();
        this.anchorPane.getChildren().remove((Object)this.drawCanvas);
        this.currentMap.updateBackingMap();
        ApplicationState.getInstance().getPrimaryStage().getScene().removeEventHandler(KeyEvent.KEY_PRESSED, this::keyPressed);
    }

    public Tile getCurrentTile() {
        return this.currentTile;
    }

    public Tile setCurrentTile(Tile currentTile) {
        if (this.drawMode == DrawMode.Eraser) {
            this.drawMode = DrawMode.Pencil1px;
        }
        this.currentTile = currentTile;
        ImageCursor cursor = new ImageCursor((Image)TileUtils.getImage(currentTile, this.getCurrentPlatform()), 2.0, 2.0);
        this.drawCanvas.setCursor((Cursor)cursor);
        return currentTile;
    }

    public void showPreview() {
        byte[] data = this.getCurrentPlatform().imageRenderer.renderPreview(this.currentMap, this.posX, this.posY, this.getCurrentPlatform().maxImageWidth, this.getCurrentPlatform().maxImageHeight);
        WritableImage img = this.getCurrentPlatform().imageRenderer.renderImage(null, data, this.getCurrentPlatform().maxImageWidth, this.getCurrentPlatform().maxImageHeight);
        Stage stage = new Stage();
        stage.setTitle("Preview");
        ImageView imgView = new ImageView((Image)img);
        Group root = new Group(new Node[]{imgView});
        stage.setScene(new Scene((Parent)root, img.getWidth(), img.getHeight()));
        stage.show();
    }

    @Override
    public void copy() {
        byte[] data = this.getCurrentPlatform().imageRenderer.renderPreview(this.currentMap, this.posX, this.posY, this.getCurrentPlatform().maxImageWidth, this.getCurrentPlatform().maxImageHeight);
        WritableImage img = this.getCurrentPlatform().imageRenderer.renderImage(null, data, this.getCurrentPlatform().maxImageWidth, this.getCurrentPlatform().maxImageHeight);
        HashMap<DataFormat, Object> clip = new HashMap<DataFormat, Object>();
        clip.put(DataFormat.IMAGE, img);
        if (this.drawMode != DrawMode.Select || this.startX >= 0) {
            clip.put(DataFormat.PLAIN_TEXT, "selection/map/" + ApplicationState.getInstance().getGameData().getMap().indexOf(this.getEntity()) + "/" + this.getSelectionInfo());
        }
        Clipboard.getSystemClipboard().setContent(clip);
        this.clearSelection();
    }

    @Override
    public String getSelectedAllInfo() {
        this.setSelectionArea(this.posX, this.posY, this.posX + 19, this.posY + 11);
        String result = this.getSelectionInfo();
        return result;
    }

    @Override
    public void paste() {
        String clipboardInfo;
        java.util.Map<String, Integer> selection;
        if (Clipboard.getSystemClipboard().hasContent(DataFormat.PLAIN_TEXT) && (selection = TransferHelper.getSelectionDetails(clipboardInfo = (String)Clipboard.getSystemClipboard().getContent(DataFormat.PLAIN_TEXT))).containsKey("map")) {
            this.trackState();
            Map sourceMap = ApplicationState.getInstance().getGameData().getMap().get(selection.get("map"));
            TileMap source = this.getCurrentMap();
            if (!sourceMap.equals(this.getCurrentMap().getBackingMap())) {
                source = new TileMap(sourceMap);
            } else {
                source.updateBackingMap();
            }
            int height = selection.get("y2") - selection.get("y1");
            int width = selection.get("x2") - selection.get("x1");
            int x1 = selection.get("x1");
            int y1 = selection.get("y1");
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.plot(x + lastX, y + lastY, source.get(x + x1, y + y1));
                }
            }
        }
    }

    @Override
    public void select() {
        this.setDrawMode(DrawMode.Select);
    }

    @Override
    public void selectNone() {
        this.clearSelection();
    }

    private void updateCursorAssistant(MouseEvent t) {
        if (t.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.cursorAssistant.setVisible(false);
        } else {
            this.cursorAssistant.setVisible(true);
            this.cursorAssistant.setTranslateX(t.getX() - t.getX() % this.tileWidth);
            this.cursorAssistant.setTranslateY(t.getY() - t.getY() % this.tileHeight);
        }
    }

    public void removeScript(Script script) {
        this.getCurrentMap().removeScriptFromMap(script);
        this.redraw();
    }

    private Platform getCurrentPlatform() {
        return ApplicationState.getInstance().getCurrentPlatform();
    }

    public void plot(int x, int y, Tile t) {
        if (x < 0) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (x >= ((Map)this.getEntity()).getWidth()) {
            System.out.println("X out of bounds " + ((Map)this.getEntity()).getWidth());
            return;
        }
        if (y >= ((Map)this.getEntity()).getHeight()) {
            System.out.println("Y out of bounds " + ((Map)this.getEntity()).getHeight());
            return;
        }
        this.currentMap.put(x, y, t);
        this.doDraw(x - this.posX, y - this.posY, t);
    }

    public void drawBrush(int x, int y, int size, Tile t) {
        for (int xx = x - size; xx <= x + size; ++xx) {
            for (int yy = y - size; yy <= y + size; ++yy) {
                if (Math.sqrt((xx - x) * (xx - x) + (yy - y) * (yy - y)) > (double)size) continue;
                this.plot(xx, yy, this.getCurrentTile());
            }
        }
    }

    public StringProperty cursorInfoProperty() {
        return this.cursorInfo;
    }

    private void startSelection(double x, double y) {
        selectRect = new Rectangle(1.0, 1.0, (Paint)Color.NAVY);
        selectRect.setTranslateX(x);
        selectRect.setTranslateY(y);
        selectRect.setOpacity(0.5);
        this.selectScreenStartX = x;
        this.selectScreenStartY = y;
        this.anchorPane.getChildren().add((Object)selectRect);
    }

    private void updateSelection(double x, double y) {
        if (selectRect == null || this.selectScreenStartX < 0.0 || this.selectScreenStartY < 0.0) {
            this.clearSelection();
            this.startSelection(x, y);
        }
        double minX = Math.min(this.selectScreenStartX, x);
        double minY = Math.min(this.selectScreenStartY, y);
        double maxX = Math.max(this.selectScreenStartX, x);
        double maxY = Math.max(this.selectScreenStartY, y);
        selectRect.setTranslateX(minX);
        selectRect.setTranslateY(minY);
        selectRect.setWidth(maxX - minX);
        selectRect.setHeight(maxY - minY);
        this.setSelectionArea((int)(minX / this.tileWidth + (double)this.posX), (int)(minY / this.tileHeight + (double)this.posY), (int)(maxX / this.tileWidth + (double)this.posX), (int)(maxY / this.tileHeight + (double)this.posY));
    }

    private void fillSelection() {
        for (int yy = this.startY; yy <= this.endY; ++yy) {
            for (int xx = this.startX; xx <= this.endX; ++xx) {
                this.plot(xx, yy, this.getCurrentTile());
            }
        }
        this.clearSelection();
    }

    private void clearSelection() {
        this.anchorPane.getChildren().remove((Object)selectRect);
        selectRect = null;
        this.setSelectionArea(-1, -1, -1, -1);
    }

    @Override
    protected void trackState() {
        this.currentMap.updateBackingMap();
        super.trackState();
    }

    public void handle(MouseEvent t) {
        int x = (int)(t.getX() / this.tileWidth) + this.posX;
        int y = (int)(t.getY() / this.tileHeight) + this.posY;
        this.updateCursorAssistant(t);
        this.cursorInfo.set((Object)("X=" + x + " Y=" + y));
        if (!t.isPrimaryButtonDown() && t.getEventType() != MouseEvent.MOUSE_RELEASED && this.drawMode != DrawMode.FilledRect) {
            return;
        }
        if (this.getCurrentTile() == null && this.drawMode.requiresCurrentTile()) {
            return;
        }
        t.consume();
        boolean canSkip = false;
        if (this.getCurrentTile() == this.lastTile && x == lastX && y == lastY && this.drawMode == this.lastDrawMode) {
            canSkip = true;
        }
        lastX = x;
        lastY = y;
        this.lastDrawMode = this.drawMode;
        this.lastTile = this.getCurrentTile();
        switch (this.drawMode) {
            case Eraser: {
                if (canSkip) {
                    return;
                }
                this.trackState();
                this.plot(x, y, null);
                this.redraw();
                break;
            }
            case Pencil1px: {
                if (canSkip) {
                    return;
                }
                this.trackState();
                this.plot(x, y, this.getCurrentTile());
                break;
            }
            case Pencil3px: {
                if (canSkip) {
                    return;
                }
                this.trackState();
                this.drawBrush(x, y, 2, this.getCurrentTile());
                break;
            }
            case Pencil5px: {
                if (canSkip) {
                    return;
                }
                this.trackState();
                this.drawBrush(x, y, 5, this.getCurrentTile());
                break;
            }
            case FilledRect: {
                this.updateSelection(t.getX(), t.getY());
                if (t.getEventType().equals(MouseEvent.MOUSE_RELEASED)) {
                    this.trackState();
                    this.fillSelection();
                }
            }
            case Select: {
                this.updateSelection(t.getX(), t.getY());
                if (!t.getEventType().equals(MouseEvent.MOUSE_RELEASED)) break;
                this.selectScreenStartY = -1.0;
                this.selectScreenStartX = -1.0;
            }
        }
    }

    public static enum DrawMode {
        Pencil1px,
        Pencil3px,
        Pencil5px,
        FilledRect,
        Eraser(false),
        Select(false);

        boolean requireTile = false;

        private DrawMode() {
            this(true);
        }

        private DrawMode(boolean require) {
            this.requireTile = require;
        }

        public boolean requiresCurrentTile() {
            return this.requireTile;
        }
    }
}

