/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.badvision.outlaweditor.api.ApplicationState;

public class FileUtils {
    private FileUtils() {
    }

    public static File getFile(File prevFile, String title, Boolean create, Extension ... supportedExtensions) {
        FileChooser f = new FileChooser();
        if (prevFile != null) {
            if (prevFile.isFile()) {
                f.setInitialDirectory(prevFile.getParentFile());
            } else {
                f.setInitialDirectory(prevFile);
            }
        }
        f.setTitle(title);
        for (Extension e : supportedExtensions) {
            f.getExtensionFilters().add((Object)e.getExtensionFilter());
        }
        if (create.booleanValue()) {
            File file = f.showSaveDialog((Window)ApplicationState.getInstance().getPrimaryStage());
            if (file == null) {
                return null;
            }
            if (!file.getName().contains(".")) {
                return new File(file.getParentFile(), file.getName() + "." + supportedExtensions[0].extension);
            }
            return file;
        }
        return f.showOpenDialog((Window)ApplicationState.getInstance().getPrimaryStage());
    }

    public static <T> T loadFromFile(File f, Class<T> clazz) throws FileNotFoundException, IOException, ClassNotFoundException {
        if (!f.isFile() || !f.exists()) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        try (FileInputStream in = new FileInputStream(f);){
            int read;
            while ((read = in.read(b)) > 0) {
                buffer.write(b, 0, read);
            }
            byte[] decompressed = FileUtils.decompress(buffer.toByteArray());
            T t = FileUtils.byteToObject(decompressed);
            return t;
        }
    }

    public static void saveToFile(File f, Object obj) throws IOException {
        try (FileOutputStream fis = new FileOutputStream(f, false);){
            fis.write(FileUtils.compress(FileUtils.objectToByte(obj)));
            fis.flush();
            fis.close();
        }
    }

    public static <T> T byteToObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream is = new ObjectInputStream(in);
        return (T)is.readObject();
    }

    public static byte[] objectToByte(Object o) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(out);){
            os.writeObject(o);
            os.flush();
            os.close();
        }
        return out.toByteArray();
    }

    public static byte[] compress(byte[] bytesToCompress) {
        Deflater deflater = new Deflater();
        deflater.setInput(bytesToCompress);
        deflater.finish();
        byte[] bytesCompressed = new byte[Short.MAX_VALUE];
        int numberOfBytesAfterCompression = deflater.deflate(bytesCompressed);
        byte[] returnValues = new byte[numberOfBytesAfterCompression];
        System.arraycopy(bytesCompressed, 0, returnValues, 0, numberOfBytesAfterCompression);
        return returnValues;
    }

    public static byte[] decompress(byte[] bytesToDecompress) {
        try {
            int numberOfBytesToDecompress = bytesToDecompress.length;
            Inflater inflater = new Inflater();
            inflater.setInput(bytesToDecompress, 0, numberOfBytesToDecompress);
            int compressionFactorMaxLikely = 3;
            int bufferSizeInBytes = numberOfBytesToDecompress * compressionFactorMaxLikely;
            byte[] bytesDecompressed = new byte[bufferSizeInBytes];
            int numberOfBytesAfterDecompression = inflater.inflate(bytesDecompressed);
            byte[] returnValues = new byte[numberOfBytesAfterDecompression];
            System.arraycopy(bytesDecompressed, 0, returnValues, 0, numberOfBytesAfterDecompression);
            inflater.end();
            return returnValues;
        }
        catch (DataFormatException ex) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static enum Extension {
        XML("XML files", "xml"),
        TILESET("Tileset", "ots"),
        ALL("All files", "*"),
        BINARY("Binary", "bin");

        String description;
        String extension;

        private Extension(String desc, String ext) {
            this.description = desc;
            this.extension = ext;
        }

        public FileChooser.ExtensionFilter getExtensionFilter() {
            return new FileChooser.ExtensionFilter(this.description + " (*." + this.extension + ")", new String[]{"*." + this.extension});
        }
    }
}

