/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.layout.Pane;
import javax.xml.bind.JAXBException;
import org.badvision.outlaweditor.TransferHelper;
import org.badvision.outlaweditor.data.DataObserver;
import org.badvision.outlaweditor.data.DataProducer;
import org.badvision.outlaweditor.data.xml.Script;
import org.jvnet.jaxb2_commons.lang.CopyTo2;

public abstract class Editor<T, D>
implements DataObserver<T> {
    public static final int UNDO_HISTORY_LENGTH = 50;
    LinkedList<T> undoStates = new LinkedList();
    T editEntity;
    int startX = 0;
    int startY = 0;
    int endX = 0;
    int endY = 0;
    String selectInfo;

    public void setEntity(T t) {
        this.editEntity = t;
        DataProducer.addObserver(t, this);
        this.onEntityUpdated();
    }

    public T getEntity() {
        return this.editEntity;
    }

    public abstract void setDrawMode(D var1);

    public abstract void showShiftUI();

    public abstract void buildEditorUI(Pane var1);

    public abstract void unregister();

    public abstract void copy();

    public abstract void paste();

    public abstract void select();

    public abstract void selectNone();

    public void setSelectionArea(int x1, int y1, int x2, int y2) {
        this.startX = Math.min(x1, x2);
        this.startY = Math.min(y1, y2);
        this.endX = Math.max(x1, x2);
        this.endY = Math.max(y1, y2);
        this.selectInfo = this.startX + this.startY + this.endX + this.endY <= 0 ? null : "x1/" + this.startX + "/y1/" + this.startY + "/x2/" + this.endX + "/y2/" + this.endY;
    }

    public String getSelectedAllInfo() {
        return "all";
    }

    public String getSelectionInfo() {
        if (this.selectInfo == null) {
            return this.getSelectedAllInfo();
        }
        return this.selectInfo;
    }

    public void addScript(Script script) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract void redraw();

    protected void trackState() {
        if (this.undoStates.size() >= 50) {
            this.undoStates.removeLast();
        }
        try {
            this.undoStates.push(TransferHelper.cloneObject(this.getEntity(), this.getEntity().getClass(), this.getEntity().getClass().getName()));
        }
        catch (JAXBException ex) {
            Logger.getLogger(Editor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void undo() {
        if (!this.undoStates.isEmpty()) {
            CopyTo2 undoState = (CopyTo2)this.undoStates.removeFirst();
            undoState.copyTo(this.getEntity());
            this.onEntityUpdated();
            this.redraw();
        }
    }

    protected void onEntityUpdated() {
    }
}

