/*
 * Decompiled with CFR 0.152.
 */
package org.badvision.outlaweditor;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoProcessor;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.scr.impl.Activator;
import org.badvision.outlaweditor.api.ApplicationState;
import org.badvision.outlaweditor.api.MenuAction;
import org.badvision.outlaweditor.api.Platform;
import org.badvision.outlaweditor.data.xml.GameData;
import org.badvision.outlaweditor.ui.ApplicationUIController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.util.tracker.ServiceTracker;

@Component
@Service(value={ApplicationState.class})
public class Application
extends javafx.application.Application
implements ApplicationState,
BundleActivator {
    public static Framework felix;
    private GameData gameData = new GameData();
    private Platform currentPlatform = Platform.AppleII;
    private ApplicationUIController controller;
    private Stage primaryStage;
    ServiceTracker tracker;

    public static void shutdown() {
        try {
            felix.stop();
            felix.waitForStop(0L);
        }
        catch (InterruptedException | BundleException ex) {
            Logger.getLogger(Application.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GameData getGameData() {
        return this.gameData;
    }

    @Override
    public ApplicationUIController getApplicationUI() {
        return this.controller;
    }

    @Override
    public Platform getCurrentPlatform() {
        return this.currentPlatform;
    }

    @Override
    public void setGameData(GameData newData) {
        this.gameData = newData;
    }

    @Override
    public void setCurrentPlatform(Platform newPlatform) {
        this.currentPlatform = newPlatform;
    }

    @Override
    public ApplicationUIController getController() {
        return this.controller;
    }

    @Override
    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        javafx.application.Platform.setImplicitExit((boolean)true);
        try {
            this.startPluginContainer();
        }
        catch (Exception ex) {
            Logger.getLogger(Application.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/ApplicationUI.fxml"));
        fxmlLoader.setResources(null);
        try {
            AnchorPane node = (AnchorPane)fxmlLoader.load();
            this.controller = (ApplicationUIController)fxmlLoader.getController();
            Scene s = new Scene((Parent)node);
            primaryStage.setScene(s);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        primaryStage.setOnCloseRequest(t -> t.consume());
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private void startPluginContainer() throws BundleException, Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("lazy", "false");
        config.put("felix.cache.locking", "false");
        config.put("felix.auto.deploy.dir", "install");
        config.put("felix.auto.deploy.action", "install,start");
        config.put("org.osgi.framework.system.packages.extra", "javafx.event,org.badvision.outlaweditor.api,org.badvision.outlaweditor.data,org.badvision.outlaweditor.data.xml,org.badvision.outlaweditor.ui,org.osgi.framework");
        config.put("org.osgi.framework.bootdelegation", "sun.*,com.sun.*,org.w3c.*,org.xml.*,javax.xml.*");
        felix = new Felix(config);
        felix.start();
        felix.getBundleContext().registerService(ApplicationState.class, this, null);
        this.tracker = new ServiceTracker(felix.getBundleContext(), MenuAction.class, null);
        this.tracker.open();
        Activator scrActivator = new Activator();
        scrActivator.start(felix.getBundleContext());
        AutoProcessor.process(config, felix.getBundleContext());
    }

    @Override
    public void start(BundleContext bc) throws Exception {
        Application.launch((String[])new String[0]);
    }

    @Override
    public void stop(BundleContext bc) throws Exception {
    }
}

