/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.processing;

import java.util.Collection;
import java.util.List;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.AbstractDescription;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.apache.felix.scrplugin.helper.StringUtils;

public class SlingAnnotationProcessor
implements AnnotationProcessor {
    public String getName() {
        return "Apache Sling Annotation Processor";
    }

    public void process(ScannedClass scannedClass, ClassDescription describedClass) throws SCRDescriptorFailureException, SCRDescriptorException {
        List servlets = scannedClass.getClassAnnotations(SlingServlet.class.getName());
        scannedClass.processed((Collection)servlets);
        for (ClassAnnotation cad : servlets) {
            this.processSlingServlet(cad, describedClass);
        }
        List filters = scannedClass.getClassAnnotations(SlingFilter.class.getName());
        scannedClass.processed((Collection)filters);
        for (ClassAnnotation cad : filters) {
            this.processSlingFilter(cad, describedClass);
        }
    }

    public int getRanking() {
        return 500;
    }

    private void processSlingServlet(ClassAnnotation cad, ClassDescription classDescription) {
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        boolean metatype = cad.getBooleanValue("metatype", !generateComponent);
        if (generateComponent) {
            ComponentDescription cd = new ComponentDescription((ScannedAnnotation)cad);
            cd.setName(cad.getStringValue("name", classDescription.getDescribedClass().getName()));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
            cd.setLabel(cad.getStringValue("label", null));
            cd.setDescription(cad.getStringValue("description", null));
            cd.setCreateMetatype(metatype);
            classDescription.add((AbstractDescription)cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription((ScannedAnnotation)cad);
            sd.addInterface("javax.servlet.Servlet");
            classDescription.add((AbstractDescription)sd);
        }
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "paths", "sling.servlet.paths");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "resourceTypes", "sling.servlet.resourceTypes");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "selectors", "sling.servlet.selectors");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "extensions", "sling.servlet.extensions");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "methods", "sling.servlet.methods");
    }

    private void generateStringPropertyDescriptor(ClassAnnotation cad, ClassDescription classDescription, boolean metatype, String annotationName, String propertyDescriptorName) {
        String[] values = (String[])cad.getValue(annotationName);
        if (values == null) {
            return;
        }
        PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
        pd.setName(propertyDescriptorName);
        pd.setMultiValue(values);
        pd.setType(PropertyType.String);
        if (metatype) {
            pd.setPrivate(Boolean.valueOf(true));
        }
        classDescription.add((AbstractDescription)pd);
    }

    private void processSlingFilter(ClassAnnotation cad, ClassDescription classDescription) {
        String[] scopes;
        Object val;
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        boolean metatype = cad.getBooleanValue("metatype", !generateComponent);
        if (generateComponent) {
            ComponentDescription cd = new ComponentDescription((ScannedAnnotation)cad);
            cd.setName(cad.getStringValue("name", classDescription.getDescribedClass().getName()));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
            cd.setLabel(cad.getStringValue("label", null));
            cd.setDescription(cad.getStringValue("description", null));
            cd.setCreateMetatype(metatype);
            classDescription.add((AbstractDescription)cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription((ScannedAnnotation)cad);
            sd.addInterface("javax.servlet.Filter");
            classDescription.add((AbstractDescription)sd);
        }
        int order = cad.getIntegerValue("order", 0);
        PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
        pd.setName("service.ranking");
        pd.setValue(String.valueOf(order));
        pd.setType(PropertyType.Integer);
        if (metatype) {
            pd.setPrivate(Boolean.valueOf(true));
        }
        classDescription.add((AbstractDescription)pd);
        String pattern = cad.getStringValue("pattern", "");
        if (!StringUtils.isEmpty((String)pattern)) {
            PropertyDescription pdPattern = new PropertyDescription((ScannedAnnotation)cad);
            pdPattern.setName("sling.filter.pattern");
            pdPattern.setValue(pattern);
            pdPattern.setType(PropertyType.String);
            if (metatype) {
                pdPattern.setPrivate(Boolean.valueOf(true));
            }
            classDescription.add((AbstractDescription)pdPattern);
        }
        if ((val = cad.getValue("scope")) != null) {
            String[] arr;
            if (val instanceof String[]) {
                arr = (String[])val;
                scopes = new String[arr.length / 2];
                int i = 0;
                int index = 0;
                while (i < arr.length) {
                    scopes[index] = arr[i];
                    i += 2;
                    ++index;
                }
            } else if (val instanceof String[][]) {
                arr = (String[][])val;
                scopes = new String[arr.length];
                for (int index = 0; index < arr.length; ++index) {
                    scopes[index] = arr[index][1];
                }
            } else {
                scopes = new String[]{val.toString()};
            }
        } else {
            scopes = new String[]{SlingFilterScope.REQUEST.getScope()};
        }
        PropertyDescription pd2 = new PropertyDescription((ScannedAnnotation)cad);
        pd2.setName("sling.filter.scope");
        if (scopes.length == 1) {
            pd2.setValue(scopes[0]);
        } else {
            pd2.setMultiValue(scopes);
        }
        pd2.setType(PropertyType.String);
        if (metatype) {
            pd2.setPrivate(Boolean.valueOf(true));
        }
        classDescription.add((AbstractDescription)pd2);
    }
}

