/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import org.apache.felix.scr.impl.config.ComponentContainer;
import org.apache.felix.scr.impl.helper.ActivatorParameter;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactoryComponentManager<S>
extends SingleComponentManager<S> {
    private IdentityHashMap<S, ComponentContextImpl<S>> serviceContexts = new IdentityHashMap();

    public ServiceFactoryComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods) {
        super(container, componentMethods);
    }

    @Override
    protected void deleteComponent(int reason) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        for (ComponentContextImpl<S> componentContext : this.getComponentContexts()) {
            this.disposeImplementationObject(componentContext, reason);
            this.log(4, "Unset implementation object for component {0} in deleteComponent for reason {1}", new Object[]{this.getName(), REASONS[reason]}, null);
        }
        this.serviceContexts.clear();
        this.clearServiceProperties();
    }

    @Override
    public S getService(Bundle bundle, ServiceRegistration<S> registration) {
        this.log(4, "ServiceFactory.getService()", null);
        ComponentContextImpl componentContext = new ComponentContextImpl(this, bundle);
        if (!this.collectDependencies(componentContext)) {
            return null;
        }
        this.log(4, "getService (ServiceFactory) dependencies collected.", null);
        Object service = this.createImplementationObject(bundle, new SingleComponentManager.SetImplementationObject<S>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void presetComponentContext(ComponentContextImpl<S> componentContext) {
                IdentityHashMap identityHashMap = ServiceFactoryComponentManager.this.serviceContexts;
                synchronized (identityHashMap) {
                    ServiceFactoryComponentManager.this.serviceContexts.put(componentContext.getImplementationObject(false), componentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetImplementationObject(S implementationObject) {
                IdentityHashMap identityHashMap = ServiceFactoryComponentManager.this.serviceContexts;
                synchronized (identityHashMap) {
                    ServiceFactoryComponentManager.this.serviceContexts.remove(implementationObject);
                }
            }
        }, componentContext);
        if (service == null) {
            this.log(1, "Failed creating the component instance; see log for reason", null);
        } else {
            this.m_activated = true;
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<S> registration, S service) {
        ComponentContextImpl<S> serviceContext;
        this.log(4, "ServiceFactory.ungetService()", null);
        IdentityHashMap<S, ComponentContextImpl<S>> identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            serviceContext = this.serviceContexts.get(service);
        }
        this.disposeImplementationObject(serviceContext, 5);
        identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            this.serviceContexts.remove(service);
            if (this.serviceContexts.isEmpty() && this.getState() == 8) {
                this.m_activated = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ComponentContextImpl<S>> getComponentContexts() {
        IdentityHashMap<S, ComponentContextImpl<S>> identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            return new ArrayList<ComponentContextImpl<S>>(this.serviceContexts.values());
        }
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        for (ComponentContextImpl<S> cc : this.getComponentContexts()) {
            dependencyManager.invokeBindMethod(cc, refPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    <T> boolean invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        boolean reactivate = false;
        for (ComponentContextImpl<S> cc : this.getComponentContexts()) {
            if (!dependencyManager.invokeUpdatedMethod(cc, refPair, trackingCount, cc.getEdgeInfo(dependencyManager))) continue;
            reactivate = true;
        }
        return reactivate;
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> oldRefPair, int trackingCount) {
        for (ComponentContextImpl<S> cc : this.getComponentContexts()) {
            dependencyManager.invokeUnbindMethod(cc, oldRefPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    protected MethodResult invokeModifiedMethod() {
        ModifiedMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        MethodResult result = MethodResult.VOID;
        for (ComponentContextImpl<S> componentContext : this.getComponentContexts()) {
            S instance = componentContext.getImplementationObject(true);
            result = modifiedMethod.invoke(instance, new ActivatorParameter(componentContext, -1), MethodResult.VOID, (SimpleLogger)this);
        }
        return result;
    }

    @Override
    boolean hasInstance() {
        return !this.serviceContexts.isEmpty();
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return super.getComponentInstance();
    }
}

