/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationSupport
implements ConfigurationListener {
    private static final ChangeCount changeCounter;
    private final ComponentRegistry m_registry;
    private ServiceRegistration<?> m_registration;

    public ConfigurationSupport(BundleContext bundleContext, ComponentRegistry registry) {
        this.m_registry = registry;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Configuration Support Listener");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = bundleContext.registerService(new String[]{"org.osgi.service.cm.ConfigurationListener"}, (Object)this, props);
    }

    public void dispose() {
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configureComponentHolder(ComponentHolder<?> holder) {
        Iterator<String> i$22;
        ConfigurationAdmin ca;
        List<String> confPids;
        BundleContext bundleContext;
        block27: {
            if (holder.getComponentMetadata().isConfigurationIgnored()) return false;
            bundleContext = holder.getActivator().getBundleContext();
            if (bundleContext == null) {
                return false;
            }
            confPids = holder.getComponentMetadata().getConfigurationPid();
            ServiceReference<?> caRef = bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
            if (caRef == null) return false;
            Object cao = bundleContext.getService(caRef);
            if (cao == null) return false;
            if (cao instanceof ConfigurationAdmin) {
                ca = (ConfigurationAdmin)cao;
                i$22 = confPids.iterator();
                break block27;
            } else {
                Activator.log(2, null, "Cannot configure component {0}", new Object[]{holder.getComponentMetadata().getName()}, null);
                Activator.log(2, null, "Component Bundle's Configuration Admin is not compatible with ours. This happens if multiple Configuration Admin API versions are deployed and different bundles wire to different versions", null);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    bundleContext.ungetService(caRef);
                }
                catch (IllegalStateException e) {}
            }
        }
        while (i$22.hasNext()) {
            String confPid = i$22.next();
            Collection<Configuration> factory = this.findFactoryConfigurations(ca, confPid, bundleContext.getBundle());
            if (!factory.isEmpty()) {
                boolean created = false;
                for (Configuration config : factory) {
                    Activator.log(4, null, "Configuring holder {0} with factory configuration {1}", new Object[]{holder, config}, null);
                    if (!this.checkBundleLocation(config = this.getConfiguration(ca, config.getPid()), bundleContext.getBundle())) continue;
                    long changeCount = changeCounter.getChangeCount(config, false, -1L);
                    created |= holder.configurationUpdated(new TargetedPID(config.getPid()), new TargetedPID(config.getFactoryPid()), config.getProperties(), changeCount);
                }
                if (created) continue;
                boolean i$ = false;
                return i$;
            }
            Configuration singleton = this.findSingletonConfiguration(ca, confPid, bundleContext.getBundle());
            if (singleton == null) {
                boolean bl = false;
                return bl;
            }
            singleton = this.getConfiguration(ca, singleton.getPid());
            Activator.log(4, null, "Configuring holder {0} with configuration {1}", new Object[]{holder, singleton}, null);
            if (singleton != null && this.checkBundleLocation(singleton, bundleContext.getBundle())) {
                long changeCount = changeCounter.getChangeCount(singleton, false, -1L);
                holder.configurationUpdated(new TargetedPID(singleton.getPid()), null, singleton.getProperties(), changeCount);
                continue;
            }
            boolean bl = false;
            return bl;
        }
        boolean i$22 = !confPids.isEmpty();
        return i$22;
    }

    public void configureComponentHolders(ServiceReference<ConfigurationAdmin> configurationAdminReference, Object configurationAdmin) {
        Configuration[] configs;
        if (configurationAdmin instanceof ConfigurationAdmin && (configs = this.findConfigurations((ConfigurationAdmin)configurationAdmin, null)) != null) {
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationEvent cfgEvent = new ConfigurationEvent(configurationAdminReference, 1, configs[i].getFactoryPid(), configs[i].getPid());
                this.configurationEvent(cfgEvent);
            }
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        TargetedPID pid = new TargetedPID(event.getPid());
        String rawFactoryPid = event.getFactoryPid();
        TargetedPID factoryPid = rawFactoryPid == null ? null : new TargetedPID(rawFactoryPid);
        Collection<ComponentHolder<?>> holders = factoryPid == null ? this.m_registry.getComponentHoldersByPid(pid) : this.m_registry.getComponentHoldersByPid(factoryPid);
        Activator.log(4, null, "configurationEvent: Handling {0}  of Configuration PID={1} for component holders {2}", new Object[]{this.getEventType(event), pid, holders}, null);
        block5: for (ComponentHolder<?> componentHolder : holders) {
            if (componentHolder.getComponentMetadata().isConfigurationIgnored()) continue;
            switch (event.getType()) {
                case 2: {
                    if (factoryPid == null && this.configureComponentHolder(componentHolder)) continue block5;
                    componentHolder.configurationDeleted(pid, factoryPid);
                    break;
                }
                case 1: {
                    ConfigurationInfo configInfo;
                    BundleContext bundleContext;
                    BundleComponentActivator activator = componentHolder.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    TargetedPID targetedPid = factoryPid == null ? pid : factoryPid;
                    TargetedPID oldTargetedPID = componentHolder.getConfigurationTargetedPID(pid, factoryPid);
                    if (factoryPid == null && !targetedPid.equals(oldTargetedPID) && !targetedPid.bindsStronger(oldTargetedPID) || (configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext)) == null || !this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                    componentHolder.configurationUpdated(pid, factoryPid, configInfo.getProps(), configInfo.getChangeCount());
                    break;
                }
                case 3: {
                    TargetedPID oldTargetedPID;
                    BundleContext bundleContext;
                    BundleComponentActivator activator = componentHolder.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    TargetedPID targetedPid = factoryPid == null ? pid : factoryPid;
                    if (targetedPid.equals(oldTargetedPID = componentHolder.getConfigurationTargetedPID(pid, factoryPid))) {
                        ConfigurationInfo configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext);
                        if (configInfo == null) continue block5;
                        Activator.log(4, null, "LocationChanged event, same targetedPID {0}, location now {1}", new Object[]{targetedPid, configInfo.getBundleLocation()}, null);
                        if (configInfo.getProps() == null) {
                            throw new IllegalStateException("Existing Configuration with pid " + pid + " has had its properties set to null and location changed.  We expected a delete event first.");
                        }
                        if (this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                        componentHolder.configurationDeleted(pid, factoryPid);
                        this.configureComponentHolder(componentHolder);
                        break;
                    }
                    boolean better = targetedPid.bindsStronger(oldTargetedPID);
                    if (better) {
                        ConfigurationInfo configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext);
                        if (configInfo == null) continue block5;
                        Activator.log(4, null, "LocationChanged event, better targetedPID {0} compared to {1}, location now {2}", new Object[]{targetedPid, oldTargetedPID, configInfo.getBundleLocation()}, null);
                        if (configInfo.getProps() == null) break;
                        if (!this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                        if (oldTargetedPID != null) {
                            componentHolder.configurationDeleted(pid, factoryPid);
                        }
                        componentHolder.configurationUpdated(pid, factoryPid, configInfo.getProps(), configInfo.getChangeCount());
                        break;
                    }
                    Activator.log(4, null, "LocationChanged event, worse targetedPID {0} compared to {1}, do nothing", new Object[]{targetedPid, oldTargetedPID}, null);
                    break;
                }
                default: {
                    Activator.log(2, null, "Unknown ConfigurationEvent type {0}", new Object[]{event.getType()}, null);
                }
            }
        }
    }

    private String getEventType(ConfigurationEvent event) {
        switch (event.getType()) {
            case 1: {
                return "UPDATED";
            }
            case 2: {
                return "DELETED";
            }
            case 3: {
                return "LOCATION CHANGED";
            }
        }
        return "Unkown event type: " + event.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationInfo getConfigurationInfo(TargetedPID pid, TargetedPID targetedPid, ComponentHolder<?> componentHolder, BundleContext bundleContext) {
        ServiceReference<?> caRef = bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
        if (caRef == null) return null;
        try {
            Object cao = bundleContext.getService(caRef);
            if (cao == null) return null;
            try {
                if (cao instanceof ConfigurationAdmin) {
                    ConfigurationAdmin ca = (ConfigurationAdmin)cao;
                    Configuration config = this.getConfiguration(ca, pid.getRawPid());
                    ConfigurationInfo configurationInfo = new ConfigurationInfo(config.getProperties(), config.getBundleLocation(), changeCounter.getChangeCount(config, true, componentHolder.getChangeCount(pid, targetedPid)));
                    return configurationInfo;
                }
                Activator.log(2, null, "Cannot reconfigure component {0}", new Object[]{componentHolder.getComponentMetadata().getName()}, null);
                Activator.log(2, null, "Component Bundle's Configuration Admin is not compatible with ours. This happens if multiple Configuration Admin API versions are deployed and different bundles wire to different versions", null);
                return null;
            }
            finally {
                bundleContext.ungetService(caRef);
            }
        }
        catch (IllegalStateException ise) {
            Activator.log(2, null, "Bundle in unexpected state", ise);
        }
        return null;
    }

    private Configuration getConfiguration(ConfigurationAdmin ca, String pid) {
        try {
            return ca.getConfiguration(pid);
        }
        catch (IOException ioe) {
            Activator.log(2, null, "Failed reading configuration for pid={0}", new Object[]{pid}, ioe);
            return null;
        }
    }

    public Configuration findSingletonConfiguration(ConfigurationAdmin ca, String pid, Bundle bundle) {
        String filter = this.getTargetedPidFilter(pid, bundle, "service.pid");
        Configuration[] cfg = this.findConfigurations(ca, filter);
        if (cfg == null) {
            return null;
        }
        String longest = null;
        Configuration best = null;
        for (Configuration config : cfg) {
            if (!this.checkBundleLocation(config, bundle)) continue;
            String testPid = config.getPid();
            if (longest != null && testPid.length() <= longest.length()) continue;
            longest = testPid;
            best = config;
        }
        return best;
    }

    private Collection<Configuration> findFactoryConfigurations(ConfigurationAdmin ca, String factoryPid, Bundle bundle) {
        String filter = this.getTargetedPidFilter(factoryPid, bundle, "service.factoryPid");
        Configuration[] configs = this.findConfigurations(ca, filter);
        if (configs == null) {
            return Collections.emptyList();
        }
        HashMap<String, Configuration> configsByPid = new HashMap<String, Configuration>();
        for (Configuration config : configs) {
            if (!this.checkBundleLocation(config, bundle)) continue;
            Configuration oldConfig = (Configuration)configsByPid.get(config.getPid());
            if (oldConfig == null) {
                configsByPid.put(config.getPid(), config);
                continue;
            }
            String newPid = config.getFactoryPid();
            String oldPid = oldConfig.getFactoryPid();
            if (newPid.length() <= oldPid.length()) continue;
            configsByPid.put(config.getPid(), config);
        }
        return configsByPid.values();
    }

    private boolean checkBundleLocation(Configuration config, Bundle bundle) {
        if (config == null) {
            return false;
        }
        String configBundleLocation = config.getBundleLocation();
        return this.checkBundleLocation(configBundleLocation, bundle);
    }

    private boolean checkBundleLocation(String configBundleLocation, Bundle bundle) {
        if (configBundleLocation == null) {
            return true;
        }
        if (configBundleLocation.startsWith("?")) {
            return bundle.hasPermission(new ConfigurationPermission(configBundleLocation, "target"));
        }
        return configBundleLocation.equals(bundle.getLocation());
    }

    private Configuration[] findConfigurations(ConfigurationAdmin ca, String filter) {
        try {
            return ca.listConfigurations(filter);
        }
        catch (IOException ioe) {
            Activator.log(2, null, "Problem listing configurations for filter={0}", new Object[]{filter}, ioe);
        }
        catch (InvalidSyntaxException ise) {
            Activator.log(1, null, "Invalid Configuration selection filter {0}", new Object[]{filter}, ise);
        }
        return null;
    }

    private String getTargetedPidFilter(String pid, Bundle bundle, String key) {
        String bsn = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        String location = ConfigurationSupport.escape(bundle.getLocation());
        String f = String.format("(|(%1$s=%2$s)(%1$s=%2$s|%3$s)(%1$s=%2$s|%3$s|%4$s)(%1$s=%2$s|%3$s|%4$s|%5$s))", key, pid, bsn, version, location);
        return f;
    }

    static final String escape(String value) {
        return value.replaceAll("([\\\\\\*\\(\\)])", "\\\\$1");
    }

    static {
        ChangeCount cc = null;
        try {
            Configuration.class.getMethod("getChangeCount", null);
            cc = new R5ChangeCount();
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (cc == null) {
            cc = new R4ChangeCount();
        }
        changeCounter = cc;
    }

    private static class R4ChangeCount
    implements ChangeCount {
        private R4ChangeCount() {
        }

        public long getChangeCount(Configuration configuration, boolean fromEvent, long previous) {
            return fromEvent ? previous + 1L : 0L;
        }
    }

    private static class R5ChangeCount
    implements ChangeCount {
        private R5ChangeCount() {
        }

        public long getChangeCount(Configuration configuration, boolean fromEvent, long previous) {
            return configuration.getChangeCount();
        }
    }

    private static interface ChangeCount {
        public long getChangeCount(Configuration var1, boolean var2, long var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationInfo {
        private final Dictionary<String, Object> props;
        private final String bundleLocation;
        private final long changeCount;

        public ConfigurationInfo(Dictionary<String, Object> props, String bundleLocation, long changeCount) {
            this.props = props;
            this.bundleLocation = bundleLocation;
            this.changeCount = changeCount;
        }

        public long getChangeCount() {
            return this.changeCount;
        }

        public Dictionary<String, Object> getProps() {
            return this.props;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }
    }
}

