/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.ConfigurableComponentHolder;
import org.apache.felix.scr.impl.config.ConfigurationSupport;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry
implements ServiceListener {
    public static final String CONFIGURATION_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private BundleContext m_bundleContext;
    private final Map<ComponentRegistryKey, ComponentHolder<?>> m_componentHoldersByName;
    private final Map<String, Set<ComponentHolder<?>>> m_componentHoldersByPid;
    private final Map<Long, AbstractComponentManager<?>> m_componentsById;
    private long m_componentCounter = -1L;
    private ConfigurationSupport configurationSupport;
    private final Map<ServiceReference<?>, List<Entry<?, ?>>> m_missingDependencies = new HashMap();

    protected ComponentRegistry(BundleContext context) {
        this.m_bundleContext = context;
        this.m_componentHoldersByName = new HashMap();
        this.m_componentHoldersByPid = new HashMap();
        this.m_componentsById = new HashMap();
        try {
            context.addServiceListener(this, "(objectclass=org.osgi.service.cm.ConfigurationAdmin)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (context.getServiceReference(CONFIGURATION_ADMIN) != null) {
            this.getOrCreateConfigurationSupport();
        }
    }

    public void dispose() {
        this.m_bundleContext.removeServiceListener(this);
        if (this.configurationSupport != null) {
            this.configurationSupport.dispose();
            this.configurationSupport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager<?> componentManager) {
        long componentId;
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            componentId = ++this.m_componentCounter;
            this.m_componentsById.put(componentId, componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(componentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ComponentRegistryKey checkComponentName(Bundle bundle, String name) {
        boolean present;
        ComponentRegistryKey key = new ComponentRegistryKey(bundle, name);
        ComponentHolder<?> existingRegistration = null;
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            present = this.m_componentHoldersByName.containsKey(key);
            if (!present) {
                this.m_componentHoldersByName.put(key, null);
            } else {
                existingRegistration = this.m_componentHoldersByName.get(key);
            }
        }
        if (present) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration != null) {
                Bundle cBundle = existingRegistration.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = existingRegistration.getComponentMetadata();
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponentHolder(ComponentRegistryKey key, ComponentHolder<?> componentHolder) {
        Activator.log(4, null, "Registering component with pid {0} for bundle {1}", new Object[]{componentHolder.getComponentMetadata().getConfigurationPid(), key.getBundleId()}, null);
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            if (this.m_componentHoldersByName.get(key) != null) {
                throw new ComponentException("The component name '{0}" + componentHolder.getComponentMetadata().getName() + "' has already been registered.");
            }
            this.m_componentHoldersByName.put(key, componentHolder);
        }
        map = this.m_componentHoldersByPid;
        synchronized (map) {
            List<String> configurationPids = componentHolder.getComponentMetadata().getConfigurationPid();
            for (String configurationPid : configurationPids) {
                Set<ComponentHolder<?>> set = this.m_componentHoldersByPid.get(configurationPid);
                if (set == null) {
                    set = new HashSet();
                    this.m_componentHoldersByPid.put(configurationPid, set);
                }
                set.add(componentHolder);
            }
        }
        if (this.configurationSupport != null) {
            this.configurationSupport.configureComponentHolder(componentHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder<?> getComponentHolder(Bundle bundle, String name) {
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.get(new ComponentRegistryKey(bundle, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<ComponentHolder<?>> getComponentHoldersByPid(TargetedPID targetedPid) {
        String pid = targetedPid.getServicePid();
        HashSet componentHoldersUsingPid = new HashSet();
        Map<String, Set<ComponentHolder<?>>> map = this.m_componentHoldersByPid;
        synchronized (map) {
            Set<ComponentHolder<?>> set = this.m_componentHoldersByPid.get(pid);
            if (set != null) {
                for (ComponentHolder<?> holder : set) {
                    if (!targetedPid.matchesTarget(holder)) continue;
                    componentHoldersUsingPid.add(holder);
                }
            }
        }
        return componentHoldersUsingPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ComponentHolder<?>> getComponentHolders() {
        ArrayList all = new ArrayList();
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            all.addAll(this.m_componentHoldersByName.values());
        }
        return all;
    }

    public final List<ComponentHolder<?>> getComponentHolders(Bundle ... bundles) {
        List<ComponentHolder<?>> all = this.getComponentHolders();
        ArrayList holders = new ArrayList();
        for (ComponentHolder<?> holder : all) {
            BundleComponentActivator activator = holder.getActivator();
            if (activator == null) continue;
            Bundle holderBundle = activator.getBundleContext().getBundle();
            for (Bundle b : bundles) {
                if (b != holderBundle) continue;
                holders.add(holder);
            }
        }
        return holders;
    }

    final void unregisterComponentHolder(Bundle bundle, String name) {
        this.unregisterComponentHolder(new ComponentRegistryKey(bundle, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentHolder(ComponentRegistryKey key) {
        ComponentHolder<?> component;
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            component = this.m_componentHoldersByName.remove(key);
        }
        if (component != null) {
            Activator.log(4, null, "Unregistering component with pid {0} for bundle {1}", new Object[]{component.getComponentMetadata().getConfigurationPid(), key.getBundleId()}, null);
            map = this.m_componentHoldersByPid;
            synchronized (map) {
                List<String> configurationPids = component.getComponentMetadata().getConfigurationPid();
                for (String configurationPid : configurationPids) {
                    Set<ComponentHolder<?>> componentsForPid = this.m_componentHoldersByPid.get(configurationPid);
                    if (componentsForPid == null) continue;
                    componentsForPid.remove(component);
                    if (componentsForPid.size() != 0) continue;
                    this.m_componentHoldersByPid.remove(configurationPid);
                }
            }
        }
    }

    public <S> ComponentHolder<S> createComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        return new ConfigurableComponentHolder(activator, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            ConfigurationSupport configurationSupport = this.getOrCreateConfigurationSupport();
            ServiceReference<ConfigurationAdmin> caRef = event.getServiceReference();
            ConfigurationAdmin service = (ConfigurationAdmin)this.m_bundleContext.getService(caRef);
            if (service != null) {
                try {
                    configurationSupport.configureComponentHolders(caRef, service);
                }
                finally {
                    this.m_bundleContext.ungetService(caRef);
                }
            }
        } else if (event.getType() == 4) {
            this.disposeConfigurationSupport();
        }
    }

    static boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    private ConfigurationSupport getOrCreateConfigurationSupport() {
        if (this.configurationSupport == null) {
            this.configurationSupport = new ConfigurationSupport(this.m_bundleContext, this);
        }
        return this.configurationSupport;
    }

    private void disposeConfigurationSupport() {
        if (this.configurationSupport != null) {
            this.configurationSupport.dispose();
            this.configurationSupport = null;
        }
    }

    public synchronized <T> void missingServicePresent(final ServiceReference<T> serviceReference, ComponentActorThread actor) {
        final List<Entry<?, ?>> dependencyManagers = this.m_missingDependencies.remove(serviceReference);
        if (dependencyManagers != null) {
            actor.schedule(new Runnable(){

                public void run() {
                    for (Entry entry : dependencyManagers) {
                        entry.getDm().invokeBindMethodLate(serviceReference, entry.getTrackingCount());
                    }
                }

                public String toString() {
                    return "Late binding task of reference " + serviceReference + " for dependencyManagers " + dependencyManagers;
                }
            });
        }
    }

    public synchronized <S, T> void registerMissingDependency(DependencyManager<S, T> dependencyManager, ServiceReference<T> serviceReference, int trackingCount) {
        if (serviceReference.getProperty("component.name") == null || serviceReference.getProperty("component.id") == null) {
            return;
        }
        List<Entry<?, ?>> dependencyManagers = this.m_missingDependencies.get(serviceReference);
        if (dependencyManagers == null) {
            dependencyManagers = new ArrayList();
            this.m_missingDependencies.put(serviceReference, dependencyManagers);
        }
        dependencyManagers.add(new Entry(dependencyManager, trackingCount));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<S, T> {
        private final DependencyManager<S, T> dm;
        private final int trackingCount;

        private Entry(DependencyManager<S, T> dm, int trackingCount) {
            this.dm = dm;
            this.trackingCount = trackingCount;
        }

        public DependencyManager<S, T> getDm() {
            return this.dm;
        }

        public int getTrackingCount() {
            return this.trackingCount;
        }
    }
}

