[Setup]
OutputBaseFilename=FC5025_Windows_Setup
OutputDir=.
OutputManifestFile=manifest.txt
AllowCancelDuringInstall=no
AlwaysShowComponentsList=no
; libusb isn't signed, so it won't run on 64-bit windows.
; only allow installing on 32-bit windows.
ArchitecturesAllowed=x86
AppName = USB 5.25" Floppy Drivers
AppVerName = USB 5.25" Floppy Drivers
DefaultDirName = {pf}\FC5025
DefaultGroupName = USB Floppy
SolidCompression = yes
; gtk 2.6.10 runs on win98, me, nt4
; libusb-win32 runs on win98se, winme, win2k, winxp
; so, require at least win98se
MinVersion=4.1.2222,4.0

[Messages]
; default FinishedLabel says "may be launched by selecting the installed icons."
; say something more accurate instead.
FinishedLabel=Setup has finished installing [name] on your computer. You can start the Disk Image and Browse tool using the Start menu.

[Files]
; WinDIB executable
Source: "windib.exe"; DestDir: "{app}"
; GTK libraries
Source: "..\gtk_installer\gtk_install_files\bin\*"; DestDir: "{app}"
Source: "..\gtk_installer\gtk_install_files\etc\*"; DestDir: "{app}\etc"; Flags: recursesubdirs createallsubdirs
Source: "..\gtk_installer\gtk_install_files\lib\*"; DestDir: "{app}\lib"; Flags: recursesubdirs createallsubdirs
Source: "..\gtk_installer\gtk_install_files\share\*"; DestDir: "{app}\share"; Flags: recursesubdirs createallsubdirs
; libusb-win32 libraries
Source: "..\libusb-win32-device-bin-0.1.12.2\bin\libusb0.dll"; DestDir: "{app}"
Source: "..\libusb-win32-device-bin-0.1.12.2\bin\libusb0.dll"; DestDir: "{win}\system32"; Flags: replacesameversion restartreplace uninsneveruninstall
Source: "..\libusb-win32-device-bin-0.1.12.2\bin\libusb0.sys"; DestDir: "{app}"
Source: "fc5025.inf"; DestDir: "{app}"

[Icons]
Name: "{group}\Disk Image and Browse"; Filename: "{app}\windib.exe"
Name: "{group}\Uninstall"; Filename: "{uninstallexe}"

[Run]
; invoke libusb's DLL to install the .inf file
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {app}\fc5025.inf"; StatusMsg: "Installing driver (this may take a few seconds) ..."

