/* North Star MDS double-density */

#include <stdio.h>
#include <stdint.h>
#ifdef WIN32
#include <winsock.h>
#else
#include <arpa/inet.h>
#endif
#include <usb.h>
#include <string.h>
#include "phys.h"
#include "fc5025.h"
#include "endec.h"
#include "crc.h"

static int min_track(struct phys *this) {
	return 0;
}

static int max_track(struct phys *this) {
	return 34;
}

static int min_sector(struct phys *this, int track, int side) {
	return 1;
}

static int max_sector(struct phys *this, int track, int side) {
	return 10;
}

static int sector_bytes(struct phys *this, int track, int side, int sector) {
	return 512;
}

static unsigned char ns_csum(unsigned char *buf, int count) {
	unsigned char csum=0;

	while(count--) {
		csum^=*buf++;
		csum=(csum<<1)|(csum>>7);
	}
	return csum;
}

static int read_sector(struct phys *this, unsigned char *out, int track, int side, int sector) {
	unsigned int xferlen=774;
	int xferlen_out;
	unsigned char raw[774], plain[515];
	struct {
		uint8_t opcode, flags, format;
		uint16_t bitcell;
		uint8_t sectorhole;
		uint8_t rdelayh; uint16_t rdelayl;
		uint8_t idam, id_pat[12], id_mask[12], dam[3];
	} __attribute__ ((__packed__)) cdb={OPCODE_READ_FLEXIBLE,0,FORMAT_MFM,htons(3333),sector,0,htons(347),1,{0,},};
	int status=0;

	status|=fc_bulk_cdb(&cdb,sizeof(cdb),4000,NULL,raw,xferlen,&xferlen_out);
	if(xferlen_out!=xferlen)
		status|=1;
	dec_mfm(plain,raw,515);
	if(plain[0]!=0xfb || plain[1]!=0xfb) /* sync bytes */
		return 1;
	if(ns_csum(plain+2,513)!=0)
		status|=1;
	memcpy(out,plain+2,512);
	return status;
}

struct phys phys_mdsad={
	.min_track = min_track,
	.max_track = max_track,
	.num_tracks = phys_gen_num_tracks,
	.min_side = min_track,
	.max_side = min_track,
	.num_sides = phys_gen_num_sides,
	.min_sector = min_sector,
	.max_sector = max_sector,
	.num_sectors = phys_gen_num_sectors,
	.tpi = phys_gen_48tpi,
	.density = phys_gen_low_density,
	.sector_bytes = sector_bytes,
	.track_bytes = phys_gen_track_bytes,
	.physical_track = phys_gen_physical_track,
	.read_sector = read_sector,
	.prepare = phys_gen_no_prepare
};
