/* Generic routines for physical formats */

#include "phys.h"

int phys_gen_num_tracks(struct phys *this) {
	return this->max_track(this)-this->min_track(this)+1;
}

int phys_gen_num_sectors(struct phys *this, int track, int side) {
	return this->max_sector(this,track,side)-this->min_sector(this,track,side)+1;
}

int phys_gen_num_sides(struct phys *this) {
	return this->max_side(this)-this->min_side(this)+1;
}

int phys_gen_track_bytes(struct phys *this, int track, int side) {
	int sector;
	int bytes=0;

	for(sector=this->min_sector(this,track,side);sector<=this->max_sector(this,track,side);sector++) {
		bytes+=this->sector_bytes(this,track,side,sector);
	}

	return bytes;
}

int phys_gen_physical_track(struct phys *this, int track) {
	track-=this->min_track(this);
	if(this->tpi(this)==48)
		track*=2;
	return track;
}

int phys_gen_48tpi(struct phys *this) {
	return 48;
}

int phys_gen_96tpi(struct phys *this) {
	return 96;
}

int phys_gen_100tpi(struct phys *this) {
	return 100;
}

int phys_gen_low_density(struct phys *this) {
	return 1;
}

int phys_gen_high_density(struct phys *this) {
	return 0;
}

int phys_gen_no_prepare(struct phys *this) {
	return 0;
}
