/* 5-and-3 code, used in Apple 13-sector data fields */

/* References:
   Understanding the Apple II
   Beneath Apple DOS
   Apple Assembly Lines - March / May 1981 */

static unsigned char dec_5and3_tbl[]={
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 00-0f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 10-1f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 20-2f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 30-3f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 40-4f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 50-5f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 60-6f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 70-7f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 80-8f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* 90-9f invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0x01,0x02,0x03, /* a0-af */
0xff,0xff,0xff,0xff,0xff,0x04,0x05,0x06,0xff,0xff,0x07,0x08,0xff,0x09,0x0a,0x0b, /* b0-bf */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff, /* c0-cf invalid */
0xff,0xff,0xff,0xff,0xff,0xff,0x0c,0x0d,0xff,0xff,0x0e,0x0f,0xff,0x10,0x11,0x12, /* d0-df */
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x13,0x14,0xff,0x15,0x16,0x17, /* e0-ef */
0xff,0xff,0xff,0xff,0xff,0x18,0x19,0x1a,0xff,0xff,0x1b,0x1c,0xff,0x1d,0x1e,0x1f /* f0-ff */
/*1 2 3 4 5 6 7 8 9 a b c d e f*/
};

int dec_5and3(unsigned char *out, unsigned char *in, int count) {
	unsigned char temp[411];
	int status=0;
	int i;
	unsigned char acc=0;

	if(count!=256)
		return 1;

	for(i=0;i<154;i++) {
		if(dec_5and3_tbl[in[i]]==0xff)
			status=1; /* 0xff = invalid gcr nibble */
		temp[0x199-i]=dec_5and3_tbl[in[i]]^acc;
		acc=temp[0x199-i];
	}
	for(i=0;i<256;i++) {
		if(dec_5and3_tbl[in[154+i]]==0xff)
			status=1;
		temp[i]=dec_5and3_tbl[in[154+i]]^acc;
		acc=temp[i];
	}
	if(dec_5and3_tbl[in[410]]==0xff)
		status=1;
	temp[410]=dec_5and3_tbl[in[410]];

	if(in[411]!=0xde || in[412]!=0xaa) /* epilogue */
		status=1;

	if(temp[409]!=temp[410]) /* checksum */
		status=1;

	for(i=0;i<0x33;i++) {
		out[i*5]=(temp[0x32-i]<<3)|(temp[0x132-i]>>2);
		out[(i*5)+1]=(temp[0x65-i]<<3)|(temp[0x165-i]>>2);
		out[(i*5)+2]=(temp[0x98-i]<<3)|(temp[0x198-i]>>2);
		out[(i*5)+3]=(temp[0xCB-i]<<3)|((temp[0x132-i]&2)<<1)|(temp[0x165-i]&2)|((temp[0x198-i]&2)>>1);
		out[(i*5)+4]=(temp[(0xFE)-i]<<3)|((temp[0x132-i]&1)<<2)|((temp[0x165-i]&1)<<1)|(temp[0x198-i]&1);
	}
	out[255]=(temp[0xFF]<<3)|temp[0x199];

	return status;
}
