#!/bin/sh

DSTNAME=libusb
DSTVERSION=0.1.13

MACOSX_DEPLOYMENT_TARGET=$1

if   [ "$MACOSX_DEPLOYMENT_TARGET" = "10.4" ]; then
    SDKVERSION=10.4u
    ARCHS="ppc i386"
elif [ "$MACOSX_DEPLOYMENT_TARGET" = "10.5" ]; then
    SDKVERSION=10.5
    ARCHS="ppc7400 ppc64 i386 x86_64"
elif [ "$MACOSX_DEPLOYMENT_TARGET" = "10.6" ]; then
    SDKVERSION=10.6
    ARCHS="ppc7400 i386 x86_64"
else
    MACOSX_DEPLOYMENT_TARGET=default
    echo "Warning: No valid Deployment Target specified."
    echo "         Possible targets are: 10.4, 10.5 and 10.6"
    echo "         The software will be built for the MacOSX version and"
    echo "         architecture currently running."
    echo "         No SDK package will be built."
fi

[ -n "$SDKVERSION" ] && NEXT_ROOT=/Developer/SDKs/MacOSX${SDKVERSION}.sdk

if [ -n "$NEXT_ROOT" ] && [ ! -e "$NEXT_ROOT" ]; then
    echo "Error: SDK build requested, but SDK build not installed."
    exit 1
fi

SRCDIR=`pwd`/src
BUILD=/tmp/$DSTNAME.build
DSTROOT=/tmp/$DSTNAME.dst

[ -e $BUILD ]   && (      rm -rf $BUILD   || exit 1 )
[ -e $DSTROOT ] && ( sudo rm -rf $DSTROOT || exit 1 )

for d in $DSTROOT-* ; do ( rm -rf $d || exit 1 ) ; done

mkdir $BUILD

(
    cd $BUILD
    tar -z -x -f $SRCDIR/$DSTNAME-2009-09-10-svn.tar.gz

    cd $DSTNAME-2009-09-10-svn

    patch -p1 < $SRCDIR/libusb-cxx.patch
    patch -p1 < $SRCDIR/libusb-64bit.patch
    patch -p1 < $SRCDIR/libusb-endian.patch
    patch -p1 < $SRCDIR/libusb-runloop.patch

    aclocal
    glibtoolize --force
    autoheader
    automake --add-missing --force
    autoconf

    if   [ "$MACOSX_DEPLOYMENT_TARGET" = "10.4" ]; then
	CC="/usr/bin/gcc-4.0 -isysroot $NEXT_ROOT"
	CXX="/usr/bin/g++-4.0 -isysroot $NEXT_ROOT"
	CPP="/usr/bin/cpp-4.0"
    elif [ "$MACOSX_DEPLOYMENT_TARGET" = "10.5" ]; then
	CC="/usr/bin/gcc-4.2 -isysroot $NEXT_ROOT"
	CXX="/usr/bin/g++-4.2 -isysroot $NEXT_ROOT"
	CPP="/usr/bin/cpp-4.2"
    elif [ "$MACOSX_DEPLOYMENT_TARGET" = "10.6" ]; then
	CC="/usr/bin/gcc-4.2 -isysroot $NEXT_ROOT"
	CXX="/usr/bin/g++-4.2 -isysroot $NEXT_ROOT"
	CPP="/usr/bin/cpp-4.2"
    fi

    LDFLAGS="-no-undefined"

    if [ -n "$SDKVERSION" ]; then
	export MACOSX_DEPLOYMENT_TARGET
	export NEXT_ROOT
    fi

    export LD_PREBIND_ALLOW_OVERLAP=1

    if [ -n "$ARCHS" ]; then
	for arch in $ARCHS ; do
	    CC=$CC CFLAGS="$CFLAGS -arch $arch" \
		CXX=$CXX CXXFLAGS="$CXXFLAGS -arch $arch" \
		CPP=$CPP CPPFLAGS="$CPPFLAGS -arch $arch" \
		LDFLAGS="$LDFLAGS -arch $arch" \
		./configure --host `./config.guess`
	    make
	    make install DESTDIR=$DSTROOT-$arch
	    make clean
	done
	mkdir $DSTROOT
	arch=`./config.guess | \
	    sed -e s/-.*// -e s/i.86/i386/ -e s/powerpc/ppc/`
	[ "$arch" = "ppc" -a ! -d $DSTROOT-ppc ] && arch=ppc7400
	[ ! -d $DSTROOT-$arch ] && arch=`sed "s/ .*//" <<< $ARCHS`
	for d in `(cd $DSTROOT-$arch ; find . -type d)` ; do
	    mkdir -p $DSTROOT/$d
	done
	for f in `(cd $DSTROOT-$arch ; find . -type f)` ; do
	    if [ `wc -w <<< $ARCHS` -gt 1 ] ; then
		file $DSTROOT-$arch/$f | grep -q -e 'Mach-O\|ar archive'
		if [ $? -eq 0 ] ; then
		    lipo -c -o $DSTROOT/$f $DSTROOT-*/$f
		else
		    cp -p $DSTROOT-$arch/$f $DSTROOT/$f
		fi
	    else
		cp -p $DSTROOT-$arch/$f $DSTROOT/$f
	    fi
	done
	for l in `(cd $DSTROOT-$arch ; find . -type l)` ; do
	    cp -pR $DSTROOT-$arch/$l $DSTROOT/$l
	done
	rm -rf $DSTROOT-*
    else
	CC=$CC CFLAGS="$CFLAGS" \
	    CXX=$CXX CXXFLAGS="$CXXFLAGS" \
	    CPP=$CPP CPPFLAGS="$CPPFLAGS" \
	    LDFLAGS="$LDFLAGS" \
	    ./configure --host `./config.guess`
	make
	make install DESTDIR=$DSTROOT
    fi
)

rm -rf $BUILD

sudo chown -Rh root:wheel $DSTROOT
sudo chown root:admin $DSTROOT
sudo chmod 1775 $DSTROOT

PKG=`pwd`/../PKGS/$MACOSX_DEPLOYMENT_TARGET/$DSTNAME.pkg
[ -e $PKG ]        && ( rm -rf $PKG        || exit 1 )
[ -e $PKG.tar.gz ] && ( rm -rf $PKG.tar.gz || exit 1 )
mkdir -p ../PKGS/$MACOSX_DEPLOYMENT_TARGET

RESOURCEDIR=/tmp/$DSTNAME.resources
[ -e $RESOURCEDIR ] && ( rm -rf $RESOURCEDIR || exit 1 )
mkdir -p $RESOURCEDIR

(
    cd pkg/Resources
    for d in `find . -type d` ; do
	mkdir -p $RESOURCEDIR/$d
    done
    for f in `find . -type f -a ! -name .DS_Store` ; do
	cat $f | sed s/@MACOSX_DEPLOYMENT_TARGET@/$MACOSX_DEPLOYMENT_TARGET/g \
	    > $RESOURCEDIR/$f
    done
)

chmod +x $RESOURCEDIR/InstallationCheck

#  Remove the installation check if we don't use SDK
if [ -z "$SDKVERSION" ]; then
    rm $RESOURCEDIR/InstallationCheck
    rm $RESOURCEDIR/*.lproj/InstallationCheck.strings
    rmdir $RESOURCEDIR/*.lproj 2> /dev/null
fi

/Developer/usr/bin/packagemaker -o $PKG -r $DSTROOT \
    -f pkg/Info.plist -n $DSTVERSION -e $RESOURCEDIR -x .DS_Store -v

# packagemaker creates Description.plist in the wrong folder (the lproj
# directory corresponding to the two-letter code of the current locale)
if [ ! -e $PKG/Contents/Resources/English.lproj/Description.plist ] ; then
    mv $PKG/Contents/Resources/*.lproj/Description.plist \
	$PKG/Contents/Resources/English.lproj
    rmdir $PKG/Contents/Resources/*.lproj 2> /dev/null
fi

(
    cd `dirname $PKG`
    tar -z -c -f $PKG.tar.gz `basename $PKG`
)

rm -rf $RESOURCEDIR

if [ -z "$SDKVERSION" ]; then
    sudo rm -rf $DSTROOT
    exit 0
fi

SDKPKG=`pwd`/../PKGS/SDKs/$DSTNAME-$SDKVERSION.sdk.pkg
SDKDSTROOT=/tmp/$DSTNAME-$SDKVERSION.sdk.dst
SDK_NEXT_ROOT=/usr/local${NEXT_ROOT}

[ -e $SDKPKG ]        && (      rm -rf $SDKPKG        || exit 1 )
[ -e $SDKPKG.tar.gz ] && (      rm -rf $SDKPKG.tar.gz || exit 1 )
[ -e $SDKDSTROOT ]    && ( sudo rm -rf $SDKDSTROOT    || exit 1 )

mkdir -p ../PKGS/SDKs

for f in `find $DSTROOT -name "*.h" -o -name "*.a" -o -name "*.la" -o \
	-name "*.dylib"`; do
    ff=`sed s#$DSTROOT#$SDKDSTROOT$SDK_NEXT_ROOT# <<< $f`
    mkdir -p `dirname $ff`
    cp -pR $f $ff
done

for f in `find $SDKDSTROOT$SDK_NEXT_ROOT -type f -a -name "*.dylib"`; do
    echo "stripping $f to create stub library..."
    strip -cx $f
done

for f in `find $SDKDSTROOT$SDK_NEXT_ROOT -type f -a -name "*.la"`; do
    sed "s#libdir='\(.*\)'#libdir='$SDK_NEXT_ROOT\1'#" < $f > $f.new
    mv -f $f.new $f
done

sed s/@SDKVERSION@/$SDKVERSION/ < sdk/Info.plist > /tmp/Info.plist

sudo chown -Rh root:wheel $SDKDSTROOT
sudo chown root:admin $SDKDSTROOT
sudo chmod 1775 $SDKDSTROOT

RESOURCEDIR=/tmp/$DSTNAME.sdk.resources
[ -e $RESOURCEDIR ] && ( rm -rf $RESOURCEDIR || exit 1 )
mkdir -p $RESOURCEDIR

(
    cd sdk/Resources
    for d in `find . -type d` ; do
	mkdir -p $RESOURCEDIR/$d
    done
    for f in `find . -type f -a ! -name .DS_Store` ; do
	cat $f | sed s/@SDKVERSION@/$SDKVERSION/g \
	    | sed s#@NEXT_ROOT@#$NEXT_ROOT#g \
	    > $RESOURCEDIR/$f
    done
)

chmod +x $RESOURCEDIR/InstallationCheck

/Developer/usr/bin/packagemaker -o $SDKPKG -r $SDKDSTROOT \
    -f /tmp/Info.plist -n $DSTVERSION -e $RESOURCEDIR -x .DS_Store -v

# packagemaker creates Description.plist in the wrong folder (the lproj
# directory corresponding to the two-letter code of the current locale)
if [ ! -e $SDKPKG/Contents/Resources/English.lproj/Description.plist ] ; then
    mv $SDKPKG/Contents/Resources/*.lproj/Description.plist \
	$SDKPKG/Contents/Resources/English.lproj
    rmdir $SDKPKG/Contents/Resources/*.lproj 2> /dev/null
fi

(
    cd `dirname $SDKPKG`
    tar -z -c -f $SDKPKG.tar.gz `basename $SDKPKG`
)

rm /tmp/Info.plist
rm -rf $RESOURCEDIR

sudo rm -rf $SDKDSTROOT

sudo rm -rf $DSTROOT
