/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.input;

import com.bytezone.input.InputPanel;
import com.bytezone.input.SpringUtilities;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextAreaPanel
extends InputPanel {
    private final List<JTextArea> textFields = new ArrayList<JTextArea>();

    public TextAreaPanel(int rows) {
        int saveWidth = TextAreaPanel.LABEL_SIZE.width;
        InputPanel.setLabelWidth(0);
        this.init(new String[]{""}, rows);
        InputPanel.setLabelWidth(saveWidth);
    }

    public TextAreaPanel(String[] labels, int rows) {
        this.init(labels, rows);
    }

    public TextAreaPanel(String title, String[] labels, int rows) {
        super(title);
        this.init(labels, rows);
    }

    protected void init(String[] labels, int rows) {
        Font font = new Font("Monospaced", 0, 12);
        int i = 0;
        while (i < labels.length) {
            this.setLabel(labels[i], 1);
            JTextArea textArea = new JTextArea(rows, TEXT_LENGTH);
            JScrollPane sp = new JScrollPane(textArea);
            sp.setVerticalScrollBarPolicy(22);
            this.textFields.add(textArea);
            this.add(sp);
            textArea.setName(labels[i]);
            textArea.setFont(font);
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, labels.length, 2, OFFSET, OFFSET, GAP, GAP);
    }

    public JTextArea getItem(int index) {
        return this.textFields.get(index);
    }

    public JTextArea getItem(String label) {
        for (JTextArea textArea : this.textFields) {
            if (!textArea.getName().equals(label)) continue;
            return textArea;
        }
        return null;
    }
}

