/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.input;

import com.bytezone.input.InputPanel;
import com.bytezone.input.SpringUtilities;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class RadioButtonPanel
extends InputPanel {
    private final List<JRadioButton> buttons = new ArrayList<JRadioButton>();
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JRadioButton hiddenButton = new JRadioButton();

    public RadioButtonPanel(String labelText, String[] options) {
        this.init(labelText, options);
    }

    public RadioButtonPanel(String title, String labelText, String[] options) {
        super(title);
        this.init(labelText, options);
    }

    public RadioButtonPanel(String[][] options) {
        int saveWidth = RadioButtonPanel.LABEL_SIZE.width;
        InputPanel.setLabelWidth(0);
        this.initByColumn("", options);
        InputPanel.setLabelWidth(saveWidth);
    }

    public RadioButtonPanel(String labelText, String[][] options) {
        this.initByColumn(labelText, options);
    }

    public RadioButtonPanel(String title, String labelText, String[][] options) {
        super(title);
        this.initByColumn(labelText, options);
    }

    protected void init(String labelText, String[] options) {
        this.buttonGroup.add(this.hiddenButton);
        this.setLabel(labelText);
        int i = 0;
        while (i < options.length) {
            JRadioButton button = new JRadioButton(options[i]);
            this.buttonGroup.add(button);
            this.add(button);
            this.buttons.add(button);
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, 1, options.length + 1, OFFSET, OFFSET, GAP, GAP);
    }

    protected void initByRow(String labelText, String[][] options) {
        this.buttonGroup.add(this.hiddenButton);
        int i = 0;
        while (i < options.length) {
            this.setLabel(i == 0 ? labelText : "");
            int j = 0;
            while (j < options[0].length) {
                this.addButton(i, j, options);
                ++j;
            }
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, options.length, options[0].length + 1, OFFSET, OFFSET, GAP, GAP);
    }

    protected void initByColumn(String labelText, String[][] options) {
        this.buttonGroup.add(this.hiddenButton);
        int j = 0;
        while (j < options[0].length) {
            this.setLabel(j == 0 ? labelText : "");
            int i = 0;
            while (i < options.length) {
                this.addButton(i, j, options);
                ++i;
            }
            ++j;
        }
        SpringUtilities.makeCompactGrid(this, options[0].length, options.length + 1, OFFSET, OFFSET, GAP, GAP);
    }

    private void addButton(int i, int j, String[][] options) {
        if (j < options[i].length) {
            JRadioButton cb = new JRadioButton(options[i][j]);
            this.add(cb);
            this.buttonGroup.add(cb);
            this.buttons.add(cb);
        } else {
            this.add(new JLabel(""));
        }
    }

    public void deselectAll() {
        this.hiddenButton.setSelected(true);
    }

    public JRadioButton getIndex(int index) {
        return this.buttons.get(index);
    }

    public JRadioButton getItem(String name) {
        for (JRadioButton button : this.buttons) {
            if (!button.getText().equals(name)) continue;
            return button;
        }
        return null;
    }

    public String getSelectedText() {
        for (JRadioButton button : this.buttons) {
            if (!button.isSelected()) continue;
            return button.getText();
        }
        return "";
    }

    public void setSelected(String name) {
        for (JRadioButton button : this.buttons) {
            if (!button.getText().equals(name)) continue;
            button.setSelected(true);
            break;
        }
    }

    public void addActionListener(ActionListener listener) {
        for (JRadioButton button : this.buttons) {
            button.addActionListener(listener);
        }
    }
}

