/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultDataSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.AbstractImage;
import com.bytezone.diskbrowser.wizardry.Character;
import com.bytezone.diskbrowser.wizardry.CodedMessage;
import com.bytezone.diskbrowser.wizardry.ExperienceLevel;
import com.bytezone.diskbrowser.wizardry.Header;
import com.bytezone.diskbrowser.wizardry.Image;
import com.bytezone.diskbrowser.wizardry.ImageV2;
import com.bytezone.diskbrowser.wizardry.Item;
import com.bytezone.diskbrowser.wizardry.MazeLevel;
import com.bytezone.diskbrowser.wizardry.Message;
import com.bytezone.diskbrowser.wizardry.Monster;
import com.bytezone.diskbrowser.wizardry.PlainMessage;
import com.bytezone.diskbrowser.wizardry.Reward;
import com.bytezone.diskbrowser.wizardry.Spell;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class WizardryScenarioDisk
extends PascalDisk {
    public Header scenarioHeader;
    public List<AbstractImage> images;
    public List<Item> items;
    public List<Character> characters;
    public List<Spell> spells;
    public List<Message> messages;
    public List<Monster> monsters;
    public List<MazeLevel> levels;
    List<ExperienceLevel> experiences;
    List<Reward> rewards;
    SectorType mazeSector = new SectorType("Maze", Color.lightGray);
    SectorType monsterSector = new SectorType("Monsters", Color.black);
    SectorType itemSector = new SectorType("Items", Color.blue);
    SectorType characterSector = new SectorType("Characters", Color.magenta);
    SectorType spellSector = new SectorType("Spells", Color.orange);
    SectorType messageSector = new SectorType("Messages", Color.cyan);
    SectorType imageSector = new SectorType("Images", Color.red);
    SectorType experienceSector = new SectorType("Experience", Color.darkGray);
    SectorType treasureSector = new SectorType("Treasure", Color.pink);

    public WizardryScenarioDisk(Disk disk) {
        super(disk);
        CodedMessage.codeOffset = 185;
        Monster.counter = 0;
        Item.counter = 0;
        DefaultTreeModel model = (DefaultTreeModel)this.catalogTree.getModel();
        DefaultMutableTreeNode currentRoot = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode dataNode = this.findNode(currentRoot, "SCENARIO.DATA");
        DefaultMutableTreeNode msgNode = this.findNode(currentRoot, "SCENARIO.MESGS");
        if (dataNode == null || msgNode == null) {
            System.out.println("Wizardry data or msg node not found");
            return;
        }
        dataNode.setAllowsChildren(true);
        msgNode.setAllowsChildren(true);
        this.scenarioHeader = new Header(dataNode, this);
        AppleFileSource afs = (AppleFileSource)msgNode.getUserObject();
        this.extractMessages(msgNode, afs.getSectors());
        afs = (AppleFileSource)dataNode.getUserObject();
        List<DiskAddress> sectors = afs.getSectors();
        this.extractItems(this.linkNode("Items", "Items string", dataNode), sectors);
        this.extractRewards(this.linkNode("Rewards", "Treasure string", dataNode), sectors);
        this.extractMonsters(this.linkNode("Monsters", "Monsters string", dataNode), sectors);
        this.extractCharacters(this.linkNode("Characters", "Characters string", dataNode), sectors);
        this.extractImages(this.linkNode("Images", "Images string", dataNode), sectors);
        this.extractExperienceLevels(this.linkNode("Experience", "Experience string", dataNode), sectors);
        DefaultMutableTreeNode node = null;
        this.extractSpells(node, sectors);
        this.extractLevels(this.linkNode("Maze", "Levels string", dataNode), sectors);
        for (Character c : this.characters) {
            c.linkItems(this.items);
            c.linkSpells(this.spells);
            int type = c.getStatistics().typeInt;
            c.linkExperience(this.experiences.get(type));
        }
    }

    private DefaultMutableTreeNode linkNode(String name, String text, DefaultMutableTreeNode parent) {
        DefaultAppleFileSource afs = new DefaultAppleFileSource(name, text, (FormattedDisk)this);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(afs);
        parent.add(node);
        return node;
    }

    public static boolean isWizardryFormat(Disk disk, boolean debug) {
        byte[] buffer = disk.readBlock(2);
        int totalFiles = Utility.getShort(buffer, 16);
        if (totalFiles != 3) {
            return false;
        }
        int i = 1;
        int ptr = 32;
        while (i <= totalFiles) {
            String text = HexFormatter.getPascalString(buffer, ptr);
            if (!(text.equals("SCENARIO.DATA") || text.equals("SCENARIO.MESGS") || text.equals("WIZARDRY.CODE"))) {
                return false;
            }
            ++i;
            ptr += 26;
        }
        return true;
    }

    @Override
    public AppleFileSource getFile(String fileName) {
        return null;
    }

    public String getCatalogText() {
        return null;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        return null;
    }

    @Override
    public DataSource getFile(int fileNo) {
        return null;
    }

    private void extractRewards(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(3);
        this.rewards = new ArrayList<Reward>(sd.total);
        int max = sd.totalBlocks / 2;
        int seq = 0;
        int i = 0;
        while (i < max) {
            List<DiskAddress> blocks = this.getTwoBlocks(sd, i, sectors);
            nodeSectors.addAll(blocks);
            Object buffer = this.disk.readBlocks(blocks);
            seq = this.addReward((byte[])buffer, blocks, node, seq);
            ++i;
        }
        StringBuilder text = new StringBuilder();
        for (Reward t : this.rewards) {
            text.append(String.valueOf(t.getDump()) + "\n");
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
        DefaultDataSource dds = (DefaultDataSource)afs.getDataSource();
        dds.text = text.toString();
    }

    private int addReward(byte[] buffer, List<DiskAddress> blocks, DefaultMutableTreeNode node, int seq) {
        int recLen = 168;
        int ptr = 0;
        while (ptr < 1008) {
            byte[] data2 = new byte[recLen];
            System.arraycopy(buffer, ptr, data2, 0, recLen);
            Reward tt = new Reward("Type " + seq, data2, seq++, this.items);
            this.rewards.add(tt);
            this.addToNode((AbstractFile)tt, node, blocks, this.treasureSector);
            ptr += recLen;
        }
        return seq;
    }

    private void extractCharacters(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        Object buffer;
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(5);
        this.characters = new ArrayList<Character>(sd.total);
        int max = sd.totalBlocks / 2;
        int i = 0;
        while (i < max) {
            List<DiskAddress> blocks = this.getTwoBlocks(sd, i, sectors);
            nodeSectors.addAll(blocks);
            buffer = this.disk.readBlocks(blocks);
            this.addCharacters((byte[])buffer, blocks, node);
            ++i;
        }
        StringBuilder text = new StringBuilder();
        text.append("Name            Age Align    Race     Type       HP  St  In  Pi  Vi  Ag  Lu Status\n");
        text.append("-------------  ---- -------- -------- ---------- --  --  --  --  --  --  -- ------\n");
        buffer = this.characters.iterator();
        while (buffer.hasNext()) {
            Character ch = (Character)buffer.next();
            Character.Statistics stats = ch.getStatistics();
            Character.Attributes att = ch.getAttributes();
            text.append(String.format("%-15s %2d  %-8s %-8s %-8s  %3d", ch, stats.ageInWeeks / 52, stats.alignment, stats.race, stats.type, stats.hitsMax));
            text.append(String.format("  %2d  %2d  %2d  %2d  %2d  %2d", att.strength, att.intelligence, att.piety, att.vitality, att.agility, att.luck));
            text.append(String.format("  %5s  %s%n", stats.status, ch.isOut() ? "* OUT *" : ""));
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
        DefaultDataSource dds = (DefaultDataSource)afs.getDataSource();
        dds.text = text.toString();
    }

    private void addCharacters(byte[] buffer, List<DiskAddress> blocks, DefaultMutableTreeNode node) {
        int recLen = 208;
        int ptr = 0;
        while (ptr < 832) {
            String name;
            int nameLength = buffer[ptr] & 0xFF;
            if (!(nameLength == 195 || "UNSET".equals(name = HexFormatter.getString(buffer, ptr + 1, nameLength)) && buffer[ptr + 40] == 7)) {
                byte[] data2 = new byte[recLen];
                System.arraycopy(buffer, ptr, data2, 0, recLen);
                Character c = new Character(name, data2, this.scenarioHeader.scenarioID);
                this.characters.add(c);
                this.addToNode((AbstractFile)c, node, blocks, this.characterSector);
            }
            ptr += recLen;
        }
    }

    private void extractMonsters(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(2);
        this.monsters = new ArrayList<Monster>(sd.total);
        int max = sd.totalBlocks / 2;
        int i = 0;
        while (i < max) {
            List<DiskAddress> blocks = this.getTwoBlocks(sd, i, sectors);
            nodeSectors.addAll(blocks);
            byte[] buffer = this.disk.readBlocks(blocks);
            this.addMonsters(buffer, blocks, node);
            ++i;
        }
        StringBuilder text = new StringBuilder();
        int block = 0;
        while (block < 4) {
            text.append(" ID    Name\n");
            text.append("--- ---------------");
            int i2 = 0;
            while (i2 < 24) {
                text.append(" --");
                ++i2;
            }
            text.append("\n");
            for (Monster m : this.monsters) {
                text.append(String.valueOf(m.getDump(block)) + "\n");
            }
            text.append("\n");
            ++block;
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
        DefaultDataSource dds = (DefaultDataSource)afs.getDataSource();
        dds.text = text.toString();
    }

    private void addMonsters(byte[] buffer, List<DiskAddress> blocks, DefaultMutableTreeNode node) {
        int recLen = 158;
        int ptr = 0;
        while (ptr < 948) {
            int nameLength = buffer[ptr + 32] & 0xFF;
            if (nameLength == 0 || nameLength == 255) break;
            String itemName = HexFormatter.getString(buffer, ptr + 33, nameLength);
            byte[] data2 = new byte[recLen];
            System.arraycopy(buffer, ptr, data2, 0, recLen);
            Monster m = new Monster(itemName, data2, this.rewards, this.monsters);
            this.monsters.add(m);
            this.addToNode((AbstractFile)m, node, blocks, this.monsterSector);
            ptr += recLen;
        }
    }

    private void extractItems(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(4);
        this.items = new ArrayList<Item>(sd.total);
        int max = sd.totalBlocks / 2;
        int i = 0;
        while (i < max) {
            List<DiskAddress> blocks = this.getTwoBlocks(sd, i, sectors);
            nodeSectors.addAll(blocks);
            byte[] buffer = this.disk.readBlocks(blocks);
            this.addItems(buffer, blocks, node);
            ++i;
        }
        StringBuilder text = new StringBuilder();
        int block = 0;
        while (block < 3) {
            text.append(" ID    Name\n");
            text.append("--- ---------------");
            int i2 = 0;
            while (i2 < 24) {
                text.append(" --");
                ++i2;
            }
            text.append("\n");
            for (Item item : this.items) {
                text.append(String.valueOf(item.getDump(block)) + "\n");
            }
            text.append("\n");
            ++block;
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
        DefaultDataSource dds = (DefaultDataSource)afs.getDataSource();
        dds.text = text.toString();
    }

    private void addItems(byte[] buffer, List<DiskAddress> blocks, DefaultMutableTreeNode node) {
        int recLen = 78;
        int ptr = 0;
        while (ptr < 1014) {
            if (buffer[ptr] == 0) break;
            String itemName = HexFormatter.getPascalString(buffer, ptr);
            byte[] data2 = new byte[recLen];
            System.arraycopy(buffer, ptr, data2, 0, recLen);
            Item i = new Item(itemName, data2);
            this.items.add(i);
            this.addToNode((AbstractFile)i, node, blocks, this.itemSector);
            ptr += recLen;
        }
    }

    private void extractSpells(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        this.spells = new ArrayList<Spell>();
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>(2);
        int offset = this.scenarioHeader.scenarioID <= 2 ? 4 : 1;
        blocks.add(sectors.get(offset));
        blocks.add(sectors.get(offset + 1));
        Spell.SpellType spellType = Spell.SpellType.MAGE;
        for (DiskAddress da : blocks) {
            byte[] buffer = this.disk.readBlock(da);
            int level = 1;
            int ptr = -1;
            while (ptr < 255) {
                int start = ++ptr;
                while (ptr < 256 && buffer[ptr] != 13) {
                    ++ptr;
                }
                if (ptr == start) break;
                String spell = HexFormatter.getString(buffer, start, ptr - start);
                if (spell.startsWith("*")) {
                    spell = spell.substring(1);
                    ++level;
                }
                Spell s = Spell.getSpell(spell, spellType, level, buffer);
                this.spells.add(s);
            }
            spellType = Spell.SpellType.PRIEST;
        }
    }

    private void extractMessages(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        Message.resetMessageId();
        this.messages = new ArrayList<Message>();
        int recordLength = 42;
        int max = recordLength * 12;
        byte[] buffer = new byte[sectors.size() * max];
        int offset = 0;
        for (DiskAddress da : sectors) {
            byte[] tempBuffer = this.disk.readBlock(da);
            System.arraycopy(tempBuffer, 0, buffer, offset, max);
            offset += max;
        }
        int totalLines = 0;
        int ptr = 0;
        while (ptr < buffer.length) {
            byte sequence = buffer[ptr + recordLength - 2];
            ++totalLines;
            if (sequence == 1) {
                int totalBytes = totalLines * recordLength;
                byte[] newBuffer = new byte[totalBytes];
                int messageEnd = ptr + recordLength;
                int messageStart = messageEnd - totalBytes;
                System.arraycopy(buffer, messageStart, newBuffer, 0, totalBytes);
                Message m = this.scenarioHeader.scenarioID == 1 ? new PlainMessage(newBuffer) : new CodedMessage(newBuffer);
                this.messages.add(m);
                ArrayList<DiskAddress> messageBlocks = new ArrayList<DiskAddress>();
                int lastBlock = -1;
                int p2 = messageStart;
                while (p2 < messageEnd) {
                    int blockNo = p2 / max;
                    offset = p2 % max;
                    if (blockNo != lastBlock) {
                        messageBlocks.add(sectors.get(blockNo));
                        lastBlock = blockNo;
                    }
                    p2 += recordLength;
                }
                this.addToNode((AbstractFile)m, node, messageBlocks, this.messageSector);
                totalLines = 0;
            }
            ptr += recordLength;
        }
    }

    private void extractLevels(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(1);
        this.levels = new ArrayList<MazeLevel>(sd.total);
        int max = sd.totalBlocks / 2;
        int i = 0;
        while (i < max) {
            List<DiskAddress> blocks = this.getTwoBlocks(sd, i, sectors);
            nodeSectors.addAll(blocks);
            Object buffer = this.disk.readBlocks(blocks);
            byte[] data2 = new byte[896];
            System.arraycopy(buffer, 0, data2, 0, data2.length);
            MazeLevel mazeLevel = new MazeLevel(data2, i + 1);
            mazeLevel.setMessages(this.messages);
            mazeLevel.setMonsters(this.monsters);
            mazeLevel.setItems(this.items);
            this.levels.add(mazeLevel);
            this.addToNode((AbstractFile)mazeLevel, node, blocks, this.mazeSector);
            ++i;
        }
        StringBuilder text = new StringBuilder();
        for (MazeLevel level : this.levels) {
            text.append(String.valueOf(level.getName()) + "\n");
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
        DefaultDataSource dds = (DefaultDataSource)afs.getDataSource();
        dds.text = text.toString();
    }

    private void extractImages(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(6);
        int max = sd.totalBlocks;
        this.images = new ArrayList<AbstractImage>();
        int i = 0;
        while (i < max) {
            DiskAddress da = sectors.get(sd.dataOffset + i);
            nodeSectors.add(da);
            Object buffer = this.disk.readBlock(da);
            byte[] exactBuffer = new byte[480];
            System.arraycopy(buffer, 0, exactBuffer, 0, exactBuffer.length);
            String name = "Unknown";
            for (Monster m : this.monsters) {
                if (m.imageID != i) continue;
                name = m.genericName;
                break;
            }
            AbstractImage mi = this.scenarioHeader.scenarioID < 3 ? new Image(name, (byte[])buffer) : new ImageV2(name, exactBuffer);
            this.images.add(mi);
            this.addToNode((AbstractFile)mi, node, da, this.imageSector);
            ++i;
        }
        StringBuilder text = new StringBuilder();
        for (AbstractImage image : this.images) {
            text.append(String.valueOf(image.getName()) + "\n");
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
        DefaultDataSource dds = (DefaultDataSource)afs.getDataSource();
        dds.text = text.toString();
    }

    private void extractExperienceLevels(DefaultMutableTreeNode node, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> nodeSectors = new ArrayList<DiskAddress>();
        Header.ScenarioData sd = this.scenarioHeader.data.get(7);
        this.experiences = new ArrayList<ExperienceLevel>(sd.total);
        int max = sd.totalBlocks / 2;
        int count = 0;
        String[] classes = new String[]{"FIGHTER", "MAGE", "PRIEST", "THIEF", "BISHOP", "SAMURAI", "LORD", "NINJA"};
        int i = 0;
        while (i < max) {
            List<DiskAddress> blocks = this.getTwoBlocks(sd, i, sectors);
            nodeSectors.addAll(blocks);
            byte[] buffer = this.disk.readBlocks(blocks);
            int ptr = 0;
            while (ptr <= buffer.length) {
                if (buffer[ptr] == 0) break;
                byte[] newBuffer = new byte[78];
                System.arraycopy(buffer, ptr, newBuffer, 0, newBuffer.length);
                ExperienceLevel el = new ExperienceLevel(classes[count++], newBuffer);
                this.experiences.add(el);
                this.addToNode((AbstractFile)el, node, blocks, this.experienceSector);
                ptr += 78;
            }
            ++i;
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)node.getUserObject();
        afs.setSectors(nodeSectors);
    }

    private void addToNode(AbstractFile af, DefaultMutableTreeNode node, DiskAddress block, SectorType type) {
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>(1);
        blocks.add(block);
        this.addToNode(af, node, blocks, type);
    }

    private void addToNode(AbstractFile af, DefaultMutableTreeNode node, List<DiskAddress> blocks, SectorType type) {
        DefaultAppleFileSource dafs = new DefaultAppleFileSource(af.getName(), af, this, blocks);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(dafs);
        node.add(childNode);
        childNode.setAllowsChildren(false);
    }

    private List<DiskAddress> getTwoBlocks(Header.ScenarioData sd, int i, List<DiskAddress> sectors) {
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>(2);
        blocks.add(sectors.get(sd.dataOffset + i * 2));
        blocks.add(sectors.get(sd.dataOffset + i * 2 + 1));
        return blocks;
    }
}

