/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Wiz4Image;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Wiz5Monsters
extends AbstractFile
implements Iterable<Monster> {
    private static final int BLOCK_SIZE = 512;
    private final List<Monster> monsters = new ArrayList<Monster>();

    Wiz5Monsters(String name, byte[] buffer) {
        super(name, buffer);
        int p = 0;
        int nextBlock = buffer[p] & 0xFF;
        int nextOffset = Utility.getShort(buffer, 256);
        Monster monster = new Monster(p + 1);
        this.monsters.add(monster);
        boolean createMonster = false;
        while (nextBlock > 0) {
            int firstBlock = nextBlock;
            int firstOffset = nextOffset;
            int ndx = nextBlock * 512 + nextOffset;
            if (buffer[ndx] != 0) {
                nextBlock = buffer[ndx] & 0xFF;
                nextOffset = Utility.getShort(buffer, ndx + 1);
            } else {
                nextBlock = buffer[++p] & 0xFF;
                nextOffset = Utility.getShort(buffer, p * 2 + 256);
                createMonster = true;
            }
            int length = nextOffset > 0 ? nextOffset : 512 - firstOffset;
            monster.dataBuffers.add(new DataBuffer(firstBlock, firstOffset, length));
            if (!createMonster || nextBlock <= 0) continue;
            monster = new Monster(p + 1);
            this.monsters.add(monster);
            createMonster = false;
        }
    }

    @Override
    public Iterator<Monster> iterator() {
        return this.monsters.iterator();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        for (Monster monster : this.monsters) {
            DataBuffer dataBuffer = monster.dataBuffers.get(0);
            text.append(String.format("%02X : %02X %04X : %s%n", monster.id, dataBuffer.block, dataBuffer.offset, dataBuffer.toHexString()));
            int i = 1;
            while (i < monster.dataBuffers.size()) {
                dataBuffer = monster.dataBuffers.get(i);
                text.append(String.format("     %02X %04X : %s%n", dataBuffer.block, dataBuffer.offset, dataBuffer.toHexString()));
                ++i;
            }
            text.append("\n");
        }
        if (text.length() > 1) {
            text.deleteCharAt(text.length() - 1);
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    class DataBuffer {
        private final int block;
        private final int offset;
        private final int length;

        public DataBuffer(int block, int offset, int length) {
            this.block = block;
            this.offset = offset;
            this.length = length;
        }

        public String toHexString() {
            int p1 = this.block * 512 + this.offset;
            String s1 = HexFormatter.getHexString(Wiz5Monsters.this.buffer, p1, 3);
            String s2 = HexFormatter.getHexString(Wiz5Monsters.this.buffer, p1 + 3, this.length - 3);
            return String.valueOf(s1) + " : " + s2;
        }

        public String toString() {
            return HexFormatter.format(Wiz5Monsters.this.buffer, this.block * 512 + this.offset, this.length);
        }
    }

    class Monster {
        private final int id;
        private final List<DataBuffer> dataBuffers = new ArrayList<DataBuffer>();
        private Wiz4Image image;
        private byte[] data;

        public Monster(int id) {
            this.id = id;
        }

        public Wiz4Image getImage() {
            if (this.image == null) {
                int length = 0;
                for (DataBuffer dataBuffer : this.dataBuffers) {
                    length += dataBuffer.length - 3;
                }
                this.data = new byte[length];
                int ptr = 0;
                for (DataBuffer dataBuffer : this.dataBuffers) {
                    int offset = dataBuffer.block * 512 + dataBuffer.offset + 3;
                    System.arraycopy(Wiz5Monsters.this.buffer, offset, this.data, ptr, dataBuffer.length - 3);
                    ptr += dataBuffer.length - 3;
                }
                this.image = new Wiz4Image("Image " + this.id, this.data, 10, 6);
            }
            return this.image;
        }

        List<Integer> getBlocks() {
            ArrayList<Integer> blocks = new ArrayList<Integer>();
            for (DataBuffer dataBuffer : this.dataBuffers) {
                blocks.add(dataBuffer.block);
            }
            return blocks;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            for (DataBuffer dataBuffer : this.dataBuffers) {
                text.append(dataBuffer);
                text.append("\n");
            }
            return text.toString();
        }
    }
}

