/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.wizardry.Item;
import com.bytezone.diskbrowser.wizardry.Monster;
import java.util.ArrayList;
import java.util.List;

class Reward
extends AbstractFile {
    static String[] types = new String[]{"gold", "item"};
    static final int SEGMENT_LENGTH = 18;
    int id;
    int totalElements;
    List<RewardElement> elements;
    List<Item> items;
    List<Monster> goldMonsters = new ArrayList<Monster>();
    List<Monster> chestMonsters = new ArrayList<Monster>();

    Reward(String name, byte[] buffer, int id, List<Item> items) {
        super(name, buffer);
        this.id = id;
        this.items = items;
        this.totalElements = buffer[4];
        this.elements = new ArrayList<RewardElement>(this.totalElements);
        int i = 0;
        while (i < this.totalElements) {
            byte[] buffer2 = new byte[18];
            System.arraycopy(buffer, i * 18, buffer2, 0, 18);
            this.elements.add(new RewardElement(buffer2));
            ++i;
        }
    }

    public void addMonster(Monster monster, int location) {
        if (location == 0) {
            this.goldMonsters.add(monster);
        } else {
            this.chestMonsters.add(monster);
        }
    }

    @Override
    public String getText() {
        return this.getText(true);
    }

    public String getText(boolean showLinks) {
        StringBuilder text = new StringBuilder();
        for (RewardElement re : this.elements) {
            text.append(String.valueOf(re.getDetail()) + "\n");
        }
        if (showLinks) {
            if (this.goldMonsters.size() > 0) {
                text.append("Without chest:\n\n");
                for (Monster m : this.goldMonsters) {
                    text.append("   " + m + "\n");
                }
                text.append("\n");
            }
            if (this.chestMonsters.size() > 0) {
                text.append("With chest:\n\n");
                for (Monster m : this.chestMonsters) {
                    text.append("   " + m + "\n");
                }
            }
        }
        return text.toString();
    }

    public String getDump() {
        StringBuilder text = new StringBuilder();
        int seq = 0;
        for (RewardElement re : this.elements) {
            text.append(seq++ == 0 ? String.format("%02X  :  ", this.id) : "       ");
            text.append(re + "\n");
        }
        return text.toString();
    }

    private class RewardElement {
        int type;
        int odds;
        byte[] buffer;

        public RewardElement(byte[] buffer) {
            this.buffer = buffer;
            this.type = buffer[8];
            this.odds = buffer[6];
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            int i = 0;
            while (i < 18) {
                text.append(String.format("%3d  ", this.buffer[i] & 0xFF));
                i += 2;
            }
            return text.toString();
        }

        public String getDetail() {
            StringBuilder text = new StringBuilder();
            text.append("Odds ............ " + this.odds + "%\n");
            switch (this.type) {
                case 0: {
                    text.append("Gold ............ " + this.buffer[10] + "d" + this.buffer[12] + "\n");
                    break;
                }
                case 1: {
                    int lo = this.buffer[10] & 0xFF;
                    int qty = this.buffer[16] & 0xFF;
                    boolean title = true;
                    String[] lineItem = new String[4];
                    int i = lo;
                    int max = lo + qty;
                    while (i <= max) {
                        String lineTitle = title ? "Items ..........." : "";
                        title = false;
                        int j = 0;
                        while (j < lineItem.length) {
                            lineItem[j] = i + j < Reward.this.items.size() ? Reward.this.items.get(i + j).getName() : "";
                            ++j;
                        }
                        text.append(String.format("%-17s %-16s %-16s %-16s %-16s%n", lineTitle, lineItem[0], lineItem[1], lineItem[2], lineItem[3]));
                        i += lineItem.length;
                    }
                    break;
                }
                default: {
                    System.out.println("Unknown reward type " + this.type);
                }
            }
            return text.toString();
        }
    }
}

