/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class Relocator
extends AbstractFile {
    private final int checkByte;
    private final List<DiskRecord> diskRecords = new ArrayList<DiskRecord>();
    private final int[] diskBlocks = new int[2048];
    private final int[] diskOffsets = new int[2048];

    public Relocator(String name, byte[] buffer) {
        super(name, buffer);
        this.checkByte = Utility.getShort(buffer, 0);
        int ptr = 2;
        while (buffer[ptr] != 0) {
            DiskRecord diskRecord = new DiskRecord(buffer, ptr);
            this.diskRecords.add(diskRecord);
            ptr += diskRecord.size();
        }
        for (DiskRecord diskRecord : this.diskRecords) {
            for (DiskSegment diskSegment : diskRecord.diskSegments) {
                this.addLogicalBlock((byte)diskRecord.diskNumber, diskSegment);
            }
        }
    }

    private void addLogicalBlock(byte disk, DiskSegment diskSegment) {
        int lo = diskSegment.logicalBlock;
        int hi = diskSegment.logicalBlock + diskSegment.segmentLength;
        int i = lo;
        int count = 0;
        while (i < hi) {
            this.diskBlocks[i] = disk;
            this.diskOffsets[i] = diskSegment.physicalBlock + count;
            ++i;
            ++count;
        }
    }

    public void createNewBuffer(Disk[] dataDisks) {
        AppleDisk master = (AppleDisk)dataDisks[0];
        int logicalBlock = 0;
        while (logicalBlock < this.diskBlocks.length) {
            int diskNo = this.diskBlocks[logicalBlock];
            if (diskNo > 0) {
                Disk disk = dataDisks[diskNo];
                byte[] temp = disk.readBlock(this.diskOffsets[logicalBlock]);
                DiskAddress da = master.getDiskAddress(logicalBlock);
                master.writeBlock(da, temp);
            }
            ++logicalBlock;
        }
    }

    @Override
    public String getText() {
        int size;
        StringBuilder text = new StringBuilder();
        text.append("Pascal Relocator\n\n");
        text.append(String.format("Check byte..... %04X%n%n", this.checkByte));
        for (DiskRecord diskRecord : this.diskRecords) {
            text.append(diskRecord);
            text.append("\n");
        }
        ArrayList<String> lines = new ArrayList<String>();
        String heading = " Logical   Size  Disk  Physical";
        String underline = "---------  ----  ----  ---------";
        int first = 0;
        int lastDisk = this.diskBlocks[0];
        int lastOffset = this.diskOffsets[0];
        int i = 0;
        while (i < this.diskBlocks.length) {
            if (this.diskBlocks[i] != lastDisk || this.diskOffsets[i] != lastOffset + i - first) {
                size = i - first;
                if (lastDisk > 0) {
                    lines.add(String.format("%03X - %03X   %03X    %d   %03X - %03X", first, i - 1, size, lastDisk, lastOffset, lastOffset + size - 1));
                } else {
                    lines.add(String.format("%03X - %03X   %03X", first, i - 1, size));
                }
                first = i;
                lastDisk = this.diskBlocks[i];
                lastOffset = this.diskOffsets[i];
            }
            ++i;
        }
        if (lastDisk > 0) {
            int max = this.diskBlocks.length;
            size = max - first;
            lines.add(String.format("%03X - %03X   %03X    %d   %03X - %03X", first, max - 1, size, lastDisk, lastOffset, lastOffset + size - 1));
        }
        i = lines.size() - 1;
        while (i >= 0) {
            String line = (String)lines.get(i);
            if (line.length() > 20) break;
            lines.remove(i);
            --i;
        }
        text.append(String.format("   %s        %s%n   %s       %s%n", heading, heading, underline, underline));
        int offset = (lines.size() + 1) / 2;
        int pairs = lines.size() / 2;
        int i2 = 0;
        while (i2 < pairs) {
            text.append(String.format("   %-35s    %s%n", lines.get(i2), lines.get(i2 + offset)));
            ++i2;
        }
        if (offset != pairs) {
            text.append(String.format("   %s%n", lines.get(pairs)));
        }
        return text.toString();
    }

    private class DiskRecord {
        int diskNumber;
        int totDiskSegments;
        List<DiskSegment> diskSegments = new ArrayList<DiskSegment>();

        public DiskRecord(byte[] buffer, int ptr) {
            this.diskNumber = Utility.getShort(buffer, ptr);
            this.totDiskSegments = Utility.intValue(buffer[ptr + 2], buffer[ptr + 4]);
            ptr += 4;
            int i = 0;
            while (i < this.totDiskSegments) {
                this.diskSegments.add(new DiskSegment(buffer, ptr));
                ptr += 6;
                ++i;
            }
        }

        int size() {
            return 4 + this.diskSegments.size() * 6;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Disk number.... %04X%n", this.diskNumber));
            text.append(String.format("Segments....... %04X%n%n", this.totDiskSegments));
            text.append(String.format(" Seg   Skip   Size     Logical      Physical%n", new Object[0]));
            text.append(String.format(" ---   ----   ----   -----------   -----------%n", new Object[0]));
            int count = 1;
            int last = 0;
            int skip = 0;
            for (DiskSegment segment : this.diskSegments) {
                if (segment.logicalBlock > last) {
                    int end = segment.logicalBlock - 1;
                    skip = end - last + 1;
                }
                last = segment.logicalBlock + segment.segmentLength;
                text.append(String.format("  %02X   %04X  %s %n", count++, skip, segment));
            }
            return text.toString();
        }
    }

    private class DiskSegment {
        int logicalBlock;
        int physicalBlock;
        int segmentLength;

        public DiskSegment(byte[] buffer, int ptr) {
            this.logicalBlock = Utility.getShort(buffer, ptr);
            this.physicalBlock = Utility.getShort(buffer, ptr + 2);
            this.segmentLength = Utility.getShort(buffer, ptr + 4);
        }

        public String toString() {
            return String.format(" %04X   %04X - %04X   %04X - %04X", this.segmentLength, this.logicalBlock, this.logicalBlock + this.segmentLength - 1, this.physicalBlock, this.physicalBlock + this.segmentLength - 1);
        }
    }
}

