/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.wizardry.Dice;
import com.bytezone.diskbrowser.wizardry.Reward;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

class Monster
extends AbstractFile {
    public final String genericName;
    public final String realName;
    public final int monsterID;
    List<Monster> monsters;
    Reward goldReward;
    Reward chestReward;
    public final int type;
    public final int imageID;
    int rewardTable1;
    int rewardTable2;
    public final int partnerID;
    public final int partnerOdds;
    public final int armourClass;
    public final int recsn;
    public final int mageSpellLevel;
    public final int priestSpellLevel;
    int levelDrain;
    int healPts;
    int breathe;
    int unaffect;
    int unique;
    int resistance;
    int abilities;
    public final Dice groupSize;
    public final Dice hitPoints;
    List<Dice> damage = new ArrayList<Dice>();
    static int counter = 0;
    static boolean debug = true;
    static int[] pwr;
    static int[] weight1;
    static int[] weight2;
    public static String[] monsterClass;
    private static int[] experience;
    int expHitPoints;
    int expMage;
    int expPriest;
    int expDrain;
    int expHeal;
    int expAc;
    int expDamage;
    int expUnaffect;
    int expFlags1;
    int expFlags2;

    static {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        nArray[5] = 16;
        nArray[6] = 32;
        nArray[7] = 64;
        nArray[8] = 128;
        nArray[9] = 256;
        nArray[10] = 512;
        pwr = nArray;
        int[] nArray2 = new int[11];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 4;
        nArray2[4] = 8;
        nArray2[5] = 16;
        nArray2[6] = 32;
        nArray2[7] = 64;
        nArray2[8] = 253;
        nArray2[9] = 506;
        weight1 = nArray2;
        int[] nArray3 = new int[8];
        nArray3[1] = 60;
        nArray3[2] = 120;
        nArray3[3] = 180;
        nArray3[4] = 300;
        nArray3[5] = 540;
        nArray3[6] = 1020;
        weight2 = nArray3;
        monsterClass = new String[]{"Fighter", "Mage", "Priest", "Thief", "Midget", "Giant", "Mythical", "Dragon", "Animal", "Were", "Undead", "Demon", "Insect", "Enchanted"};
        experience = new int[]{55, 235, 415, 230, 380, 620, 840, 520, 550, 350, 475, 515, 920, 600, 735, 520, 795, 780, 990, 795, 1360, 1320, 1275, 680, 960, 600, 755, 1120, 2075, 870, 960, 600, 1120, 2435, 1080, 2280, 975, 875, 1135, 1200, 620, 740, 1460, 1245, 960, 1405, 1040, 1220, 1520, 1000, 960, 2340, 2160, 2395, 790, 1140, 1235, 1790, 1720, 2240, 1475, 1540, 1720, 1900, 1240, 1220, 1020, 20435, 5100, 3515, 2115, 2920, 2060, 2140, 1400, 1640, 1280, 4450, 42840, 3300, 40875, 5000, 3300, 2395, 1935, 1600, 3330, 44090, 40840, 5200, 4155, 3000, 9200, 3160, 7460, 7320, 15880, 1600, 2200, 1000, 1900};
    }

    Monster(String name, byte[] buffer, List<Reward> rewards, List<Monster> monsters) {
        super(name, buffer);
        this.realName = name;
        this.genericName = HexFormatter.getPascalString(buffer, 0);
        this.monsterID = counter++;
        this.monsters = monsters;
        this.goldReward = rewards.get(buffer[136]);
        this.chestReward = rewards.get(buffer[138]);
        this.goldReward.addMonster(this, 0);
        this.chestReward.addMonster(this, 1);
        this.imageID = buffer[64];
        this.groupSize = new Dice(buffer, 66);
        this.hitPoints = new Dice(buffer, 72);
        this.type = buffer[78];
        this.armourClass = buffer[80];
        this.recsn = buffer[82];
        int i = 0;
        int ptr = 84;
        while (i < 8) {
            if (buffer[ptr] == 0) break;
            this.damage.add(new Dice(buffer, ptr));
            ++i;
            ptr += 6;
        }
        this.levelDrain = buffer[132];
        this.healPts = buffer[134];
        this.rewardTable1 = buffer[136];
        this.rewardTable2 = buffer[138];
        this.partnerID = buffer[140];
        this.partnerOdds = buffer[142];
        this.mageSpellLevel = buffer[144];
        this.priestSpellLevel = buffer[146];
        this.unique = buffer[148];
        this.breathe = buffer[150];
        this.unaffect = buffer[152];
        this.resistance = buffer[154];
        this.abilities = buffer[156];
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int totalExperience = this.setExperience();
        text.append("ID .............. " + this.monsterID);
        text.append("\nMonster name .... " + this.realName);
        text.append("\nGeneric name .... " + this.genericName);
        text.append("\n\nImage ID ........ " + this.imageID);
        text.append("\nGroup size ...... " + this.groupSize);
        text.append("\nHit points ...... " + this.hitPoints);
        text.append("\n\nMonster class ... " + this.type + "   " + monsterClass[this.type]);
        text.append("\nArmour class .... " + this.armourClass);
        text.append("\n\n# damage ........ " + this.recsn);
        text.append("\nDamage .......... " + this.getDamage());
        text.append("\n\nLevel drain ..... " + this.levelDrain);
        text.append("\nHeal pts? ....... " + this.healPts);
        text.append("\n\nPartner ID ...... " + this.partnerID);
        if (this.partnerOdds > 0) {
            text.append("   " + this.monsters.get(this.partnerID).getName());
        }
        text.append("\nPartner odds .... " + this.partnerOdds + "%");
        text.append("\n\nMage level ...... " + this.mageSpellLevel);
        text.append("\nPriest level .... " + this.priestSpellLevel);
        text.append("\n\nUnique .......... " + this.unique);
        text.append("\nBreathe ......... " + this.breathe);
        text.append("\nUnaffect ........ " + this.unaffect);
        text.append("\n\nResistance ...... " + String.format("%02X", this.resistance));
        text.append("\nAbilities ....... " + String.format("%02X", this.abilities));
        text.append(String.format("%n%nExperience ...... %,7d  %,7d", totalExperience, experience[this.monsterID]));
        text.append("\n\n===== Gold reward ======");
        text.append("\n" + this.goldReward.getText(false));
        text.append("===== Chest reward =====");
        text.append("\n" + this.chestReward.getText(false));
        while (text.charAt(text.length() - 1) == '\n') {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private int setExperience() {
        this.expHitPoints = this.hitPoints.qty * this.hitPoints.sides * (this.breathe == 0 ? 20 : 40);
        this.expMage = this.getBonus(35, this.mageSpellLevel);
        this.expPriest = this.getBonus(35, this.priestSpellLevel);
        this.expDrain = this.getBonus(200, this.levelDrain);
        this.expHeal = this.getBonus(90, this.healPts);
        this.expAc = 40 * (11 - this.armourClass);
        this.expDamage = this.recsn <= 1 ? 0 : this.getBonus(30, this.recsn);
        this.expUnaffect = this.unaffect == 0 ? 0 : this.getBonus(40, this.unaffect / 10 + 1);
        this.expFlags1 = this.getBonus(35, Integer.bitCount(this.resistance & 0x7E));
        this.expFlags2 = this.getBonus(40, Integer.bitCount(this.abilities & 0x7F));
        return this.expHitPoints + this.expMage + this.expPriest + this.expDrain + this.expHeal + this.expAc + this.expDamage + this.expUnaffect + this.expFlags1 + this.expFlags2;
    }

    private int getBonus(int base, int multiplier) {
        if (multiplier == 0) {
            return 0;
        }
        int total = base;
        int i = 1;
        while (i < multiplier) {
            total *= 2;
            ++i;
        }
        return total + total / 10000 * 10000;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    public String getName() {
        return this.realName;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getDamage() {
        StringBuilder text = new StringBuilder();
        for (Dice d : this.damage) {
            text.append(d + ", ");
        }
        text.deleteCharAt(text.length() - 1);
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    public String getDump(int block) {
        StringBuilder line = new StringBuilder(String.format("%3d %-16s", this.monsterID, this.realName));
        int lo = block == 0 ? 64 : (block == 1 ? 88 : (block == 2 ? 112 : 136));
        int hi = lo + 24;
        if (hi > this.buffer.length) {
            hi = this.buffer.length;
        }
        int i = lo;
        while (i < hi) {
            line.append(String.format("%02X ", this.buffer[i]));
            ++i;
        }
        if (block == 3) {
            int exp = this.setExperience();
            line.append(String.format(" %,6d", exp));
            if (exp != experience[this.monsterID]) {
                line.append(String.format("  %,6d", experience[this.monsterID]));
            }
        }
        return line.toString();
    }

    public boolean match(int monsterID) {
        return this.monsterID == monsterID;
    }

    public String toString() {
        return this.realName;
    }
}

